/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.chat.processor.global;

import java.util.LinkedHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.sunlight.module.chat.ChatModule;
import su.nightexpress.sunlight.module.chat.context.ChatContext;
import su.nightexpress.sunlight.module.chat.processor.ChatProcessor;

public class AntiCapsProcessor
implements ChatProcessor<ChatContext> {
    @Override
    public void preProcess(@NotNull ChatModule module, @NotNull ChatContext context) {
        context.setMessage(this.moderateUpperCase(module, context.getMessage()));
    }

    @Override
    public void postProcess(@NotNull ChatModule module, @NotNull ChatContext context) {
    }

    @NotNull
    private String moderateUpperCase(@NotNull ChatModule module, @NotNull String message) {
        double threshold;
        String[] words = message.split(" ");
        int totalUpperCase = 0;
        int lengthThreshold = module.getSettings().getAntiCapsLengthThreshold();
        LinkedHashMap<Integer, Function> indexesToModerate = new LinkedHashMap<Integer, Function>();
        for (int index2 = 0; index2 < words.length; ++index2) {
            String playerName;
            int playerUpperCount;
            String word = words[index2];
            int upperCaseCount = AntiCapsProcessor.countUpperCaseLetters(word);
            Player player = Players.getPlayer((String)word);
            if (player != null && upperCaseCount > (playerUpperCount = AntiCapsProcessor.countUpperCaseLetters(playerName = player.getName()))) {
                totalUpperCase += upperCaseCount;
                indexesToModerate.put(index2, string -> playerName);
                continue;
            }
            if (word.length() >= lengthThreshold) {
                totalUpperCase += upperCaseCount;
            }
            indexesToModerate.put(index2, arg_0 -> ((LowerCase)LowerCase.USER_LOCALE).apply(arg_0));
        }
        int messageLength = Stream.of(words).mapToInt(String::length).sum();
        double percent = (double)totalUpperCase / (double)messageLength;
        if (percent < (threshold = (double)module.getSettings().getAntiCapsUpperCaseThreshold() / 100.0)) {
            return message;
        }
        StringBuilder builder = new StringBuilder();
        indexesToModerate.forEach((index, function) -> {
            String moderated = (String)function.apply(words[index]);
            if (!builder.isEmpty()) {
                builder.append(" ");
            }
            builder.append(moderated);
        });
        return builder.toString();
    }

    private static int countUpperCaseLetters(@NotNull String string) {
        int count = 0;
        for (char c : string.toCharArray()) {
            if (!Character.isLetter(c) || Character.isWhitespace(c) || !Character.isUpperCase(c)) continue;
            ++count;
        }
        return count;
    }
}

