/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.chat.processor.chat;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.time.TimeFormatType;
import su.nightexpress.nightcore.util.time.TimeFormats;
import su.nightexpress.sunlight.module.chat.ChatModule;
import su.nightexpress.sunlight.module.chat.ChatProperties;
import su.nightexpress.sunlight.module.chat.cache.UserChatCache;
import su.nightexpress.sunlight.module.chat.context.MessageContext;
import su.nightexpress.sunlight.module.chat.core.ChatLang;
import su.nightexpress.sunlight.module.chat.core.ChatPerms;
import su.nightexpress.sunlight.module.chat.mention.ChatMention;
import su.nightexpress.sunlight.module.chat.mention.PlayerMention;
import su.nightexpress.sunlight.module.chat.processor.MessageProcessor;
import su.nightexpress.sunlight.user.SunUser;
import su.nightexpress.sunlight.user.UserManager;

public class MentionProcessor
implements MessageProcessor {
    private final Pattern pattern;
    private final UserManager userManager;
    private final Map<String, ChatMention> mentions;

    public MentionProcessor(@NotNull Pattern pattern, @NotNull UserManager userManager) {
        this.pattern = pattern;
        this.userManager = userManager;
        this.mentions = new HashMap<String, ChatMention>();
    }

    @Override
    public void preProcess(@NotNull ChatModule module, @NotNull MessageContext context) {
        Player player = context.getPlayer();
        UserChatCache cache = context.getCache();
        String format = context.getFormat();
        int mentionsLimit = player.hasPermission(ChatPerms.BYPASS_MENTION_AMOUNT) ? -1 : module.getSettings().getMentionsLimit();
        int mentionsCount = 0;
        Matcher matcher = this.pattern.matcher(format);
        StringBuilder builder = new StringBuilder(format.length() + 50);
        while (matcher.find()) {
            PlayerMention playerMention;
            String mentionName = matcher.group(1);
            Runnable appendRaw = () -> matcher.appendReplacement(builder, Matcher.quoteReplacement(matcher.group(0)));
            ChatMention mention = this.getMention(module, context, mentionName);
            if (mention == null) {
                appendRaw.run();
                continue;
            }
            if (mention instanceof PlayerMention && (playerMention = (PlayerMention)mention).isApplicable(player)) {
                appendRaw.run();
                continue;
            }
            if (!ChatPerms.MENTION.hasChildAccess((CommandSender)player, LowerCase.INTERNAL.apply(mentionName))) {
                appendRaw.run();
                continue;
            }
            if (mentionsLimit >= 0 && mentionsCount >= mentionsLimit) {
                appendRaw.run();
                break;
            }
            if (cache.hasMentionCooldown(mentionName)) {
                module.sendPrefixed(ChatLang.MENTION_ERROR_COOLDOWN, (CommandSender)player, replacer -> replacer.with("%time%", () -> TimeFormats.formatDuration((long)cache.getMentionCooldownTimestamp(mentionName), (TimeFormatType)TimeFormatType.LITERAL)).with("%name%", () -> mentionName));
                appendRaw.run();
                continue;
            }
            this.mentions.put(LowerCase.INTERNAL.apply(mentionName), mention);
            matcher.appendReplacement(builder, mention.getFormat());
            ++mentionsCount;
        }
        matcher.appendTail(builder);
        context.setFormat(builder.toString());
    }

    @Override
    public void postProcess(@NotNull ChatModule module, @NotNull MessageContext context) {
        Player player = context.getPlayer();
        HashSet targets = new HashSet();
        boolean hasBypass = player.hasPermission(ChatPerms.BYPASS_MENTION_COOLDOWN);
        int cooldown = module.getSettings().getMentionsCooldown();
        this.mentions.forEach((id, mention) -> {
            context.getViewers().forEach(sender -> {
                SunUser targetUser;
                Player target;
                if (sender instanceof Player && mention.isApplicable(target = (Player)sender) && (targetUser = (SunUser)this.userManager.getOrFetch(target)).getPropertyOrDefault(ChatProperties.MENTIONS).booleanValue()) {
                    targets.add(target);
                }
            });
            if (!hasBypass && cooldown > 0) {
                context.getCache().setMentionCooldown((String)id, cooldown);
            }
        });
        module.sendPrefixed(ChatLang.MENTION_NOTIFY, targets, replacer -> replacer.with(CommonPlaceholders.PLAYER.resolver((Object)context.getPlayer())));
    }

    @Nullable
    private ChatMention getMention(@NotNull ChatModule module, @NotNull MessageContext context, @NotNull String name) {
        ChatMention mention = module.getSettings().getCustomMentions().get(LowerCase.INTERNAL.apply(name));
        if (mention != null) {
            return mention;
        }
        Player player = Bukkit.getPlayerExact((String)name);
        if (player == null) {
            return null;
        }
        if (!context.getViewers().contains(player)) {
            return null;
        }
        String format = (String)CommonPlaceholders.PLAYER.replacer((Object)player).apply(module.getSettings().getMentionsFormat());
        return new PlayerMention(player.getName(), format);
    }
}

