/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.chat.format;

import java.util.Set;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.config.Writeable;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.nightcore.util.Players;

public class FormatDefinition
implements Writeable {
    private final int priority;
    private final String format;
    private final Set<String> applicableRanks;

    public FormatDefinition(int priority, @NotNull String format, @NotNull Set<String> applicableRanks) {
        this.priority = priority;
        this.format = format;
        this.applicableRanks = applicableRanks;
    }

    @NotNull
    public static FormatDefinition read(@NotNull FileConfig config, @NotNull String path) {
        int priority = config.getInt(path + ".Priority");
        String format = config.getString(path + ".Format", "%player_name%: %format%");
        Set applicableRanks = Lists.modify((Set)config.getStringSet(path + ".Ranks"), arg_0 -> ((LowerCase)LowerCase.INTERNAL).apply(arg_0));
        return new FormatDefinition(priority, format, applicableRanks);
    }

    public void write(@NotNull FileConfig config, @NotNull String path) {
        config.set(path + ".Priority", (Object)this.priority);
        config.set(path + ".Format", (Object)this.format);
        config.set(path + ".Ranks", this.applicableRanks);
    }

    public boolean isApplicable(@NotNull Player player) {
        if (this.applicableRanks.isEmpty()) {
            return false;
        }
        if (this.applicableRanks.contains("*")) {
            return true;
        }
        Set groups = Players.getInheritanceGroups((Player)player);
        return this.applicableRanks.stream().anyMatch(groups::contains);
    }

    public int getPriority() {
        return this.priority;
    }

    @NotNull
    public String getFormat() {
        return this.format;
    }

    @NotNull
    public Set<String> getApplicableRanks() {
        return this.applicableRanks;
    }
}

