/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.chat.command;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.config.Lang;
import su.nightexpress.sunlight.module.chat.ChatModule;
import su.nightexpress.sunlight.module.chat.core.ChatLang;
import su.nightexpress.sunlight.module.chat.core.ChatPerms;

public class RoleplayCommands
extends AbstractCommandProvider {
    private final ChatModule module;

    public RoleplayCommands(@NotNull SunLightPlugin plugin, @NotNull ChatModule module) {
        super(plugin);
        this.module = module;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral("me", true, new String[]{"me"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(ChatLang.COMMAND_ME_DESC)).permission(ChatPerms.COMMAND_ME)).withArguments(new ArgumentNodeBuilder[]{Arguments.greedyString((String)"text").localized(Lang.COMMAND_ARGUMENT_NAME_TEXT)}).executes(this::showAction));
    }

    private boolean showAction(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        String text = arguments.getString("text");
        String format = this.module.getSettings().getRoleplayMeFormat();
        String formatted = PlaceholderContext.builder().with("%message%", () -> text).with(CommonPlaceholders.PLAYER.resolver((Object)player)).build().apply(format);
        this.plugin.getServer().getOnlinePlayers().forEach(other -> Players.sendMessage((CommandSender)other, (String)formatted));
        return true;
    }
}

