/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.chat.command;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.sunlight.SLUtils;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.chat.ChatModule;
import su.nightexpress.sunlight.module.chat.core.ChatLang;
import su.nightexpress.sunlight.module.chat.core.ChatPerms;

public class ClearChatCommandProvider
extends AbstractCommandProvider {
    private final ChatModule module;

    public ClearChatCommandProvider(@NotNull SunLightPlugin plugin, @NotNull ChatModule module) {
        super(plugin);
        this.module = module;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral("clearchat", true, new String[]{"clearchat"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(ChatLang.COMMAND_CLEAR_CHAT_DESC)).permission(ChatPerms.COMMAND_CLEARCHAT)).executes(this::clearChat));
    }

    private boolean clearChat(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Collection players = this.plugin.getServer().getOnlinePlayers();
        for (int i = 0; i < 100; ++i) {
            players.forEach(player -> player.sendMessage(" "));
        }
        this.module.broadcastPrefixed(ChatLang.CLEAR_CHAT_NOTIFY, replacer -> replacer.with("%name%", () -> SLUtils.getSenderName(context.getSender())));
        return true;
    }
}

