/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.chat.channel;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.placeholder.PlaceholderResolvable;
import su.nightexpress.nightcore.util.placeholder.PlaceholderResolver;
import su.nightexpress.sunlight.module.chat.ChatPlaceholders;
import su.nightexpress.sunlight.module.chat.channel.ChannelAccessibility;
import su.nightexpress.sunlight.module.chat.channel.ChannelCommand;
import su.nightexpress.sunlight.module.chat.channel.ChannelDisplay;
import su.nightexpress.sunlight.module.chat.channel.ChannelDistance;
import su.nightexpress.sunlight.module.chat.channel.ChannelDistanceType;
import su.nightexpress.sunlight.module.chat.channel.ChannelPrefix;
import su.nightexpress.sunlight.module.chat.channel.ChannelSchema;
import su.nightexpress.sunlight.module.chat.core.ChatPerms;

public class ChatChannel
implements PlaceholderResolvable {
    private final Path path;
    private final String id;
    private final Set<UUID> players;
    private final ChannelDisplay display;
    private final ChannelAccessibility accessibility;
    private final ChannelDistance distance;
    private final ChannelCommand command;
    private final ChannelPrefix prefix;

    private ChatChannel(@Nullable Path path, @NotNull String id, @NotNull ChannelDisplay display, @NotNull ChannelAccessibility accessibility, @NotNull ChannelDistance distance, @NotNull ChannelCommand command, @NotNull ChannelPrefix prefix) {
        this.path = path;
        this.id = id;
        this.players = new HashSet<UUID>();
        this.display = display;
        this.accessibility = accessibility;
        this.distance = distance;
        this.command = command;
        this.prefix = prefix;
    }

    @NotNull
    public static ChatChannel fromFile(@NotNull Path file) {
        FileConfig config = FileConfig.load((Path)file);
        String fileName = file.getFileName().toString();
        String id = fileName.substring(0, fileName.length() - ".yml".length());
        String name = (String)ChannelSchema.NAME.resolveWithDefaults(config);
        String format = (String)ChannelSchema.FORMAT.resolveWithDefaults(config);
        boolean autoJoin = (Boolean)ChannelSchema.AUTO_JOIN.resolveWithDefaults(config);
        boolean permissionToListen = (Boolean)ChannelSchema.PERMISSION_TO_LISTEN.resolveWithDefaults(config);
        boolean permissionToSpeak = (Boolean)ChannelSchema.PERMISSION_TO_SPEAK.resolveWithDefaults(config);
        int messageCooldown = (Integer)ChannelSchema.MESSAGE_COOLDOWN.resolveWithDefaults(config);
        ChannelDistanceType distanceType = (ChannelDistanceType)((Object)ChannelSchema.DISTANCE_TYPE.resolveWithDefaults(config));
        double distanceRange = (Double)ChannelSchema.DISTANCE_RANGE.resolveWithDefaults(config);
        boolean prefixEnabled = (Boolean)ChannelSchema.PREFIX_ENABLED.resolveWithDefaults(config);
        String prefixValue = (String)ChannelSchema.PREFIX_VALUE.resolveWithDefaults(config);
        ChannelDisplay display = new ChannelDisplay(name, format);
        ChannelAccessibility accessibility = new ChannelAccessibility(autoJoin, permissionToListen, permissionToSpeak, messageCooldown);
        ChannelDistance distance = new ChannelDistance(distanceType, distanceRange);
        ChannelCommand command = new ChannelCommand(false, "");
        ChannelPrefix prefix = new ChannelPrefix(prefixEnabled, prefixValue);
        config.saveChanges();
        return new ChatChannel(file, id, display, accessibility, distance, command, prefix);
    }

    @NotNull
    public static ChatChannel create(@NotNull String id, @NotNull ChannelDisplay display, @NotNull ChannelAccessibility accessibility, @NotNull ChannelDistance distance, @NotNull ChannelCommand command, @NotNull ChannelPrefix prefix) {
        return new ChatChannel(null, id, display, accessibility, distance, command, prefix);
    }

    public void write(@NotNull FileConfig config) {
        ChannelSchema.NAME.writeValue(config, (Object)this.display.name());
        ChannelSchema.FORMAT.writeValue(config, (Object)this.display.format());
        ChannelSchema.AUTO_JOIN.writeValue(config, (Object)this.accessibility.autoJoin());
        ChannelSchema.PERMISSION_TO_LISTEN.writeValue(config, (Object)this.accessibility.permissionToListen());
        ChannelSchema.PERMISSION_TO_SPEAK.writeValue(config, (Object)this.accessibility.permissionToSpeak());
        ChannelSchema.MESSAGE_COOLDOWN.writeValue(config, (Object)this.accessibility.messageCooldown());
        ChannelSchema.DISTANCE_TYPE.writeValue(config, (Object)this.distance.type());
        ChannelSchema.DISTANCE_RANGE.writeValue(config, (Object)this.distance.range());
        ChannelSchema.PREFIX_ENABLED.writeValue(config, (Object)this.prefix.enabled());
        ChannelSchema.PREFIX_VALUE.writeValue(config, (Object)this.prefix.value());
    }

    @NotNull
    public PlaceholderResolver placeholders() {
        return ChatPlaceholders.CHANNEL.resolver((Object)this);
    }

    @Nullable
    public Path getPath() {
        return this.path;
    }

    public boolean canListenOrSpeakHere(@NotNull Player player) {
        return this.canListenHere(player) || this.canSpeakHere(player);
    }

    public boolean addPlayer(@NotNull Player player) {
        return this.players.add(player.getUniqueId());
    }

    public boolean removePlayer(@NotNull Player player) {
        return this.players.remove(player.getUniqueId());
    }

    public boolean contains(@NotNull Player player) {
        return this.players.contains(player.getUniqueId());
    }

    public boolean canSpeakHere(@NotNull Player player) {
        return !this.accessibility.permissionToSpeak() || ChatPerms.CHANNEL_SPEAK.hasChildAccess((CommandSender)player, this.id);
    }

    public boolean canListenHere(@NotNull Player player) {
        return !this.accessibility.permissionToListen() || this.canSpeakHere(player) || ChatPerms.CHANNEL_LISTEN.hasChildAccess((CommandSender)player, this.id);
    }

    public boolean isInRadius(@NotNull CommandSender recipient, @NotNull Player speaker) {
        Entity listener;
        ChannelDistanceType distanceType = this.distance.type();
        if (distanceType == ChannelDistanceType.SERVER_WIDE) {
            return true;
        }
        if (recipient instanceof Entity && (listener = (Entity)recipient).getWorld() == speaker.getWorld()) {
            if (distanceType == ChannelDistanceType.WORLD_WIDE) {
                return true;
            }
            if (distanceType == ChannelDistanceType.RANGE) {
                double range = this.distance.range();
                if (range <= 0.0) {
                    return true;
                }
                double rangeSqr = range * range;
                double distanceSqr = listener.getLocation().distanceSquared(speaker.getLocation());
                return distanceSqr <= rangeSqr;
            }
        }
        return true;
    }

    public boolean isInChannelRadius(@NotNull CommandSender who, @NotNull Player speaker) {
        Player other;
        if (who == speaker) {
            return true;
        }
        if (who instanceof ConsoleCommandSender) {
            return true;
        }
        if (who instanceof Player && !this.contains(other = (Player)who)) {
            return false;
        }
        return this.isInRadius(who, speaker);
    }

    public boolean hasPrefix() {
        return this.prefix.enabled() && !this.prefix.value().isBlank();
    }

    public char getPrefixChar() {
        return this.prefix.value().charAt(0);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public Set<UUID> getPlayers() {
        return this.players;
    }

    @NotNull
    public ChannelDisplay getDisplay() {
        return this.display;
    }

    @NotNull
    public ChannelAccessibility getAccessibility() {
        return this.accessibility;
    }

    @NotNull
    public ChannelDistance getDistance() {
        return this.distance;
    }

    @NotNull
    public ChannelCommand getCommand() {
        return this.command;
    }

    @NotNull
    public ChannelPrefix getPrefix() {
        return this.prefix;
    }
}

