/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.chat;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.util.text.night.wrapper.SimpleTagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.module.chat.format.FormatComponent;
import su.nightexpress.sunlight.module.chat.format.FormatDefinition;
import su.nightexpress.sunlight.module.chat.mention.GroupMention;
import su.nightexpress.sunlight.module.chat.spy.SpyType;

public class ChatDefaults {
    public static final String DEFAULT_PM_ALIAS = "msg";
    public static final String DEFAULT_REPLY_ALIAS = "reply";
    public static final String DEFAULT_CHANNEL_ID = "_default_";
    public static final String DEFAULT_CHANNEL_FORMAT = TagWrappers.GRAY.wrap("[%channel_name%]") + " %format%";
    public static final String DEFAULT_LOCAL_CHANNEL_ID = "local";
    public static final String DEFAULT_USER_FORMAT = "%player_name%: %format%";
    public static final String DEFAULT_RULE_FILE_NAME = "default.txt";

    @NotNull
    public static Map<String, FormatDefinition> getDefaultFormats() {
        HashMap<String, FormatDefinition> map = new HashMap<String, FormatDefinition>();
        map.put("default", new FormatDefinition(0, "%rank_member%%player_info%: " + TagWrappers.GRAY.wrap("%message%"), Set.of("*")));
        map.put("owner", new FormatDefinition(100, "%rank_owner%%player_info%: " + TagWrappers.GRAY.wrap("%message%"), Set.of("admin", "owner")));
        return map;
    }

    @NotNull
    public static Map<String, FormatComponent> getDefaultFormatComponents() {
        HashMap<String, FormatComponent> map = new HashMap<String, FormatComponent>();
        map.put("player_info", new FormatComponent(((SimpleTagWrapper)TagWrappers.SHOW_TEXT.with(TagWrappers.GRAY.wrap("Player: " + TagWrappers.LIGHT_PURPLE.wrap("%player_name%") + TagWrappers.BR + "Nickname: " + TagWrappers.LIGHT_PURPLE.wrap("%player_display_name%") + TagWrappers.BR + TagWrappers.BR + TagWrappers.GRAY.wrap("(Click to message)")))).wrap(((SimpleTagWrapper)TagWrappers.SUGGEST_COMMAND.with("/msg %player_name% ")).wrap("%player_display_name%"))));
        map.put("rank_owner", new FormatComponent(((SimpleTagWrapper)TagWrappers.SHOW_TEXT.with(TagWrappers.GRAY.wrap("This player is the server " + TagWrappers.SOFT_YELLOW.wrap("Owner")))).wrap("%player_prefix%")));
        map.put("rank_member", new FormatComponent(((SimpleTagWrapper)TagWrappers.SHOW_TEXT.with(TagWrappers.GRAY.wrap("Type " + TagWrappers.SOFT_GREEN.wrap("/ranks") + " to view all special ranks."))).wrap(((SimpleTagWrapper)TagWrappers.RUN_COMMAND.with("/ranks")).wrap("%player_prefix%"))));
        return map;
    }

    @NotNull
    public static Map<String, GroupMention> getDefaultMentions() {
        HashMap<String, GroupMention> map = new HashMap<String, GroupMention>();
        map.put("all", new GroupMention(TagWrappers.SOFT_AQUA.wrap("@All"), Set.of("*")));
        map.put("admin", new GroupMention(TagWrappers.SOFT_RED.wrap("@Admin"), Set.of("admin")));
        return map;
    }

    @NotNull
    public static Collection<String> getDefaultWordFilterRules(@NotNull Locale locale) {
        String code = locale.getLanguage();
        if (code.equalsIgnoreCase("ru")) {
            return ChatDefaults.getRussianWordFilterRules();
        }
        return ChatDefaults.getEnglishWordFilterRules();
    }

    @NotNull
    private static Collection<String> getEnglishWordFilterRules() {
        String[] rules = new String[]{"ass", "asshole", "bastard", "bitch", "cock+", "cunt", "dickhead", "dick", "dumbass", "fag+", "+fuck+", "nigga", "nigra", "pussy"};
        return Arrays.asList(rules);
    }

    @NotNull
    private static Collection<String> getRussianWordFilterRules() {
        String[] rulesA = new String[]{"-\u0441\u0442\u0440\u0430\u0445\u0443\u0439-", "-\u0431\u043b\u044f\u0445\u0430-", "-\u0431\u043b\u044f\u0448\u043a\u0430-", "+\u0445\u0443\u0439+", "+\u0445\u0443\u0435+", "+\u043f\u0438\u0437\u0434+", "+\u043f\u0451\u0437\u0434+", "\u0443\u0435\u0431+", "\u0443\u0451\u0431+", "\u0435\u0431\u0430\u043d+", "\u0451\u0431\u0430\u043d+", "\u0435\u0431\u043b\u0430+", "\u0435\u0431\u043b\u044b+", "\u0431\u043b\u044f+", "\u0437\u0430\u043b\u0443\u043f+", "\u0445\u0435\u0440\u043d+", "\u0445\u0435\u0440\u043e\u0432+", "\u0445\u0435\u0440", "\u0441\u0443\u043a\u0430", "\u0441\u0443\u043a\u0438", "\u0441\u0443\u0447\u0430\u0440+", "\u0434\u0435\u0431\u0438\u043b+", "\u0434\u0438\u0431\u0438\u043b+", "\u0434\u043e\u043b\u0431\u0430+", "\u0434\u0430\u043b\u0431\u0430+", "\u0433\u043d\u0438\u0434\u0430", "\u0433\u043d\u0438\u0434\u043e+", "\u0433\u0430\u043d\u0434\u043e\u043d+", "\u0434\u0430\u0443\u043d", "\u0447\u043c\u043e", "\u043c\u0440\u0430\u0437+", "\u043c\u0443\u0434\u0430\u043a", "\u043c\u0443\u0434\u0438\u043b\u043e", "\u043c\u0443\u0434\u0438\u043b\u0430", "\u0443\u0431\u043b\u044e\u0434+", "\u0447\u0443\u0448\u043f\u0430\u043d", "\u0448\u043b\u044e\u0445+", "\u0448\u043b\u044e\u0448+"};
        return Arrays.asList(rulesA);
    }

    @NotNull
    public static Map<SpyType, String> getDefaultSpyFormat() {
        HashMap<SpyType, String> map = new HashMap<SpyType, String>();
        map.put(SpyType.SOCIAL, TagWrappers.SOFT_RED.wrap("[SocialSpy]") + " " + TagWrappers.GRAY.wrap("%player_name% \u27a1 %target%:") + " " + TagWrappers.GRAY.wrap("%message%"));
        map.put(SpyType.COMMAND, TagWrappers.SOFT_RED.wrap("[CommandSpy]") + " " + TagWrappers.GRAY.wrap("%player_name% executed a command:") + " " + TagWrappers.GRAY.wrap("%message%"));
        map.put(SpyType.CHAT, TagWrappers.SOFT_RED.wrap("[ChatSpy]") + " " + TagWrappers.GRAY.wrap("[%channel_name%] %player_name%:") + " " + TagWrappers.GRAY.wrap("%message%"));
        return map;
    }
}

