/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.bans.menu;

import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.ConfigProperty;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.configuration.ConfigTypes;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.EnumLocale;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.ui.inventory.item.ItemPopulator;
import su.nightexpress.nightcore.ui.inventory.item.ItemState;
import su.nightexpress.nightcore.ui.inventory.item.MenuItem;
import su.nightexpress.nightcore.ui.inventory.menu.AbstractObjectMenu;
import su.nightexpress.nightcore.ui.inventory.viewer.ViewerContext;
import su.nightexpress.nightcore.user.UserInfo;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.bans.BansModule;
import su.nightexpress.sunlight.module.bans.config.BansLang;
import su.nightexpress.sunlight.module.bans.config.BansPerms;
import su.nightexpress.sunlight.module.bans.menu.SortMode;
import su.nightexpress.sunlight.module.bans.punishment.AbstractPunishment;
import su.nightexpress.sunlight.module.bans.punishment.PlayerPunishment;
import su.nightexpress.sunlight.module.bans.punishment.PunishmentType;

public class HistoryMenu
extends AbstractObjectMenu<Data>
implements LangContainer {
    private static final EnumLocale<PunishmentType> TYPE_LOCALE = LangEntry.builder((String)"Bans.UI.History.TypeName").enumeration(PunishmentType.class);
    private static final IconLocale LOCALE_ACTIVE = LangEntry.iconBuilder((String)"Bans.UI.History.Icon.Active").rawName(TagWrappers.WHITE.wrap("%type%") + TagWrappers.DARK_GRAY.wrap(" \u2022 " + TagWrappers.GREEN.wrap("Active"))).rawLore(new String[]{TagWrappers.ITALIC.and((TagWrapper)TagWrappers.DARK_GRAY).wrap("\"%punishment_reason%\""), "", TagWrappers.RED.wrap("\u27a5 " + TagWrappers.GRAY.wrap("Staff: ") + "%punishment_punisher%"), TagWrappers.RED.wrap("\u27a5 " + TagWrappers.GRAY.wrap("Date: ") + "%punishment_date_created%"), TagWrappers.RED.wrap("\u27a5 " + TagWrappers.GRAY.wrap("Duration: ") + "%punishment_duration%"), "", TagWrappers.GOLD.wrap("\u231b " + TagWrappers.GRAY.wrap("Expires in: ") + "%punishment_expires_in%")}).build();
    private static final IconLocale LOCALE_PAUSED = LangEntry.iconBuilder((String)"Bans.UI.History.Icon.Paused").rawName(TagWrappers.WHITE.wrap("%type%") + TagWrappers.DARK_GRAY.wrap(" \u2022 " + TagWrappers.YELLOW.wrap("Inactive"))).rawLore(new String[]{TagWrappers.ITALIC.and((TagWrapper)TagWrappers.DARK_GRAY).wrap("\"%punishment_reason%\""), "", TagWrappers.RED.wrap("\u27a5 " + TagWrappers.GRAY.wrap("Staff: ") + "%punishment_punisher%"), TagWrappers.RED.wrap("\u27a5 " + TagWrappers.GRAY.wrap("Date: ") + "%punishment_date_created%"), TagWrappers.RED.wrap("\u27a5 " + TagWrappers.GRAY.wrap("Duration: ") + "%punishment_duration%"), "", TagWrappers.GOLD.wrap("\u231b " + TagWrappers.GRAY.wrap("Expires in: ") + "%punishment_expires_in%")}).build();
    private static final IconLocale LOCALE_EXPIRED = LangEntry.iconBuilder((String)"Bans.UI.History.Icon.Expired").rawName(TagWrappers.WHITE.wrap("%type%") + TagWrappers.DARK_GRAY.wrap(" \u2022 " + TagWrappers.GREEN.wrap("Expired"))).rawLore(new String[]{TagWrappers.ITALIC.and((TagWrapper)TagWrappers.DARK_GRAY).wrap("\"%punishment_reason%\""), "", TagWrappers.RED.wrap("\u27a5 " + TagWrappers.GRAY.wrap("Staff: ") + "%punishment_punisher%"), TagWrappers.RED.wrap("\u27a5 " + TagWrappers.GRAY.wrap("Date: ") + "%punishment_date_created%"), TagWrappers.RED.wrap("\u27a5 " + TagWrappers.GRAY.wrap("Duration: ") + "%punishment_duration%"), "", TagWrappers.DARK_GREEN.wrap("\u231b " + TagWrappers.GRAY.wrap("Expired: ") + "%punishment_date_expired%")}).build();
    private final SunLightPlugin plugin;
    private final BansModule module;
    private NightItem historyActiveIcon;
    private NightItem historyPausedIcon;
    private NightItem histroyExpiredIcon;
    private ItemPopulator<PlayerPunishment> populator;

    public HistoryMenu(@NotNull SunLightPlugin plugin, @NotNull BansModule module) {
        super((MenuType)MenuType.GENERIC_9X5, TagWrappers.BLACK.wrap("[%s] History for %s".formatted("%type%", "%target%")), Data.class);
        this.plugin = plugin;
        this.module = module;
        this.plugin.injectLang(this);
    }

    public boolean show(@NotNull Player player, @NotNull UserInfo userInfo, @NotNull PunishmentType type) {
        return this.show(player, userInfo, type, SortMode.NEWEST, true);
    }

    private boolean show(@NotNull Player player, @NotNull UserInfo userInfo, @NotNull PunishmentType type, @NotNull SortMode mode, boolean showExpired) {
        return this.show(this.plugin, player, new Data(userInfo, type, mode, showExpired));
    }

    @NotNull
    protected String getRawTitle(@NotNull ViewerContext context) {
        Data data = (Data)this.getObject(context);
        return PlaceholderContext.builder().with("%type%", () -> TYPE_LOCALE.getLocalized((Enum)data.type)).with("%target%", () -> ((UserInfo)data.userInfo).name()).build().apply(super.getRawTitle(context));
    }

    public void registerActions() {
    }

    public void registerConditions() {
    }

    public void defineDefaultLayout() {
        this.addNextPageItem(Material.ARROW, new int[]{41});
        this.addPreviousPageItem(Material.ARROW, new int[]{39});
        this.addBackgroundItem(Material.BLACK_STAINED_GLASS_PANE, IntStream.range(0, 9).toArray());
        this.addBackgroundItem(Material.BLACK_STAINED_GLASS_PANE, IntStream.range(36, 45).toArray());
        this.addDefaultButton("sort_mode", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.COMPARATOR).setDisplayName(TagWrappers.GOLD.wrap("Sorting Mode")).setLore(List.of(TagWrappers.DARK_GRAY.wrap("\u00bb" + TagWrappers.GRAY.wrap(" Selected: ") + TagWrappers.WHITE.wrap("%mode%")), "", TagWrappers.GRAY.wrap("Sets display order."), "", TagWrappers.GOLD.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to toggle"))))).displayModifier((context, item) -> item.replace(builder -> builder.with("%mode%", () -> BansLang.SORT_MODE.getLocalized((Enum)((Data)this.getObject((ViewerContext)context)).sortMode)))).action(context -> {
            Data data = (Data)this.getObject((ViewerContext)context);
            SortMode nextMode = (SortMode)Lists.next((Enum)data.sortMode);
            this.show(context.getPlayer(), data.userInfo, data.type, nextMode, data.showExpired);
        }).build()).slots(new int[]{43}).build());
        this.addDefaultButton("show_expired", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.CLOCK).setDisplayName(TagWrappers.YELLOW.wrap("Show Expired")).setLore(List.of(TagWrappers.DARK_GRAY.wrap("\u00bb" + TagWrappers.GRAY.wrap(" Status: ") + TagWrappers.WHITE.wrap("%state%")), "", TagWrappers.GRAY.wrap("Whether to show expired entries."), "", TagWrappers.YELLOW.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to toggle"))))).displayModifier((context, item) -> item.replace(builder -> builder.with("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(((Data)this.getObject((ViewerContext)context)).showExpired)))).action(context -> {
            Data data = (Data)this.getObject((ViewerContext)context);
            this.show(context.getPlayer(), data.userInfo, data.type, data.sortMode, !data.showExpired);
        }).build()).slots(new int[]{37}).build());
    }

    protected void onLoad(@NotNull FileConfig config) {
        this.historyActiveIcon = (NightItem)ConfigProperty.of((ConfigType)ConfigTypes.NIGHT_ITEM, (String)"History.Icon.Active", (Object)NightItem.fromType((Material)Material.LIME_DYE), (String[])new String[0]).resolveWithDefaults(config);
        this.historyPausedIcon = (NightItem)ConfigProperty.of((ConfigType)ConfigTypes.NIGHT_ITEM, (String)"History.Icon.Paused", (Object)NightItem.fromType((Material)Material.YELLOW_DYE), (String[])new String[0]).resolveWithDefaults(config);
        this.histroyExpiredIcon = (NightItem)ConfigProperty.of((ConfigType)ConfigTypes.NIGHT_ITEM, (String)"History.Icon.Expired", (Object)NightItem.fromType((Material)Material.GRAY_DYE), (String[])new String[0]).resolveWithDefaults(config);
        int[] historySlots = (int[])ConfigProperty.of((ConfigType)ConfigTypes.INT_ARRAY, (String)"History.Slots", (Object)IntStream.range(9, 36).toArray(), (String[])new String[0]).resolveWithDefaults(config);
        this.populator = ItemPopulator.builder(PlayerPunishment.class).slots(historySlots).itemProvider((context, punishment) -> {
            IconLocale locale;
            NightItem icon;
            Data data = (Data)this.getObject((ViewerContext)context);
            if (!punishment.isExpired()) {
                icon = punishment.isActive() ? this.historyActiveIcon : this.historyPausedIcon;
                locale = punishment.isActive() ? LOCALE_ACTIVE : LOCALE_PAUSED;
            } else {
                icon = this.histroyExpiredIcon;
                locale = LOCALE_EXPIRED;
            }
            return icon.copy().hideAllComponents().localized(locale).replace(builder -> builder.with("%type%", () -> BansLang.PUNISHMENT_TYPE.getLocalized((Enum)data.type)).with(punishment.placeholders()));
        }).actionProvider(punishment -> actionContext -> {
            InventoryClickEvent event = actionContext.getEvent();
            Player player = actionContext.getPlayer();
            Data data = (Data)this.getObject((ViewerContext)actionContext);
            if (event.getClick() == ClickType.DROP) {
                if (!player.hasPermission(BansPerms.PUNISHMENT_DELETE)) {
                    return;
                }
                this.module.deletePlayerPunishment((PlayerPunishment)punishment);
            } else if (event.isLeftClick()) {
                if (!player.hasPermission(BansPerms.PUNISHMENT_TOGGLE)) {
                    return;
                }
                if (punishment.isExpired()) {
                    return;
                }
                punishment.setActive(!punishment.isActive());
                punishment.markDirty();
                this.module.getPunishmentRepository(data.type).updatePlayerPunishmentReferences((PlayerPunishment)punishment);
            } else {
                return;
            }
            actionContext.getViewer().refresh();
        }).build();
    }

    protected void onClick(@NotNull ViewerContext context, @NotNull InventoryClickEvent event) {
    }

    protected void onDrag(@NotNull ViewerContext context, @NotNull InventoryDragEvent event) {
    }

    protected void onClose(@NotNull ViewerContext context, @NotNull InventoryCloseEvent event) {
    }

    public void onPrepare(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory, @NotNull List<MenuItem> list) {
        Data data = (Data)this.getObject(context);
        List<AbstractPunishment> punishments = this.module.getPunishmentRepository(data.type).getPlayerPunishments(data.userInfo.id()).stream().filter(punishment -> data.showExpired || !punishment.isExpired()).sorted(data.sortMode.comparator()).toList();
        this.populator.populateTo(context, punishments, list);
    }

    public void onReady(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }

    public void onRender(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }

    public record Data(@NotNull UserInfo userInfo, @NotNull PunishmentType type, @NotNull SortMode sortMode, boolean showExpired) {
    }
}

