/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.bans.command;

import java.net.InetAddress;
import java.util.concurrent.CompletableFuture;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.user.UserInfo;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.bans.BansModule;
import su.nightexpress.sunlight.module.bans.config.BansLang;
import su.nightexpress.sunlight.module.bans.config.BansPerms;
import su.nightexpress.sunlight.module.bans.punishment.InetPunishment;
import su.nightexpress.sunlight.module.bans.punishment.PlayerPunishment;
import su.nightexpress.sunlight.module.bans.punishment.PunishmentType;
import su.nightexpress.sunlight.user.UserManager;
import su.nightexpress.sunlight.utils.FutureUtils;

public class PardonCommandsProvider
extends AbstractCommandProvider {
    private final BansModule module;
    private final UserManager userManager;

    public PardonCommandsProvider(@NotNull SunLightPlugin plugin, @NotNull BansModule module, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral("unban", true, new String[]{"unban"}, builder -> this.builderPlayer((LiteralNodeBuilder)builder, PunishmentType.BAN));
        this.registerLiteral("unmute", true, new String[]{"unmute"}, builder -> this.builderPlayer((LiteralNodeBuilder)builder, PunishmentType.MUTE));
        this.registerLiteral("unwarn", true, new String[]{"unwarn"}, builder -> this.builderPlayer((LiteralNodeBuilder)builder, PunishmentType.WARN));
        this.registerLiteral("unbanip", true, new String[]{"unbanip"}, this::builderInet);
    }

    private void builderInet(@NotNull LiteralNodeBuilder builder) {
        ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(BansLang.COMMAND_UNBAN_IP_DESC)).permission(BansPerms.COMMAND_UNBAN_IP)).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"address").suggestions((reader, tabContext) -> this.module.getPunishmentRepository(PunishmentType.BAN).getActiveInetPunishments().stream().map(InetPunishment::getRawAddress).toList())}).withFlags(new String[]{"s"}).executes(this::pardonInet);
    }

    private void builderPlayer(@NotNull LiteralNodeBuilder builder, @NotNull PunishmentType type) {
        TextLocale description = switch (type) {
            default -> throw new MatchException(null, null);
            case PunishmentType.BAN -> BansLang.COMMAND_UNBAN_DESC;
            case PunishmentType.MUTE -> BansLang.COMMAND_UNMUTE_DESC;
            case PunishmentType.WARN -> BansLang.COMMAND_UNWARN_DESC;
        };
        Permission permission = switch (type) {
            default -> throw new MatchException(null, null);
            case PunishmentType.BAN -> BansPerms.COMMAND_UNBAN;
            case PunishmentType.MUTE -> BansPerms.COMMAND_UNMUTE;
            case PunishmentType.WARN -> BansPerms.COMMAND_UNWARN;
        };
        ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(description)).permission(permission)).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player").suggestions((reader, tabContext) -> this.module.getPunishmentRepository(type).getActivePlayerPunishments().stream().map(PlayerPunishment::getPlayerName).toList())}).withFlags(new String[]{"s"}).executes((context, arguments) -> this.pardonPlayer(context, arguments, type));
    }

    private boolean pardonInet(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        InetAddress address = (InetAddress)arguments.get("address", InetAddress.class);
        boolean silent = context.hasFlag("s");
        return this.module.pardonInet(address, context.getSender(), silent);
    }

    private boolean pardonPlayer(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull PunishmentType type) {
        String targetName = arguments.getString("player");
        boolean silent = context.hasFlag("s");
        ((CompletableFuture)this.userManager.loadTargetProfile(targetName).thenAcceptAsync(profile -> {
            if (profile == null) {
                context.errorBadPlayer();
                return;
            }
            this.module.pardonPlayer((UserInfo)profile, context.getSender(), type, silent);
        }, arg_0 -> ((SunLightPlugin)this.plugin).runTask(arg_0))).whenComplete(FutureUtils::printStacktrace);
        return true;
    }
}

