/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.bans.command;

import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.bans.BansModule;
import su.nightexpress.sunlight.module.bans.config.BansLang;
import su.nightexpress.sunlight.module.bans.config.BansPerms;
import su.nightexpress.sunlight.module.bans.punishment.PunishmentType;

public class ListCommandsProvider
extends AbstractCommandProvider {
    public static final String NODE_BAN = "banlist";
    public static final String NODE_MUTE = "mutelist";
    public static final String NODE_WARN = "warnlist";
    private final BansModule module;

    public ListCommandsProvider(@NotNull SunLightPlugin plugin, @NotNull BansModule module) {
        super(plugin);
        this.module = module;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(NODE_BAN, true, new String[]{NODE_BAN}, builder -> this.build((LiteralNodeBuilder)builder, PunishmentType.BAN));
        this.registerLiteral(NODE_MUTE, true, new String[]{NODE_MUTE}, builder -> this.build((LiteralNodeBuilder)builder, PunishmentType.MUTE));
        this.registerLiteral(NODE_WARN, true, new String[]{NODE_WARN}, builder -> this.build((LiteralNodeBuilder)builder, PunishmentType.WARN));
    }

    private void build(@NotNull LiteralNodeBuilder builder, @NotNull PunishmentType type) {
        TextLocale description = switch (type) {
            default -> throw new MatchException(null, null);
            case PunishmentType.BAN -> BansLang.COMMAND_BAN_LIST_DESC;
            case PunishmentType.MUTE -> BansLang.COMMAND_MUTE_LIST_DESC;
            case PunishmentType.WARN -> BansLang.COMMAND_WARN_LIST_DESC;
        };
        Permission permission = switch (type) {
            default -> throw new MatchException(null, null);
            case PunishmentType.BAN -> BansPerms.COMMAND_BAN_LIST;
            case PunishmentType.MUTE -> BansPerms.COMMAND_MUTE_LIST;
            case PunishmentType.WARN -> BansPerms.COMMAND_WARN_LIST;
        };
        ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(description)).permission(permission)).executes((context, arguments) -> this.showMenu(context, type));
    }

    private boolean showMenu(@NotNull CommandContext context, @NotNull PunishmentType type) {
        this.module.openPunishments(context.getPlayerOrThrow(), type);
        return true;
    }
}

