/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.bans.command;

import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.user.UserInfo;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.bans.BansModule;
import su.nightexpress.sunlight.module.bans.config.BansLang;
import su.nightexpress.sunlight.module.bans.config.BansPerms;
import su.nightexpress.sunlight.module.bans.punishment.PlayerPunishment;
import su.nightexpress.sunlight.module.bans.punishment.PunishmentType;
import su.nightexpress.sunlight.user.UserManager;
import su.nightexpress.sunlight.utils.FutureUtils;

public class HistoryCommandsProvider
extends AbstractCommandProvider {
    private final BansModule module;
    private final UserManager userManager;

    public HistoryCommandsProvider(@NotNull SunLightPlugin plugin, @NotNull BansModule module, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral("banhistory", true, new String[]{"banhistory"}, builder -> this.builder((LiteralNodeBuilder)builder, PunishmentType.BAN));
        this.registerLiteral("mutehistory", true, new String[]{"mutehistory"}, builder -> this.builder((LiteralNodeBuilder)builder, PunishmentType.MUTE));
        this.registerLiteral("warnhistory", true, new String[]{"warnhistory"}, builder -> this.builder((LiteralNodeBuilder)builder, PunishmentType.WARN));
    }

    private void builder(@NotNull LiteralNodeBuilder builder, @NotNull PunishmentType type) {
        TextLocale description = switch (type) {
            default -> throw new MatchException(null, null);
            case PunishmentType.BAN -> BansLang.COMMAND_BAN_HISTORY_DESC;
            case PunishmentType.MUTE -> BansLang.COMMAND_MUTE_HISTORY_DESC;
            case PunishmentType.WARN -> BansLang.COMMAND_WARN_HISTORY_DESC;
        };
        Permission permission = switch (type) {
            default -> throw new MatchException(null, null);
            case PunishmentType.BAN -> BansPerms.COMMAND_BAN_HISTORY;
            case PunishmentType.MUTE -> BansPerms.COMMAND_MUTE_HISTORY;
            case PunishmentType.WARN -> BansPerms.COMMAND_WARN_HISTORY;
        };
        ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(description)).permission(permission)).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player").suggestions((reader, tabContext) -> this.module.getPlayerPunishments(type).stream().map(PlayerPunishment::getPlayerName).toList())}).executes((context, arguments) -> this.showHistory(context, arguments, type));
    }

    private boolean showHistory(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull PunishmentType type) {
        Player viewer = context.getPlayerOrThrow();
        String targetName = arguments.getString("player");
        ((CompletableFuture)this.userManager.loadTargetProfile(targetName).thenAcceptAsync(profile -> {
            if (profile == null) {
                context.errorBadPlayer();
                return;
            }
            this.module.openHistory(viewer, (UserInfo)profile, type);
        }, arg_0 -> ((SunLightPlugin)this.plugin).runTask(arg_0))).whenComplete(FutureUtils::printStacktrace);
        return true;
    }
}

