/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.bans;

import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.util.placeholder.TypedPlaceholder;
import su.nightexpress.nightcore.util.time.TimeFormatType;
import su.nightexpress.nightcore.util.time.TimeFormats;
import su.nightexpress.sunlight.SLPlaceholders;
import su.nightexpress.sunlight.SLUtils;
import su.nightexpress.sunlight.module.bans.punishment.AbstractPunishment;
import su.nightexpress.sunlight.module.bans.punishment.InetPunishment;
import su.nightexpress.sunlight.module.bans.punishment.PlayerPunishment;

public class BansPlaceholders
extends SLPlaceholders {
    public static final String GENERIC_REASON = "%reason%";
    public static final String GENERIC_EXECUTOR = "%executor%";
    public static final String PUNISHMENT_TYPE = "%punishment_type%";
    public static final String PUNISHMENT_TARGET = "%punishment_user%";
    public static final String PUNISHMENT_REASON = "%punishment_reason%";
    public static final String PUNISHMENT_WHO = "%punishment_punisher%";
    public static final String PUNISHMENT_DURATION = "%punishment_duration%";
    public static final String PUNISHMENT_CREATION_DATE = "%punishment_date_created%";
    public static final String PUNISHMENT_EXPIRATION_DATE = "%punishment_date_expired%";
    public static final String PUNISHMENT_EXPIRES_IN = "%punishment_expires_in%";
    @NotNull
    private static final TypedPlaceholder<AbstractPunishment> PUNISHMENT = TypedPlaceholder.builder(AbstractPunishment.class).with("%punishment_reason%", AbstractPunishment::getReason).with("%punishment_punisher%", punishment -> SLUtils.getSenderName(punishment.getWho())).with("%punishment_duration%", punishment -> TimeFormats.formatAmount((long)punishment.getDuration(), (TimeFormatType)TimeFormatType.LITERAL)).with("%punishment_expires_in%", punishment -> !punishment.isPermanent() ? TimeFormats.formatDuration((long)punishment.getExpirationDate(), (TimeFormatType)TimeFormatType.LITERAL) : CoreLang.OTHER_NEVER.text()).with("%punishment_date_created%", punishment -> TimeFormats.formatDateTime((long)punishment.getCreationDate())).with("%punishment_date_expired%", punishment -> !punishment.isPermanent() ? TimeFormats.formatDateTime((long)punishment.getExpirationDate()) : CoreLang.OTHER_NEVER.text()).build();
    @NotNull
    public static final TypedPlaceholder<PlayerPunishment> PLAYER_PUNISHMENT = TypedPlaceholder.builder(PlayerPunishment.class).include(PUNISHMENT).with("%punishment_user%", PlayerPunishment::getPlayerName).build();
    @NotNull
    public static final TypedPlaceholder<InetPunishment> INET_PUNISHMENT = TypedPlaceholder.builder(InetPunishment.class).include(PUNISHMENT).with("%punishment_user%", InetPunishment::getRawAddress).build();
}

