/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.bans;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.bridge.chat.UniversalChatEvent;
import su.nightexpress.nightcore.bridge.chat.UniversalChatEventHandler;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.user.UserInfo;
import su.nightexpress.nightcore.util.CommandUtil;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.bridge.wrapper.NightComponent;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;
import su.nightexpress.nightcore.util.text.night.NightMessage;
import su.nightexpress.nightcore.util.time.TimeFormats;
import su.nightexpress.sunlight.SLUtils;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.config.PermissionTree;
import su.nightexpress.sunlight.hook.placeholder.PlaceholderRegistry;
import su.nightexpress.sunlight.module.Module;
import su.nightexpress.sunlight.module.ModuleContext;
import su.nightexpress.sunlight.module.bans.command.AltsCommandProvider;
import su.nightexpress.sunlight.module.bans.command.HistoryCommandsProvider;
import su.nightexpress.sunlight.module.bans.command.ListCommandsProvider;
import su.nightexpress.sunlight.module.bans.command.PardonCommandsProvider;
import su.nightexpress.sunlight.module.bans.command.PunishmentCommandsProvider;
import su.nightexpress.sunlight.module.bans.config.BansLang;
import su.nightexpress.sunlight.module.bans.config.BansPerms;
import su.nightexpress.sunlight.module.bans.config.BansSettings;
import su.nightexpress.sunlight.module.bans.data.BansDataManager;
import su.nightexpress.sunlight.module.bans.listener.BansListener;
import su.nightexpress.sunlight.module.bans.menu.HistoryMenu;
import su.nightexpress.sunlight.module.bans.menu.PunishmentsMenu;
import su.nightexpress.sunlight.module.bans.punishment.AbstractPunishment;
import su.nightexpress.sunlight.module.bans.punishment.InetPunishment;
import su.nightexpress.sunlight.module.bans.punishment.PlayerPunishment;
import su.nightexpress.sunlight.module.bans.punishment.PunishmentContext;
import su.nightexpress.sunlight.module.bans.punishment.PunishmentData;
import su.nightexpress.sunlight.module.bans.punishment.PunishmentReason;
import su.nightexpress.sunlight.module.bans.punishment.PunishmentRepository;
import su.nightexpress.sunlight.module.bans.punishment.PunishmentType;
import su.nightexpress.sunlight.module.bans.time.BanTime;
import su.nightexpress.sunlight.module.bans.time.BanTimeUnit;
import su.nightexpress.sunlight.utils.FutureUtils;

public class BansModule
extends Module {
    private final BansSettings settings = new BansSettings();
    private final BansDataManager dataManager = new BansDataManager((SunLightPlugin)this.plugin, this.dataHandler, this);
    private final UniversalChatEventHandler chatHandler = this::handleChatEvent;
    private final Map<String, BanTimeUnit> timeUnitAliasMap = new HashMap<String, BanTimeUnit>();
    private final PunishmentRepository bansRepository = new PunishmentRepository();
    private final PunishmentRepository mutesRepository = new PunishmentRepository();
    private final PunishmentRepository warnsRepository = new PunishmentRepository();
    private HistoryMenu historyMenu;
    private PunishmentsMenu punishmentsMenu;
    private boolean dataLoaded;

    public BansModule(@NotNull ModuleContext context) {
        super(context);
    }

    @Override
    protected void loadModule(@NotNull FileConfig config) {
        this.settings.load(config);
        ((SunLightPlugin)this.plugin).injectLang(BansLang.class);
        this.dataManager.init((String)this.settings.dataTablePrefix.get());
        this.loadTimeAliases();
        this.loadMenu();
        this.loadData();
        this.addListener((SimpeListener)new BansListener((SunLightPlugin)this.plugin, this));
        ((SunLightPlugin)this.plugin).addChatHandler(EventPriority.LOWEST, this.chatHandler);
        this.addAsyncTask(this::savePunishments, (Integer)this.settings.dataSaveInterval.get());
    }

    @Override
    protected void unloadModule() {
        ((SunLightPlugin)this.plugin).removeChatHandler(this.chatHandler);
        this.clearRepositories();
        this.dataLoaded = false;
    }

    @Override
    protected void registerPermissions(@NotNull PermissionTree root) {
        root.merge(BansPerms.ROOT);
    }

    @Override
    protected void registerCommands() {
        this.commandRegistry.addProvider("bans-punish", new PunishmentCommandsProvider((SunLightPlugin)this.plugin, this, this.userManager));
        this.commandRegistry.addProvider("bans-pardon", new PardonCommandsProvider((SunLightPlugin)this.plugin, this, this.userManager));
        this.commandRegistry.addProvider("bans-history", new HistoryCommandsProvider((SunLightPlugin)this.plugin, this, this.userManager));
        this.commandRegistry.addProvider("bans-list", new ListCommandsProvider((SunLightPlugin)this.plugin, this));
        if (this.settings.isAltCheckerEnabled()) {
            this.commandRegistry.addProvider("bans-alts", new AltsCommandProvider((SunLightPlugin)this.plugin, this, this.userManager));
        }
    }

    @Override
    public void registerPlaceholders(@NotNull PlaceholderRegistry registry) {
    }

    private void clearRepositories() {
        this.bansRepository.clear();
        this.mutesRepository.clear();
        this.warnsRepository.clear();
    }

    private void loadTimeAliases() {
        ((Map)this.settings.timeUnitAliases.get()).forEach((unit, aliases) -> {
            for (String alias : aliases) {
                this.timeUnitAliasMap.put(alias, (BanTimeUnit)unit);
            }
        });
    }

    private void loadMenu() {
        this.historyMenu = new HistoryMenu((SunLightPlugin)this.plugin, this);
        this.historyMenu.load((NightPlugin)this.plugin, FileConfig.load((String)this.getLocalUIPath(), (String)"history.yml"));
        this.punishmentsMenu = new PunishmentsMenu((SunLightPlugin)this.plugin, this);
        this.punishmentsMenu.load((NightPlugin)this.plugin, FileConfig.load((String)this.getLocalUIPath(), (String)"punishments.yml"));
    }

    private void loadData() {
        this.dataLoaded = false;
        ((SunLightPlugin)this.plugin).runTaskAsync(task -> {
            this.dataManager.getPlayerPunishments().forEach(punishment -> this.getPunishmentRepository((AbstractPunishment)punishment).addPlayerPunishment((PlayerPunishment)punishment));
            this.dataManager.getInetPunishments().forEach(punishment -> this.getPunishmentRepository((AbstractPunishment)punishment).addInetPunishment((InetPunishment)punishment));
            this.dataLoaded = true;
            ((SunLightPlugin)this.plugin).runTask(this::kickBanned);
        });
    }

    private void savePunishments() {
        ArrayList<PlayerPunishment> playerPunishments = new ArrayList<PlayerPunishment>();
        ArrayList<InetPunishment> inetPunishments = new ArrayList<InetPunishment>();
        for (PunishmentType type : PunishmentType.values()) {
            PunishmentRepository repository = this.getPunishmentRepository(type);
            repository.getPlayerPunishments().stream().filter(AbstractPunishment::isDirty).peek(AbstractPunishment::markClean).forEach(playerPunishments::add);
            repository.getInetPunishments().stream().filter(AbstractPunishment::isDirty).peek(AbstractPunishment::markClean).forEach(inetPunishments::add);
        }
        this.dataManager.updatePlayerPunishments(playerPunishments);
        this.dataManager.updateInetPunishments(inetPunishments);
    }

    private void kickBanned() {
        Players.getOnline().forEach(player -> {
            AbstractPunishment punishment = this.bansRepository.getActivePlayerOrInetPunishment(player.getUniqueId(), SLUtils.getInetAddress(player).orElse(null));
            if (punishment == null) {
                return;
            }
            Players.kick((Player)player, (String)this.getKickScreenText(punishment));
        });
    }

    @NotNull
    public BansDataManager getDataManager() {
        return this.dataManager;
    }

    @NotNull
    public List<String> getReasonIds() {
        return List.copyOf(((Map)this.settings.reasonMap.get()).keySet());
    }

    @NotNull
    public Set<PunishmentReason> getReasons() {
        return Set.copyOf(((Map)this.settings.reasonMap.get()).values());
    }

    @Nullable
    public PunishmentReason getReasonById(@NotNull String id) {
        return (PunishmentReason)((Map)this.settings.reasonMap.get()).get(id.toLowerCase());
    }

    @NotNull
    public PunishmentReason getDefaultReason() {
        PunishmentReason reason = this.getReasonById("default");
        return reason == null ? new PunishmentReason(BansLang.OTHER_NO_REASON.text()) : reason;
    }

    @NotNull
    public PunishmentRepository getPunishmentRepository(@NotNull AbstractPunishment punishment) {
        return this.getPunishmentRepository(punishment.getType());
    }

    @NotNull
    public PunishmentRepository getPunishmentRepository(@NotNull PunishmentType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case PunishmentType.BAN -> this.getBansRepository();
            case PunishmentType.MUTE -> this.getMutesRepository();
            case PunishmentType.WARN -> this.getWarnsRepository();
        };
    }

    @NotNull
    public PunishmentRepository getBansRepository() {
        return this.bansRepository;
    }

    @NotNull
    public PunishmentRepository getMutesRepository() {
        return this.mutesRepository;
    }

    @NotNull
    public PunishmentRepository getWarnsRepository() {
        return this.warnsRepository;
    }

    @NotNull
    public Set<PlayerPunishment> getPlayerPunishments(@NotNull PunishmentType type) {
        return this.getPunishmentRepository(type).getPlayerPunishments();
    }

    @NotNull
    public Set<PlayerPunishment> getPlayerPunishments(@NotNull UUID playerId, @NotNull PunishmentType type) {
        return this.getPunishmentRepository(type).getPlayerPunishments(playerId);
    }

    @NotNull
    public Set<InetPunishment> getInetPunishments() {
        return this.getPunishmentRepository(PunishmentType.BAN).getInetPunishments();
    }

    @NotNull
    public Set<InetPunishment> getInetPunishments(@NotNull InetAddress address) {
        return this.getPunishmentRepository(PunishmentType.BAN).getInetPunishments(address);
    }

    @Nullable
    public PlayerPunishment getActivePlayerPunishment(@NotNull UUID playerId, @NotNull PunishmentType type) {
        return this.getPunishmentRepository(type).getActivePlayerPunishment(playerId);
    }

    @NotNull
    public Set<PlayerPunishment> getActivePlayerPunishments(@NotNull UUID playerId, @NotNull PunishmentType type) {
        return this.getPunishmentRepository(type).getActivePlayerPunishments(playerId);
    }

    @Nullable
    public InetPunishment getActiveInetPunishment(@NotNull InetAddress address) {
        return this.getPunishmentRepository(PunishmentType.BAN).getActiveInetPunishment(address);
    }

    @NotNull
    public Set<InetPunishment> getActiveInetPunishments(@NotNull InetAddress address) {
        return this.getPunishmentRepository(PunishmentType.BAN).getActiveInetPunishments(address);
    }

    public boolean hasActivePunishment(@NotNull UUID playerId, @NotNull PunishmentType type) {
        return !this.getActivePlayerPunishments(playerId, type).isEmpty();
    }

    public boolean hasActivePunishment(@NotNull InetAddress address, @NotNull PunishmentType type) {
        return !this.getActiveInetPunishments(address).isEmpty();
    }

    public boolean openPunishments(@NotNull Player player, @NotNull PunishmentType type) {
        return this.punishmentsMenu.show(player, type);
    }

    public boolean openHistory(@NotNull Player player, @NotNull UserInfo userInfo, @NotNull PunishmentType type) {
        return this.historyMenu.show(player, userInfo, type);
    }

    private void addPlayerPunishment(@NotNull PlayerPunishment punishment) {
        this.getPunishmentRepository(punishment).addPlayerPunishment(punishment);
        ((SunLightPlugin)this.plugin).runTaskAsync(task -> this.dataManager.insertPunishment(punishment));
    }

    public void deletePlayerPunishment(@NotNull PlayerPunishment punishment) {
        this.getPunishmentRepository(punishment).removePlayerPunishment(punishment);
        ((SunLightPlugin)this.plugin).runTaskAsync(task -> this.dataManager.deletePlayerPunishment(punishment));
    }

    private void addInetPunishment(@NotNull InetPunishment punishment) {
        this.getPunishmentRepository(punishment).addInetPunishment(punishment);
        ((SunLightPlugin)this.plugin).runTaskAsync(task -> this.dataManager.insertPunishment(punishment));
    }

    public void deleteInetPunishment(@NotNull InetPunishment punishment) {
        this.getPunishmentRepository(punishment).removeInetPunishment(punishment);
        ((SunLightPlugin)this.plugin).runTaskAsync(task -> this.dataManager.deleteInetPunishment(punishment));
    }

    public boolean isMuted(@NotNull Player player) {
        return this.isMuted(player.getUniqueId());
    }

    public boolean isMuted(@NotNull UUID playerId) {
        return this.hasActivePunishment(playerId, PunishmentType.MUTE);
    }

    public boolean isBanned(@NotNull UUID playerId) {
        return this.hasActivePunishment(playerId, PunishmentType.BAN);
    }

    public boolean hasImmunity(@NotNull Player player) {
        return this.hasImmunity(player.getName()) || this.hasImmunity(player.getUniqueId().toString());
    }

    public boolean hasImmunity(@NotNull InetAddress address) {
        return this.hasImmunity(address.getHostAddress());
    }

    public boolean hasImmunity(@NotNull String name) {
        return ((Set)this.settings.immunityList.get()).contains(LowerCase.INTERNAL.apply(name));
    }

    @NotNull
    private Set<Player> getPlayersToPunish(@NotNull AbstractPunishment punishData) {
        return ((SunLightPlugin)this.plugin).getServer().getOnlinePlayers().stream().filter(punishData::isApplicable).collect(Collectors.toSet());
    }

    @NotNull
    public BanTime getGreatestDuration(@NotNull CommandSender sender, @NotNull PunishmentType type) {
        if (!(sender instanceof Player)) {
            return BanTime.permanent();
        }
        Player player = (Player)sender;
        Map durationMap = (Map)this.settings.durationLimitsRanks.get();
        HashSet<BanTime> banTimes = new HashSet<BanTime>();
        for (String rank : Players.getInheritanceGroups((Player)player)) {
            BanTime banTime = (BanTime)durationMap.getOrDefault(rank, Collections.emptyMap()).get((Object)type);
            if (banTime == null) continue;
            banTimes.add(banTime);
        }
        return banTimes.stream().max((o1, o2) -> {
            if (o1.isGreater((BanTime)o2)) {
                return 1;
            }
            if (o1.isSmaller((BanTime)o2)) {
                return -1;
            }
            return 0;
        }).orElse(BanTime.permanent());
    }

    public int getRankPriority(@NotNull CommandSender sender) {
        if (sender instanceof ConsoleCommandSender) {
            return (Integer)this.settings.consolePriority.get();
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return this.getRankPriority(Players.getInheritanceGroups((Player)player));
        }
        return 0;
    }

    @NotNull
    private CompletableFuture<Integer> getRankPriority(@NotNull UserInfo profile) {
        return Players.getInheritanceGroups((UUID)profile.id()).thenApply(this::getRankPriority);
    }

    private int getRankPriority(@NotNull Set<String> ranks) {
        Map priorityMap = (Map)this.settings.rankPriorities.get();
        return ranks.stream().mapToInt(rank -> priorityMap.getOrDefault(rank, 0)).max().orElse(0);
    }

    public void handleLoginEvent(@NotNull AsyncPlayerPreLoginEvent event) {
        InetAddress address = event.getAddress();
        UUID playerId = event.getUniqueId();
        AbstractPunishment punishment = this.bansRepository.getActivePlayerOrInetPunishment(playerId, address);
        if (punishment == null) {
            return;
        }
        if (punishment instanceof PlayerPunishment) {
            PlayerPunishment playerPunishment = (PlayerPunishment)punishment;
            playerPunishment.updateName(event.getName());
        }
        String message = this.getKickScreenText(punishment);
        Players.disallowLogin((AsyncPlayerPreLoginEvent)event, (AsyncPlayerPreLoginEvent.Result)AsyncPlayerPreLoginEvent.Result.KICK_BANNED, (String)message);
    }

    public void handleCommandEvent(@NotNull PlayerCommandPreprocessEvent event) {
        if (!((Boolean)this.settings.muteBlockCommandsEnabled.get()).booleanValue()) {
            return;
        }
        Set blockedCommands = (Set)this.settings.muteBlockCommandsList.get();
        if (blockedCommands.isEmpty()) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.dataLoaded) {
            this.sendPrefixed(BansLang.ERROR_DATA_NOT_LOADED_USER_FEEDBACK, (CommandSender)player);
            return;
        }
        PlayerPunishment punishment = this.getActivePlayerPunishment(player.getUniqueId(), PunishmentType.MUTE);
        if (punishment == null) {
            return;
        }
        String command = CommandUtil.getCommandName((String)event.getMessage());
        Set aliases = CommandUtil.getAliases((String)command, (boolean)true);
        if (aliases.stream().anyMatch(blockedCommands::contains)) {
            event.setCancelled(true);
            MessageLocale locale = punishment.isPermanent() ? BansLang.MUTE_SPEAK_NOTIFY_PERMANENT : BansLang.MUTE_SPEAK_NOTIFY_TEMPORAL;
            this.sendPrefixed(locale, (CommandSender)player, (PlaceholderContext.Builder builder) -> builder.with(punishment.placeholders()));
        }
    }

    public void handleChatEvent(@NotNull UniversalChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.dataLoaded) {
            this.sendPrefixed(BansLang.ERROR_DATA_NOT_LOADED_USER_FEEDBACK, (CommandSender)player);
            return;
        }
        PlayerPunishment punishment = this.getActivePlayerPunishment(player.getUniqueId(), PunishmentType.MUTE);
        if (punishment == null) {
            return;
        }
        event.setCancelled(true);
        MessageLocale locale = punishment.isPermanent() ? BansLang.MUTE_SPEAK_NOTIFY_PERMANENT : BansLang.MUTE_SPEAK_NOTIFY_TEMPORAL;
        this.sendPrefixed(locale, (CommandSender)player, (PlaceholderContext.Builder builder) -> builder.with(punishment.placeholders()));
    }

    public void handleJoin(@NotNull PlayerJoinEvent event) {
        if (!this.settings.isAltCheckerEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasPermission(BansPerms.BYPASS_ALT_DETECTION)) {
            return;
        }
        SLUtils.getInetAddress(player).ifPresent(address -> ((CompletableFuture)this.lookupAltProfiles((InetAddress)address).thenAccept(alts -> {
            UserInfo profile = UserInfo.of((Player)player);
            HashSet<ConsoleCommandSender> receivers = new HashSet<ConsoleCommandSender>();
            receivers.add(((SunLightPlugin)this.plugin).getServer().getConsoleSender());
            receivers.addAll(Players.getOnline().stream().filter(staff -> staff.hasPermission(BansPerms.ALTS_NOTIFY)).collect(Collectors.toSet()));
            receivers.forEach(sender -> this.notifyAltProfiles((CommandSender)sender, profile, (InetAddress)address, (List<UserInfo>)alts));
        })).whenComplete(FutureUtils::printStacktrace));
    }

    public boolean kick(@NotNull CommandSender sender, @NotNull Player victim, @NotNull PunishmentReason reason, boolean silent) {
        if (!this.dataLoaded) {
            this.sendPrefixed(BansLang.ERROR_DATA_NOT_LOADED_ADMIN_FEEDBACK, sender);
            return false;
        }
        if (victim == sender) {
            this.sendPrefixed(BansLang.KICK_ERROR_YOURSELF, sender, (PlaceholderContext.Builder builder) -> builder.with(CommonPlaceholders.PLAYER.resolver((Object)victim)));
            return false;
        }
        if (this.hasImmunity(victim)) {
            this.sendPrefixed(BansLang.IMMUNITY_FEEDBACK, sender, (PlaceholderContext.Builder builder) -> builder.with("%target%", () -> ((Player)victim).getName()));
            return false;
        }
        int senderPriority = this.getRankPriority(sender);
        int victimPriority = this.getRankPriority((CommandSender)victim);
        if (victimPriority >= senderPriority) {
            this.sendPrefixed(BansLang.KICK_ERROR_LOW_PRIORITY, sender, (PlaceholderContext.Builder builder) -> builder.with(CommonPlaceholders.PLAYER.resolver((Object)victim)));
            return false;
        }
        PlaceholderContext context = PlaceholderContext.builder().with(CommonPlaceholders.PLAYER.resolver((Object)victim)).with("%reason%", reason::getText).with("%executor%", () -> SLUtils.getSenderName(sender)).with("%punishment_user%", () -> Players.getDisplayNameSerialized((Player)victim)).with("%punishment_reason%", reason::getText).with("%punishment_punisher%", () -> SLUtils.getSenderName(sender)).build();
        Players.kick((Player)victim, (NightComponent)NightMessage.parse((String)context.apply(String.join((CharSequence)"\n", (Iterable)this.settings.disconnectScreenKick.get()))));
        this.sendPrefixed(BansLang.KICK_FEEDBACK, sender, context);
        if (!silent) {
            this.broadcastPrefixed(BansLang.KICK_BROADCAST, context);
        }
        return true;
    }

    @NotNull
    public CompletableFuture<Boolean> punishPlayer(@NotNull CommandSender sender, @NotNull UserInfo victim, @NotNull PunishmentContext context) {
        return ((CompletableFuture)this.getRankPriority(victim).thenApplyAsync(victimPriority -> this.punishPlayer(sender, victim, (int)victimPriority, context), arg_0 -> ((SunLightPlugin)((SunLightPlugin)this.plugin)).runTask(arg_0))).whenComplete(FutureUtils::printStacktrace);
    }

    public boolean punishPlayer(@NotNull CommandSender sender, @NotNull Player victim, @NotNull PunishmentContext context) {
        return this.punishPlayer(sender, UserInfo.of((Player)victim), this.getRankPriority((CommandSender)victim), context);
    }

    private boolean punishPlayer(@NotNull CommandSender sender, @NotNull UserInfo victim, int victimPriority, @NotNull PunishmentContext context) {
        List commands;
        if (!this.dataLoaded) {
            this.sendPrefixed(BansLang.ERROR_DATA_NOT_LOADED_ADMIN_FEEDBACK, sender);
            return false;
        }
        String playerName = victim.name();
        UUID playerId = victim.id();
        PunishmentType type = context.type();
        if (victim.isUser(sender)) {
            MessageLocale locale = switch (type) {
                default -> throw new MatchException(null, null);
                case PunishmentType.BAN -> BansLang.BAN_ERROR_YOURSELF;
                case PunishmentType.MUTE -> BansLang.MUTE_ERROR_YOURSELF;
                case PunishmentType.WARN -> BansLang.WARN_ERROR_YOURSELF;
            };
            this.sendPrefixed(locale, sender, (PlaceholderContext.Builder builder) -> builder.with("%player_name%", () -> playerName));
            return false;
        }
        if (this.hasImmunity(playerName) || this.hasImmunity(playerId.toString())) {
            this.sendPrefixed(BansLang.IMMUNITY_FEEDBACK, sender, (PlaceholderContext.Builder builder) -> builder.with("%target%", () -> playerName));
            return false;
        }
        int senderPriority = this.getRankPriority(sender);
        if (victimPriority >= senderPriority) {
            MessageLocale locale = switch (type) {
                default -> throw new MatchException(null, null);
                case PunishmentType.BAN -> BansLang.BAN_ERROR_LOW_PRIORITY;
                case PunishmentType.MUTE -> BansLang.MUTE_ERROR_LOW_PRIORITY;
                case PunishmentType.WARN -> BansLang.WARN_ERROR_LOW_PRIORITY;
            };
            this.sendPrefixed(locale, sender, (PlaceholderContext.Builder builder) -> builder.with("%player_name%", () -> playerName));
            return false;
        }
        PunishmentRepository repository = this.getPunishmentRepository(type);
        Set<PlayerPunishment> activePunishments = repository.getActivePlayerPunishments(playerId);
        BanTime banTime = context.time();
        PunishmentReason reason = context.reason();
        boolean silent = context.silent();
        if (!sender.hasPermission(BansPerms.BYPASS_DURATION_LIMIT)) {
            BanTime maxTime = this.getGreatestDuration(sender, type);
            if (banTime.isGreater(maxTime)) {
                MessageLocale locale = switch (type) {
                    default -> throw new MatchException(null, null);
                    case PunishmentType.BAN -> BansLang.BAN_ERROR_HIGH_DURATION;
                    case PunishmentType.MUTE -> BansLang.MUTE_ERROR_HIGH_DURATION;
                    case PunishmentType.WARN -> BansLang.WARN_ERROR_HIGH_DURATION;
                };
                this.sendPrefixed(locale, sender, (PlaceholderContext.Builder builder) -> builder.with("%time%", () -> TimeFormats.toLiteral((long)maxTime.accumulated())));
                return false;
            }
            if (type != PunishmentType.WARN && activePunishments.stream().anyMatch(punishment -> banTime.isSmaller(punishment.getRemainingDuration()))) {
                MessageLocale locale = switch (type) {
                    case PunishmentType.BAN -> BansLang.BAN_ERROR_HIGHER_EXISTS;
                    case PunishmentType.MUTE -> BansLang.MUTE_ERROR_HIGHER_EXISTS;
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)type));
                };
                this.sendPrefixed(locale, sender, (PlaceholderContext.Builder builder) -> builder.with("%time%", () -> TimeFormats.toLiteral((long)banTime.accumulated())));
                return false;
            }
        }
        int punishments = activePunishments.size() + 1;
        int maxWarns = (Integer)this.settings.warnMaxAmountToReset.get();
        if (type != PunishmentType.WARN || maxWarns > 0 && punishments >= maxWarns) {
            activePunishments.forEach(punishment -> {
                punishment.setActive(false);
                punishment.markDirty();
                repository.updatePlayerPunishmentReferences((PlayerPunishment)punishment);
            });
        }
        UUID banId = UUID.randomUUID();
        String who = sender.getName();
        long duration = banTime.accumulated();
        long createDate = System.currentTimeMillis();
        long expireDate = banTime.futureTimestamp();
        String textReason = reason.getText();
        PunishmentData data = new PunishmentData(banId, type, textReason, who, duration, createDate, expireDate);
        PlayerPunishment punishment2 = new PlayerPunishment(playerId, playerName, data, true);
        MessageLocale feedbackLocale = switch (type) {
            default -> throw new MatchException(null, null);
            case PunishmentType.BAN -> {
                if (punishment2.isPermanent()) {
                    yield BansLang.BAN_PERMANENT_FEEDBACK;
                }
                yield BansLang.BAN_TEMPORARY_FEEDBACK;
            }
            case PunishmentType.MUTE -> {
                if (punishment2.isPermanent()) {
                    yield BansLang.MUTE_PERMANENT_FEEDBACK;
                }
                yield BansLang.MUTE_TEMPORARY_FEEDBACK;
            }
            case PunishmentType.WARN -> punishment2.isPermanent() ? BansLang.WARN_PERMANENT_FEEDBACK : BansLang.WARN_TEMPORARY_FEEDBACK;
        };
        MessageLocale broadcastLocale = switch (type) {
            default -> throw new MatchException(null, null);
            case PunishmentType.BAN -> {
                if (punishment2.isPermanent()) {
                    yield BansLang.BAN_PERMANENT_BROADCAST;
                }
                yield BansLang.BAN_TEMPORARY_BROADCAST;
            }
            case PunishmentType.MUTE -> {
                if (punishment2.isPermanent()) {
                    yield BansLang.MUTE_PERMANENT_BROADCAST;
                }
                yield BansLang.MUTE_TEMPORARY_BROADCAST;
            }
            case PunishmentType.WARN -> punishment2.isPermanent() ? BansLang.WARN_PERMANENT_BROADCAST : BansLang.WARN_TEMPORARY_BROADCAST;
        };
        MessageLocale notifyLocale = switch (type) {
            default -> throw new MatchException(null, null);
            case PunishmentType.BAN -> null;
            case PunishmentType.MUTE -> {
                if (punishment2.isPermanent()) {
                    yield BansLang.MUTE_PERMANENT_NOTIFY;
                }
                yield BansLang.MUTE_TEMPORARY_NOTIFY;
            }
            case PunishmentType.WARN -> punishment2.isPermanent() ? BansLang.WARN_PERMANENT_NOTIFY : BansLang.WARN_TEMPORARY_NOTIFY;
        };
        this.addPlayerPunishment(punishment2);
        this.notifyPunishment(punishment2, sender, feedbackLocale, broadcastLocale, notifyLocale, silent);
        if (type == PunishmentType.WARN && (commands = (List)((Map)this.settings.warnAutoCommands.get()).get(punishments)) != null && !commands.isEmpty()) {
            PlaceholderContext commandsContext = PlaceholderContext.builder().with(punishment2.placeholders()).with("%player_name%", () -> playerName).build();
            commands.replaceAll(arg_0 -> ((PlaceholderContext)commandsContext).apply(arg_0));
            ConsoleCommandSender console = ((SunLightPlugin)this.plugin).getServer().getConsoleSender();
            ((SunLightPlugin)this.plugin).runTask(() -> this.lambda$punishPlayer$38(commands, (CommandSender)console));
        }
        return true;
    }

    public boolean banInet(@NotNull CommandSender sender, @NotNull InetAddress address, @NotNull PunishmentReason reason, @NotNull BanTime banTime, boolean silent) {
        if (!this.dataLoaded) {
            this.sendPrefixed(BansLang.ERROR_DATA_NOT_LOADED_ADMIN_FEEDBACK, sender);
            return false;
        }
        if (this.hasImmunity(address)) {
            this.sendPrefixed(BansLang.IMMUNITY_FEEDBACK, sender, (PlaceholderContext.Builder builder) -> builder.with("%target%", address::getHostAddress));
            return false;
        }
        UUID banId = UUID.randomUUID();
        String admin = sender.getName();
        long duration = banTime.accumulated();
        long createDate = System.currentTimeMillis();
        long expireDate = banTime.futureTimestamp();
        String textReason = reason.getText();
        PunishmentData data = new PunishmentData(banId, PunishmentType.BAN, textReason, admin, duration, createDate, expireDate);
        InetPunishment punishment = new InetPunishment(address, data, true);
        MessageLocale feedbackLocale = punishment.isPermanent() ? BansLang.BAN_INET_PERMANENT_FEEDBACK : BansLang.BAN_INET_TEMPORARY_FEEDBACK;
        MessageLocale broadcastLocale = punishment.isPermanent() ? BansLang.BAN_INET_PERMANENT_BROADCAST : BansLang.BAN_INET_TEMPORARY_BROADCAST;
        MessageLocale notifyLocale = null;
        this.addInetPunishment(punishment);
        this.notifyPunishment(punishment, sender, feedbackLocale, broadcastLocale, notifyLocale, silent);
        return true;
    }

    private void notifyPunishment(@NotNull AbstractPunishment punishment, @NotNull CommandSender sender, @NotNull MessageLocale feedbackLocale, @NotNull MessageLocale broadcastLocale, @Nullable MessageLocale notifyLocale, boolean silent) {
        PlaceholderContext context = PlaceholderContext.builder().with(punishment.placeholders()).build();
        this.sendPrefixed(feedbackLocale, sender, context);
        if (!silent) {
            this.broadcastPrefixed(broadcastLocale, context);
        }
        Set<Player> targets = this.getPlayersToPunish(punishment);
        if (punishment.getType() == PunishmentType.BAN) {
            targets.forEach(target -> Players.kick((Player)target, (String)this.getKickScreenText(punishment)));
        } else if (notifyLocale != null) {
            this.sendPrefixed(notifyLocale, targets, context);
        }
    }

    public boolean pardonPlayer(@NotNull UserInfo user, @NotNull CommandSender sender, @NotNull PunishmentType type, boolean silent) {
        if (!this.dataLoaded) {
            this.sendPrefixed(BansLang.ERROR_DATA_NOT_LOADED_ADMIN_FEEDBACK, sender);
            return false;
        }
        String playerName = user.name();
        UUID playerId = user.id();
        Set<PlayerPunishment> activePunishments = this.getActivePlayerPunishments(playerId, type);
        if (activePunishments.isEmpty()) {
            MessageLocale locale = switch (type) {
                default -> throw new MatchException(null, null);
                case PunishmentType.BAN -> BansLang.UNBAN_PLAYER_ERROR_NOT_BANNED;
                case PunishmentType.MUTE -> BansLang.UNMUTE_ERROR_NOT_MUTED;
                case PunishmentType.WARN -> BansLang.UNWARN_ERROR_NOT_WARNED;
            };
            this.sendPrefixed(locale, sender, (PlaceholderContext.Builder builder) -> builder.with("%punishment_user%", () -> playerName));
            return false;
        }
        if (((Boolean)this.settings.durationLimitsForPardon.get()).booleanValue() && !sender.hasPermission(BansPerms.BYPASS_DURATION_LIMIT)) {
            BanTime maxTime = this.getGreatestDuration(sender, type);
            if (activePunishments.stream().anyMatch(punishment -> maxTime.isSmaller(punishment.getRemainingDuration()))) {
                MessageLocale locale = switch (type) {
                    default -> throw new MatchException(null, null);
                    case PunishmentType.BAN -> BansLang.UNBAN_ERROR_HIGH_DURATION;
                    case PunishmentType.MUTE -> BansLang.UNMUTE_ERROR_HIGH_DURATION;
                    case PunishmentType.WARN -> BansLang.UNWARN_ERROR_HIGH_DURATION;
                };
                this.sendPrefixed(locale, sender, (PlaceholderContext.Builder builder) -> builder.with("%time%", () -> TimeFormats.toLiteral((long)maxTime.accumulated())));
                return false;
            }
        }
        MessageLocale feedbackLocale = switch (type) {
            default -> throw new MatchException(null, null);
            case PunishmentType.BAN -> BansLang.UNBAN_PLAYER_FEEDBACK;
            case PunishmentType.MUTE -> BansLang.UNMUTE_SUCCESS_FEEDBACK;
            case PunishmentType.WARN -> BansLang.UNWARN_SUCCESS_FEEDBACK;
        };
        MessageLocale broadcastLocale = switch (type) {
            default -> throw new MatchException(null, null);
            case PunishmentType.BAN -> BansLang.UNBAN_PLAYER_BROADCAST;
            case PunishmentType.MUTE -> BansLang.UNMUTE_SUCCESS_BROADCAST;
            case PunishmentType.WARN -> BansLang.UNWARN_SUCCESS_BROADCAST;
        };
        MessageLocale notifyLocale = switch (type) {
            default -> throw new MatchException(null, null);
            case PunishmentType.BAN -> null;
            case PunishmentType.MUTE -> BansLang.UNMUTE_SUCCESS_NOTIFY;
            case PunishmentType.WARN -> BansLang.UNWARN_SUCCESS_NOTIFY;
        };
        activePunishments.forEach(punishment -> {
            punishment.setActive(false);
            punishment.markDirty();
            this.getPunishmentRepository(type).updatePlayerPunishmentReferences((PlayerPunishment)punishment);
        });
        this.notifyPardon(activePunishments, sender, feedbackLocale, broadcastLocale, notifyLocale, silent);
        return true;
    }

    public boolean pardonInet(@NotNull InetAddress address, @NotNull CommandSender sender, boolean silent) {
        if (!this.dataLoaded) {
            this.sendPrefixed(BansLang.ERROR_DATA_NOT_LOADED_ADMIN_FEEDBACK, sender);
            return false;
        }
        Set<InetPunishment> activePunishments = this.getActiveInetPunishments(address);
        if (activePunishments.isEmpty()) {
            this.sendPrefixed(BansLang.UNBAN_INET_ERROR_NOT_BANNED, sender, (PlaceholderContext.Builder builder) -> builder.with("%target%", address::getHostAddress).with("%punishment_user%", address::getHostAddress));
            return false;
        }
        MessageLocale feedbackLocale = BansLang.UNBAN_INET_FEEDBACK;
        MessageLocale broadcastLocale = BansLang.UNBAN_INET_BROADCAST;
        activePunishments.forEach(punishment -> {
            punishment.setActive(false);
            punishment.markDirty();
            this.getPunishmentRepository(punishment.getType()).updateInetPunishmentReferences((InetPunishment)punishment);
        });
        this.notifyPardon(activePunishments, sender, feedbackLocale, broadcastLocale, null, silent);
        return true;
    }

    private void notifyPardon(@NotNull Collection<? extends AbstractPunishment> punishments, @NotNull CommandSender sender, @NotNull MessageLocale feedbackLocale, @NotNull MessageLocale broadcastLocale, @Nullable MessageLocale notifyLocale, boolean silent) {
        punishments.forEach(punishment -> {
            PlaceholderContext context = PlaceholderContext.builder().with(punishment.placeholders()).with("%executor%", () -> SLUtils.getSenderName(sender)).build();
            this.sendPrefixed(feedbackLocale, sender, context);
            if (notifyLocale != null) {
                this.getPlayersToPunish((AbstractPunishment)punishment).forEach(player -> this.sendPrefixed(notifyLocale, (CommandSender)player, context));
            }
            if (!silent) {
                this.broadcastPrefixed(broadcastLocale, context);
            }
        });
    }

    @NotNull
    private String getKickScreenText(@NotNull AbstractPunishment punishment) {
        List text = punishment instanceof PlayerPunishment ? (punishment.isPermanent() ? (List)this.settings.disconnectScreenPermaBan.get() : (List)this.settings.disconnectScreenTempBan.get()) : (List)this.settings.disconnectScreenIpBan.get();
        PlaceholderContext context = PlaceholderContext.builder().with(punishment.placeholders()).build();
        return context.apply(String.join((CharSequence)"\n", text));
    }

    @NotNull
    public CompletableFuture<List<UserInfo>> lookupAltProfiles(@NotNull InetAddress address) {
        return CompletableFuture.supplyAsync(() -> this.dataHandler.getProfilesByInet(address));
    }

    public void notifyAltProfiles(@NotNull CommandSender sender, @NotNull UserInfo profile, @NotNull InetAddress address, @NotNull List<UserInfo> alts) {
        alts.removeIf(alt -> alt.id().equals(profile.id()));
        if (alts.isEmpty()) {
            this.sendPrefixed(BansLang.ALTS_GLOBAL_NOTHING, sender, (PlaceholderContext.Builder builder) -> builder.with("%player_name%", () -> ((UserInfo)profile).name()));
            return;
        }
        PlaceholderContext context = PlaceholderContext.builder().with("%player_name%", () -> ((UserInfo)profile).name()).with("%amount%", () -> String.valueOf(alts.size())).with("%address%", address::getHostAddress).with("%entry%", () -> alts.stream().map(alt -> PlaceholderContext.builder().with("%name%", () -> ((UserInfo)alt).name()).build().apply(BansLang.ALTS_GLOBAL_ENTRY.text())).collect(Collectors.joining("\n"))).build();
        this.sendPrefixed(BansLang.ALTS_GLOBAL_LIST, sender, context);
    }

    @Nullable
    public BanTimeUnit getTimeUnitByAlias(@NotNull String alias) {
        return this.timeUnitAliasMap.get(LowerCase.INTERNAL.apply(alias));
    }

    @NotNull
    public List<String> getTimeUnitAliases() {
        return List.copyOf(this.timeUnitAliasMap.keySet());
    }

    private /* synthetic */ void lambda$punishPlayer$38(List commands, CommandSender console) {
        commands.forEach(command -> ((SunLightPlugin)this.plugin).getServer().dispatchCommand(console, command));
    }
}

