/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.backlocation.command;

import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.sunlight.SLPlaceholders;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.backlocation.BackLocationModule;
import su.nightexpress.sunlight.module.backlocation.config.BackLocationLang;
import su.nightexpress.sunlight.module.backlocation.config.BackLocationPerms;
import su.nightexpress.sunlight.module.backlocation.data.LocationType;
import su.nightexpress.sunlight.user.UserManager;

public class DeathBackCommandProvider
extends AbstractCommandProvider {
    private final BackLocationModule module;
    private final UserManager userManager;

    public DeathBackCommandProvider(@NotNull SunLightPlugin plugin, @NotNull BackLocationModule module, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral("deathback", true, new String[]{"deathback", "dback"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(BackLocationLang.COMMAND_DEATH_BACK_DESC)).permission(BackLocationPerms.COMMAND_DEATHBACK)).withArguments(new ArgumentNodeBuilder[]{(ArgumentNodeBuilder)Arguments.playerName((String)"player").optional().permission(BackLocationPerms.COMMAND_DEATHBACK_OTHERS)}).withFlags(new String[]{"s"}).executes(this::moveToDeathLocation));
    }

    private boolean moveToDeathLocation(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        return this.loadPlayerOrSenderAndRunInMainThread(context, arguments, this.module, this.userManager, target -> {
            boolean silent = context.hasFlag("s");
            if (!this.module.teleportToLocation((Player)target, LocationType.DEATH, silent)) {
                if (context.getSender() != target) {
                    this.module.sendPrefixed(BackLocationLang.DEATH_ERROR_NOTHING_FEEDBACK, context.getSender(), builder -> builder.andThen(SLPlaceholders.forPlayerWithPAPI((Player)target)));
                }
                return;
            }
            if (context.getSender() != target) {
                this.module.sendPrefixed(BackLocationLang.DEATH_TELEPORT_FEEDBACK, context.getSender(), builder -> builder.andThen(SLPlaceholders.forPlayerWithPAPI((Player)target)));
            }
        });
    }
}

