/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.afk.core;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.configuration.AbstractConfig;
import su.nightexpress.nightcore.configuration.ConfigProperty;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.configuration.ConfigTypes;
import su.nightexpress.nightcore.util.Enums;
import su.nightexpress.nightcore.util.RankTable;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SLConfigTypes;
import su.nightexpress.sunlight.module.afk.ActivityType;

public class AfkSettings
extends AbstractConfig {
    public final ConfigProperty<Integer> wakeUpThreshold = this.addProperty(ConfigTypes.INT, "WakeUp.Threshold", 3, new String[]{"Sets the activity threshold that a player must reach to lose the AFK mode."});
    public final ConfigProperty<Integer> wakeUpTimer = this.addProperty(ConfigTypes.INT, "WakeUp.Timeout", 5, new String[]{"The duration (in seconds) a player has to meet the activity threshold to leave AFK mode.", "If the player does not meet the threshold within this time, the timer and activity points reset, and they remain AFK until the next cycle."});
    public final ConfigProperty<Map<ActivityType, Integer>> wakeUpActivityPoints = this.addProperty(ConfigTypes.forMap(str -> (ActivityType)Enums.get((String)str, ActivityType.class), Enum::name, (ConfigType)ConfigTypes.INT), "WakeUp.Activity-Points", Map.of(ActivityType.MOVEMENT, 1, ActivityType.CHAT, 5, ActivityType.COMMAND, 3, ActivityType.INTERACT, 1), new String[]{"Sets how much activity points produced by certain player actions."});
    public final ConfigProperty<List<String>> wakeUpCommands = this.addProperty(ConfigTypes.STRING_LIST, "WakeUp.Commands", List.of(), new String[]{"The following commands will be dispatched right before player leave AFK mode.", "[*] Placeholders: '%s', %s".formatted("%player_name%", "PlaceholderAPI")});
    public final ConfigProperty<Boolean> afkStatusBarEnabled = this.addProperty(ConfigTypes.BOOLEAN, "AFK.Status-Bar.Enabled", true, new String[]{"Controls whether AFK status bar is enabled for AFK players."});
    public final ConfigProperty<String> afkStatusBarText = this.addProperty(ConfigTypes.STRING, "AFK.Status-Bar.Text", TagWrappers.DARK_GRAY.wrap("[" + TagWrappers.ORANGE.wrap("AFK") + "]") + " " + TagWrappers.GRAY.wrap("You're being AFK for ") + TagWrappers.ORANGE.wrap("%time%"), new String[]{"Set AFK status bar message for AFK players.", "[*] Placeholders: '%s', %s".formatted("%time%", "PlaceholderAPI")});
    public final ConfigProperty<Integer> idleThreshold = this.addProperty(ConfigTypes.INT, "AFK.Cooldown", 60, new String[]{"The cooldown period (in seconds) after a player leaves AFK mode.", "During this time, the player will be immune to being marked as inactive, even if they produce no activity."});
    public final ConfigProperty<RankTable> idleAfkTimes = this.addProperty(SLConfigTypes.RANK_TABLE, "AFK.Idle_Time", RankTable.builder((RankTable.Mode)RankTable.Mode.RANK, (double)600.0).addRankValue("vip", 900.0).addRankValue("admin", -1.0).build(), new String[]{"Here you can set the inactivity time (in seconds) after which a player will be placed into AFK mode.", "You can set different times for different ranks or permissions (read comments).", "If multiple times are available, the greatest (or negative) one will be used.", "Use '-1' to make players immune to the auto-AFK mode."});
    public final ConfigProperty<RankTable> idleKickTimes = this.addProperty(SLConfigTypes.RANK_TABLE, "AFK.Kick_Time", RankTable.builder((RankTable.Mode)RankTable.Mode.RANK, (double)1200.0).addRankValue("vip", -1.0).addRankValue("admin", -1.0).build(), new String[]{"Here you can set the total inactivity time (in seconds) after which a player will be kicked from the server.", "[*] IMPORTANT: This value sets the TOTAL time (Time before AFK + Time after AFK), not just the time starting from when the player entered AFK mode.", "If multiple times are available, the greatest (or negative) one will be used.", "Use '-1' to make players immune from being kicked due to AFK."});
    public final ConfigProperty<List<String>> kickText = this.addProperty(ConfigTypes.STRING_LIST, "AFK.Kick_Message", List.of(TagWrappers.SOFT_RED.wrap("You have been kicked for being AFK too long: " + TagWrappers.SOFT_YELLOW.wrap("%time%")), "", TagWrappers.GREEN.and((TagWrapper)TagWrappers.UNDERLINED).wrap("You can join back now.")), new String[]{"Kick message for players kicked for being AFK long enough.", "[*] Placeholders: '%s', %s".formatted("%time%", "PlaceholderAPI")});
    public final ConfigProperty<List<String>> afkCommands = this.addProperty(ConfigTypes.STRING_LIST, "AFK.Commands", List.of(), new String[]{"The following commands will be dispatched right before player enter AFK mode.", "[*] Placeholders: '%s', %s".formatted("%player_name%", "PlaceholderAPI")});

    public int getActivityPoints(@NotNull ActivityType type) {
        return ((Map)this.wakeUpActivityPoints.get()).getOrDefault((Object)type, 0);
    }
}

