/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.afk.command;

import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.mode.ToggleMode;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.afk.AfkModule;
import su.nightexpress.sunlight.module.afk.core.AfkLang;
import su.nightexpress.sunlight.module.afk.core.AfkPerms;

public class AfkCommandProvider
extends AbstractCommandProvider {
    private static final String COMMAND_TOGGLE = "toggle";
    private static final String COMMAND_ON = "on";
    private static final String COMMAND_OFF = "off";
    private final AfkModule module;

    public AfkCommandProvider(@NotNull SunLightPlugin plugin, @NotNull AfkModule module) {
        super(plugin);
        this.module = module;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_TOGGLE, true, new String[]{"afk"}, builder -> this.buildCommand((LiteralNodeBuilder)builder, ToggleMode.TOGGLE));
        this.registerLiteral(COMMAND_ON, false, new String[]{"afk-on"}, builder -> this.buildCommand((LiteralNodeBuilder)builder, ToggleMode.ON));
        this.registerLiteral(COMMAND_OFF, false, new String[]{"afk-off"}, builder -> this.buildCommand((LiteralNodeBuilder)builder, ToggleMode.OFF));
    }

    private void buildCommand(@NotNull LiteralNodeBuilder builder, @NotNull ToggleMode mode) {
        TextLocale description = switch (mode) {
            default -> throw new MatchException(null, null);
            case ToggleMode.ON -> AfkLang.COMMAND_AFK_ON_DESC;
            case ToggleMode.OFF -> AfkLang.COMMAND_AFK_OFF_DESC;
            case ToggleMode.TOGGLE -> AfkLang.COMMAND_AFK_TOGGLE_DESC;
        };
        ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(description)).permission(AfkPerms.COMMAND_AFK)).withArguments(new ArgumentNodeBuilder[]{(ArgumentNodeBuilder)Arguments.player((String)"player").optional().permission(AfkPerms.COMMAND_AFK_OTHERS)}).withFlags(new String[]{"s"}).executes((context, arguments) -> this.toggleAfkMode(context, arguments, mode));
    }

    private boolean toggleAfkMode(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull ToggleMode mode) {
        return this.runForOnlinePlayerOrSender(context, arguments, this.module, target -> {
            boolean state = mode.apply(this.module.isAfk((Player)target));
            if (state) {
                this.module.enterAfk((Player)target, false);
            } else {
                this.module.exitAfk((Player)target, false);
            }
            if (context.getSender() != target) {
                this.module.sendPrefixed(AfkLang.AFK_TOGGLE_FEEDBACK, context.getSender(), builder -> builder.with(CommonPlaceholders.PLAYER.resolver(target)));
            }
            return true;
        });
    }
}

