/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.sunlight.SLConfigTypes;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.exception.ModuleLoadException;
import su.nightexpress.sunlight.module.LoadCondition;
import su.nightexpress.sunlight.module.Module;
import su.nightexpress.sunlight.module.ModuleContext;
import su.nightexpress.sunlight.module.ModuleDefinition;
import su.nightexpress.sunlight.module.ModuleFactory;
import su.nightexpress.sunlight.module.ModuleRegistration;
import su.nightexpress.sunlight.module.ModuleRegistry;

public class ModuleLoader {
    private final SunLightPlugin plugin;
    private final ModuleRegistry moduleRegistry;
    private final Map<String, ModuleRegistration> registrationMap;
    private final Map<String, ModuleDefinition> definitionMap;

    public ModuleLoader(@NotNull SunLightPlugin plugin, @NotNull ModuleRegistry moduleRegistry) {
        this.plugin = plugin;
        this.moduleRegistry = moduleRegistry;
        this.registrationMap = new HashMap<String, ModuleRegistration>();
        this.definitionMap = new LinkedHashMap<String, ModuleDefinition>();
    }

    public <T extends Module> void register(@NotNull String id, @NotNull ModuleDefinition definition, @NotNull ModuleFactory<T> factory) {
        this.register(id, definition, factory, LoadCondition::success);
    }

    public <T extends Module> void register(@NotNull String id, @NotNull ModuleDefinition definition, @NotNull ModuleFactory<T> factory, @NotNull Supplier<LoadCondition> condition) {
        this.definitionMap.put(id, definition);
        this.registrationMap.put(id, new ModuleRegistration(factory, condition));
    }

    public void loadAll() {
        FileConfig config = FileConfig.load((String)this.plugin.getDataFolder().getAbsolutePath(), (String)"modules.yml");
        FileConfig pluginConfig = this.plugin.getConfig();
        this.definitionMap.forEach((id, defaultDefinition) -> {
            if (pluginConfig.contains("Modules." + id)) {
                boolean oldValue = pluginConfig.getBoolean("Modules." + id);
                config.set("Modules." + id + ".Enabled", (Object)oldValue);
                pluginConfig.remove("Modules." + id);
            }
            ModuleDefinition definition = (ModuleDefinition)config.get(SLConfigTypes.MODULE_DEFINITION, "Modules." + id, defaultDefinition, new String[0]);
            try {
                this.loadModule((String)id, definition);
            }
            catch (ModuleLoadException exception) {
                this.plugin.error("Fatal error when trying to load module '%s': %s".formatted(id, exception.getMessage()));
            }
        });
        config.saveChanges();
        pluginConfig.remove("Modules");
        pluginConfig.saveChanges();
    }

    private boolean loadModule(@NotNull String id, @NotNull ModuleDefinition definition) throws ModuleLoadException {
        if (!definition.enabled()) {
            return false;
        }
        ModuleRegistration registration = this.registrationMap.remove(id);
        if (registration == null) {
            throw new ModuleLoadException("No loader present");
        }
        if (this.moduleRegistry.isPresent(id)) {
            throw new ModuleLoadException("Module with ID '%s' is already registered");
        }
        LoadCondition condition = registration.getCondition().get();
        if (!condition.isSuccess()) {
            this.plugin.error("Module '%s' can not be loaded: '%s'".formatted(id, condition.reason().orElse(null)));
            return false;
        }
        Path path = Paths.get(String.valueOf(this.plugin.getDataFolder()) + "/modules/", id);
        ModuleContext context = this.plugin.createModuleContext(id, path, definition);
        Object module = registration.getFactory().load(context);
        return this.moduleRegistry.register((Module)((Object)module));
    }
}

