/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module;

import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.config.Writeable;
import su.nightexpress.nightcore.configuration.ConfigTypes;
import su.nightexpress.nightcore.util.text.night.wrapper.SimpleTagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public record ModuleDefinition(boolean enabled, @NotNull String name, @NotNull String prefix) implements Writeable
{
    @NotNull
    public static ModuleDefinition named(@NotNull String name) {
        return new ModuleDefinition(true, name, ModuleDefinition.defaultPrefix(name));
    }

    @NotNull
    public static ModuleDefinition read(@NotNull FileConfig config, @NotNull String path) {
        boolean enabled = (Boolean)config.get(ConfigTypes.BOOLEAN, path + ".Enabled", (Object)true, new String[0]);
        String name = (String)config.get(ConfigTypes.STRING, path + ".Name", (Object)"null", new String[0]);
        String prefix = (String)config.get(ConfigTypes.STRING, path + ".Prefix", (Object)ModuleDefinition.defaultPrefix(name), new String[0]);
        return new ModuleDefinition(enabled, name, prefix);
    }

    public void write(@NotNull FileConfig config, @NotNull String path) {
        config.set(path + ".Enabled", (Object)this.enabled);
        config.set(path + ".Name", (Object)this.name);
    }

    @NotNull
    private static String defaultPrefix(@NotNull String name) {
        return ((SimpleTagWrapper)TagWrappers.GRADIENT_3.with("#FFAA00", "#FF8833", "#FF5500")).wrap(TagWrappers.BOLD.wrap(name.toUpperCase(Locale.ROOT))) + TagWrappers.DARK_GRAY.wrap(" \u00bb ");
    }
}

