/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import su.nightexpress.nightcore.db.column.Column;
import su.nightexpress.nightcore.db.statement.RowMapper;
import su.nightexpress.nightcore.db.statement.template.InsertStatement;
import su.nightexpress.nightcore.db.statement.template.SelectStatement;
import su.nightexpress.nightcore.db.statement.template.UpdateStatement;
import su.nightexpress.nightcore.user.UserInfo;
import su.nightexpress.nightcore.user.UserTemplate;
import su.nightexpress.sunlight.data.DataHandler;
import su.nightexpress.sunlight.data.UserColumns;
import su.nightexpress.sunlight.user.SunUser;

public class DataQueries {
    public static final RowMapper<InetAddress> INET_MAPPER = resultSet -> {
        try {
            return UserColumns.INET_ADDRESS.read(resultSet).map(string -> {
                try {
                    return InetAddress.getByName(string);
                }
                catch (UnknownHostException exception) {
                    exception.printStackTrace();
                    return null;
                }
            }).orElse(null);
        }
        catch (SQLException exception) {
            exception.printStackTrace();
            return null;
        }
    };
    public static final RowMapper<UserInfo> PROFILE_MAPPER = resultSet -> {
        try {
            UUID uuid = (UUID)UserColumns.UUID.read(resultSet).orElseThrow();
            String name = (String)UserColumns.NAME.read(resultSet).orElseThrow();
            return new UserInfo(uuid, name);
        }
        catch (SQLException exception) {
            exception.printStackTrace();
            return null;
        }
    };
    public static final RowMapper<SunUser> USER_MAPPER = resultSet -> {
        try {
            UUID uuid = (UUID)UserColumns.UUID.readOrThrow(resultSet);
            String name = (String)UserColumns.NAME.readOrThrow(resultSet);
            long dateCreated = (Long)UserColumns.DATE_CREATED.readOrThrow(resultSet);
            long lastOnline = (Long)UserColumns.LAST_ONLINE.readOrThrow(resultSet);
            InetAddress latestAddress = (InetAddress)INET_MAPPER.map(resultSet);
            Map commandCooldowns = (Map)UserColumns.COMMAND_COOLDOWNS.readOrThrow(resultSet);
            Map properties = (Map)UserColumns.PROPERTIES.readOrThrow(resultSet);
            return new SunUser(uuid, name, dateCreated, lastOnline, latestAddress, commandCooldowns, properties);
        }
        catch (SQLException exception) {
            exception.printStackTrace();
            return null;
        }
    };
    public static final UpdateStatement<SunUser> UPDATE_USER = ((UpdateStatement.Builder)((UpdateStatement.Builder)((UpdateStatement.Builder)((UpdateStatement.Builder)((UpdateStatement.Builder)((UpdateStatement.Builder)UpdateStatement.builder(SunUser.class).setUUID(UserColumns.UUID, UserTemplate::getId)).setString(UserColumns.NAME, UserTemplate::getName)).setLong(UserColumns.LAST_ONLINE, SunUser::getLastOnline)).setString(UserColumns.INET_ADDRESS, user -> user.getLatestAddress().map(InetAddress::getHostAddress).orElse("0.0.0.0"))).setString(UserColumns.COMMAND_COOLDOWNS, user -> DataHandler.GSON.toJson(user.getCommandCooldowns()))).setString(UserColumns.PROPERTIES, user -> DataHandler.GSON.toJson(user.getPropertiesToSave()))).build();
    public static final UpdateStatement<SunUser> UPDATE_USER_TINY = ((UpdateStatement.Builder)((UpdateStatement.Builder)((UpdateStatement.Builder)UpdateStatement.builder(SunUser.class).setString(UserColumns.NAME, UserTemplate::getName)).setString(UserColumns.INET_ADDRESS, user -> user.getLatestAddress().map(InetAddress::getHostAddress).orElse("0.0.0.0"))).setLong(UserColumns.LAST_ONLINE, SunUser::getLastOnline)).build();
    public static final InsertStatement<SunUser> INSERT_USER = ((InsertStatement.Builder)((InsertStatement.Builder)((InsertStatement.Builder)((InsertStatement.Builder)((InsertStatement.Builder)((InsertStatement.Builder)((InsertStatement.Builder)InsertStatement.builder(SunUser.class).setUUID(UserColumns.UUID, UserTemplate::getId)).setString(UserColumns.NAME, UserTemplate::getName)).setLong(UserColumns.DATE_CREATED, SunUser::getDateCreated)).setLong(UserColumns.LAST_ONLINE, SunUser::getLastOnline)).setString(UserColumns.INET_ADDRESS, user -> user.getLatestAddress().map(InetAddress::getHostAddress).orElse("0.0.0.0"))).setString(UserColumns.COMMAND_COOLDOWNS, user -> DataHandler.GSON.toJson(user.getCommandCooldowns()))).setString(UserColumns.PROPERTIES, user -> DataHandler.GSON.toJson(user.getPropertiesToSave()))).build();
    public static final SelectStatement<SunUser> SELECT_USER = SelectStatement.builder(USER_MAPPER).build();
    public static final SelectStatement<UserInfo> SELECT_PROFILE = SelectStatement.builder(PROFILE_MAPPER).column(new Column[]{UserColumns.NAME, UserColumns.UUID}).build();
    public static final SelectStatement<InetAddress> SELECT_INET = SelectStatement.builder(INET_MAPPER).column(new Column[]{UserColumns.INET_ADDRESS}).build();
}

