/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.user;

import java.net.InetAddress;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.db.AbstractDatabaseManager;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.user.AbstractUserManager;
import su.nightexpress.nightcore.user.UserInfo;
import su.nightexpress.nightcore.user.data.DefaultUserDataAccessor;
import su.nightexpress.nightcore.user.data.UserDataAccessor;
import su.nightexpress.nightcore.user.data.UserDataSchema;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.sunlight.SLUtils;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.data.DataHandler;
import su.nightexpress.sunlight.user.SunUser;
import su.nightexpress.sunlight.user.UserListener;
import su.nightexpress.sunlight.user.property.UserProperties;
import su.nightexpress.sunlight.user.property.UserPropertyRegistry;

public class UserManager
extends AbstractUserManager<SunLightPlugin, SunUser> {
    private final DataHandler dataHandler;

    public UserManager(@NotNull SunLightPlugin plugin, @NotNull DataHandler dataHandler) {
        super((NightPlugin)plugin, (UserDataAccessor)new DefaultUserDataAccessor((AbstractDatabaseManager)dataHandler, (UserDataSchema)dataHandler));
        this.dataHandler = dataHandler;
    }

    protected void onLoad() {
        super.onLoad();
        UserPropertyRegistry.register(UserProperties.CUSTOM_NAME);
        this.addListener((SimpeListener)new UserListener((SunLightPlugin)this.plugin, this));
    }

    protected void synchronize(@NotNull SunUser fetched, @NotNull SunUser cached) {
        cached.updateFrom(fetched);
    }

    @NotNull
    protected SunUser create(@NotNull UUID uuid, @NotNull String name, @NotNull InetAddress address) {
        return SunUser.create(uuid, name, address);
    }

    @NotNull
    public CompletableFuture<Player> loadTargetPlayer(@NotNull String playerName) {
        return this.loadTargetProfile(playerName).thenComposeAsync(this::loadTargetPlayer);
    }

    @NotNull
    public CompletableFuture<Player> loadTargetPlayer(@NotNull UserInfo profile) {
        return this.loadTargetPlayer(profile.id(), profile.name());
    }

    @NotNull
    public CompletableFuture<Player> loadTargetPlayer(@NotNull SunUser user) {
        return this.loadTargetPlayer(user.getId(), user.getName());
    }

    @NotNull
    public CompletableFuture<Player> loadTargetPlayer(@NotNull UUID id, @NotNull String name) {
        Player target = Players.getPlayer((UUID)id);
        if (target != null) {
            return CompletableFuture.completedFuture(target);
        }
        return CompletableFuture.supplyAsync(() -> ((SunLightPlugin)this.plugin).internals().map(nms -> nms.loadPlayerData(id, name)).orElse(null));
    }

    @NotNull
    public CompletableFuture<UserInfo> loadTargetProfile(@NotNull String playerName) {
        Player target = Players.getPlayer((String)playerName);
        if (target != null) {
            return CompletableFuture.completedFuture(UserInfo.of((Player)target));
        }
        return CompletableFuture.supplyAsync(() -> this.dataHandler.loadProfile(playerName).orElse(null));
    }

    @NotNull
    public CompletableFuture<InetAddress> loadInetAddress(@NotNull UUID playerId) {
        Player target = Players.getPlayer((UUID)playerId);
        if (target != null) {
            return CompletableFuture.completedFuture(SLUtils.getInetAddress(target).orElse(null));
        }
        return CompletableFuture.supplyAsync(() -> this.dataHandler.loadInetAddress(playerId).orElse(null));
    }
}

