/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.user;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.user.UserTemplate;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.sunlight.command.CommandKey;
import su.nightexpress.sunlight.module.vanish.VanishModule;
import su.nightexpress.sunlight.user.cache.UserCacheContainer;
import su.nightexpress.sunlight.user.property.UserProperties;
import su.nightexpress.sunlight.user.property.UserProperty;
import su.nightexpress.sunlight.user.property.UserPropertyRegistry;

public class SunUser
extends UserTemplate {
    private final Map<CommandKey, Long> commandCooldowns;
    private final Map<String, Object> properties;
    private final Map<Class<? extends UserCacheContainer>, UserCacheContainer> caches;
    private InetAddress latestAddress;
    private boolean newlyCreated;
    private long dateCreated;
    private long lastOnline;

    @NotNull
    public static SunUser create(@NotNull UUID uuid, @NotNull String name, @NotNull InetAddress address) {
        long dateCreated = System.currentTimeMillis();
        long lastOnline = System.currentTimeMillis();
        HashMap<CommandKey, Long> commandCooldowns = new HashMap<CommandKey, Long>();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        SunUser user = new SunUser(uuid, name, dateCreated, lastOnline, address, commandCooldowns, properties);
        user.newlyCreated = true;
        return user;
    }

    public SunUser(@NotNull UUID uuid, @NotNull String name, long dateCreated, long lastOnline, @Nullable InetAddress latestAddress, @NotNull Map<CommandKey, Long> commandCooldowns, @NotNull Map<String, Object> properties) {
        super(uuid, name, dateCreated, lastOnline);
        this.commandCooldowns = commandCooldowns;
        this.properties = properties;
        this.latestAddress = latestAddress;
        this.dateCreated = dateCreated;
        this.lastOnline = lastOnline;
        this.caches = new ConcurrentHashMap<Class<? extends UserCacheContainer>, UserCacheContainer>();
    }

    public void updateFrom(@NotNull SunUser other) {
        this.commandCooldowns.clear();
        this.properties.clear();
        this.commandCooldowns.putAll(other.commandCooldowns);
        this.properties.putAll(other.properties);
    }

    public long getDateCreated() {
        return this.dateCreated;
    }

    public long getLastOnline() {
        return this.lastOnline;
    }

    public void setLastOnline(long lastOnline) {
        this.lastOnline = lastOnline;
    }

    @NotNull
    public <T extends UserCacheContainer> Optional<T> getCache(@NotNull Class<T> type) {
        UserCacheContainer container = this.caches.get(type);
        if (container == null) {
            return Optional.empty();
        }
        UserCacheContainer cache = (UserCacheContainer)type.cast(container);
        cache.clearExpired();
        return Optional.of(cache);
    }

    @NotNull
    public <T extends UserCacheContainer> T getCacheOrCreate(@NotNull Class<T> type, @NotNull Supplier<T> supplier) {
        if (this.caches.containsKey(type)) {
            return (T)((UserCacheContainer)this.getCache(type).orElseThrow());
        }
        UserCacheContainer cache = (UserCacheContainer)supplier.get();
        this.caches.put(type, cache);
        return (T)cache;
    }

    @NotNull
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @NotNull
    public Map<String, Object> getPropertiesToSave() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (UserProperty<?> property : UserPropertyRegistry.values()) {
            Object value;
            if (!property.isPersistent() || (value = this.properties.get(property.getName())) == null) continue;
            map.put(property.getName(), value);
        }
        return map;
    }

    public <T> boolean hasProperty(@NotNull UserProperty<T> property) {
        return this.properties.containsKey(property.getName());
    }

    public <T> void setProperty(@NotNull UserProperty<T> property, @NotNull T value) {
        this.properties.put(property.getName(), value);
    }

    @NotNull
    public <T> T getProperty(@NotNull UserProperty<T> property) {
        return this.getProperty(property.getName(), property.getType(), property.getDefaultValue());
    }

    @NotNull
    public <T> T getProperty(@NotNull String name, @NotNull Class<T> type, @NotNull T defaultValue) {
        String key = LowerCase.INTERNAL.apply(name);
        Object value = this.properties.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (!type.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("User property '%s' is defined as %s, not %s".formatted(name, value.getClass().getSimpleName(), type.getSimpleName()));
        }
        return type.cast(value);
    }

    public boolean isVanished() {
        Player player = this.player().orElse(null);
        if (player != null && player.hasMetadata("vanished")) {
            return true;
        }
        return this.getProperty(VanishModule.VANISH);
    }

    public void setNewlyCreated(boolean newlyCreated) {
        this.newlyCreated = newlyCreated;
    }

    public boolean isNewlyCreated() {
        return this.newlyCreated;
    }

    public boolean hasPlayedBefore() {
        return !this.newlyCreated;
    }

    public boolean hasCustomName() {
        return !this.getCustomName().isEmpty();
    }

    @NotNull
    public String getCustomName() {
        return this.getProperty(UserProperties.CUSTOM_NAME);
    }

    public void setCustomName(@Nullable String name) {
        String customName = "";
        if (name != null && !name.isBlank()) {
            customName = name;
        }
        this.setProperty(UserProperties.CUSTOM_NAME, customName);
    }

    @NotNull
    public Optional<InetAddress> getLatestAddress() {
        return Optional.ofNullable(this.latestAddress);
    }

    public void setLatestAddress(@Nullable InetAddress address) {
        this.latestAddress = address;
    }

    @NotNull
    public Map<CommandKey, Long> getCommandCooldowns() {
        return this.commandCooldowns;
    }

    @Nullable
    public Long getCommandCooldown(@NotNull CommandKey key) {
        return this.commandCooldowns.get(key);
    }

    public void setCommandCooldown(@NotNull CommandKey key, long expireDate) {
        this.commandCooldowns.put(key, expireDate);
    }
}

