/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.teleport;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.SimpleManager;
import su.nightexpress.nightcore.util.LocationUtil;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.config.Lang;
import su.nightexpress.sunlight.module.ModuleRegistry;
import su.nightexpress.sunlight.module.warmups.WarmupsModule;
import su.nightexpress.sunlight.nms.SunNMS;
import su.nightexpress.sunlight.teleport.TeleportFlag;
import su.nightexpress.sunlight.teleport.TeleportFlags;
import su.nightexpress.sunlight.teleport.TeleportResult;
import su.nightexpress.sunlight.teleport.TeleportType;

public class TeleportManager
extends SimpleManager<SunLightPlugin> {
    private final ModuleRegistry moduleRegistry;

    public TeleportManager(@NotNull SunLightPlugin plugin, @NotNull ModuleRegistry moduleRegistry) {
        super((NightCorePlugin)plugin);
        this.moduleRegistry = moduleRegistry;
    }

    protected void onLoad() {
    }

    protected void onShutdown() {
    }

    public void teleport(@NotNull Player player, @NotNull Location location, @NotNull TeleportType type) {
        this.teleport(player, location, type, TeleportFlags.empty(), null);
    }

    public void teleport(@NotNull Player player, @NotNull Location location, @NotNull TeleportType type, @NotNull TeleportFlags flags) {
        this.teleport(player, location, type, flags, null);
    }

    public void teleport(@NotNull Player player, @NotNull Location location, @NotNull TeleportType type, @NotNull TeleportFlags flags, @Nullable Runnable callback) {
        WarmupsModule warmups;
        Location destination = this.validateLocation(player, location, flags);
        if (destination == null) {
            return;
        }
        if (!flags.contains(TeleportFlag.BYPASS_WARMUP) && (warmups = (WarmupsModule)this.moduleRegistry.byType(WarmupsModule.class).orElse(null)) != null && warmups.canHandleTeleport(player, type)) {
            warmups.handleTeleport(player, destination, type, () -> this.moveExact(player, destination, callback));
            return;
        }
        this.moveExact(player, destination, callback);
    }

    @NotNull
    public TeleportResult move(@NotNull Player player, @NotNull Location location) {
        return this.move(player, location, TeleportFlags.empty());
    }

    @NotNull
    public TeleportResult move(@NotNull Player player, @NotNull Location location, @NotNull TeleportFlags flags) {
        Location destination = this.validateLocation(player, location, flags);
        if (destination == null) {
            return TeleportResult.FAILURE;
        }
        return this.moveExact(player, destination, null);
    }

    @NotNull
    public TeleportResult moveExact(@NotNull Player player, @NotNull Location location, @Nullable Runnable callback) {
        if (player.isOnline()) {
            if (!player.teleport(location)) {
                return TeleportResult.CANCELLED_BY_EXTERNAL_SOURCE;
            }
        } else {
            SunNMS internals = ((SunLightPlugin)this.plugin).internals().orElse(null);
            if (internals == null) {
                return TeleportResult.NO_OFFLINE_HANDLER;
            }
            internals.teleport(player, location);
        }
        if (callback != null) {
            callback.run();
        }
        return TeleportResult.SUCCESS;
    }

    @Nullable
    private Location validateLocation(@NotNull Player player, @NotNull Location location, @NotNull TeleportFlags flags) {
        Location destination = this.getDesination(player, location, flags);
        if (destination == null) {
            Lang.TELEPORT_ERROR_HOLE_IN_FLOOR.message().send((CommandSender)player);
            return null;
        }
        return destination;
    }

    @Nullable
    private Location getDesination(@NotNull Player player, @NotNull Location destination, @NotNull TeleportFlags flags) {
        Block block;
        if (flags.isEmpty()) {
            return destination;
        }
        Location location = destination.clone();
        if (flags.contains(TeleportFlag.LOOK_FOR_SURFACE)) {
            Block under;
            block = location.getBlock();
            while (!TeleportManager.isSolid(under = block.getRelative(BlockFace.DOWN))) {
                if (under.getY() < 0) {
                    return null;
                }
                block = under;
            }
            double delta = location.getY() - (double)block.getY();
            if (delta > 0.0) {
                location.setY(location.getY() - delta);
            }
        }
        if (flags.contains(TeleportFlag.AVOID_LAVA) && location.getBlock().getType() == Material.LAVA) {
            return null;
        }
        if (flags.contains(TeleportFlag.PREVENT_CLIPPING)) {
            block = location.getBlock();
            Block above = block.getRelative(BlockFace.UP);
            if (!TeleportManager.isSolid(block) && !TeleportManager.isSolid(above)) {
                return null;
            }
            location = above.getLocation();
        }
        if (flags.contains(TeleportFlag.CENTERED)) {
            location = LocationUtil.setCenter2D((Location)location);
        }
        if (flags.contains(TeleportFlag.KEEP_DIRECTION)) {
            Location source = player.getLocation();
            location.setYaw(source.getYaw());
            location.setPitch(source.getPitch());
        }
        return location;
    }

    private static boolean isSolid(@NotNull Block block) {
        return !block.isEmpty() && block.getType().isSolid();
    }
}

