/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.teleport;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.sunlight.teleport.TeleportFlag;

public class TeleportFlags {
    private final EnumSet<TeleportFlag> flags;

    private TeleportFlags(@NotNull EnumSet<TeleportFlag> flags) {
        this.flags = flags;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public static TeleportFlags empty() {
        return new TeleportFlags(EnumSet.noneOf(TeleportFlag.class));
    }

    @NotNull
    public static TeleportFlags of(TeleportFlag ... flags) {
        return new TeleportFlags(EnumSet.copyOf(Arrays.asList(flags)));
    }

    public boolean isEmpty() {
        return this.flags.isEmpty();
    }

    public boolean contains(@NotNull TeleportFlag flag) {
        return this.flags.contains((Object)flag);
    }

    public static class Builder {
        private final Set<TeleportFlag> flags = new HashSet<TeleportFlag>();

        Builder() {
        }

        @NotNull
        public TeleportFlags build() {
            return TeleportFlags.of(this.flags.toArray(new TeleportFlag[0]));
        }

        @NotNull
        public Builder withFlag(@NotNull TeleportFlag flag) {
            this.flags.add(flag);
            return this;
        }

        @NotNull
        public Builder withFlagIf(@NotNull TeleportFlag flag, @NotNull Supplier<Boolean> predicate) {
            if (predicate.get().booleanValue()) {
                return this.withFlag(flag);
            }
            return this;
        }
    }
}

