/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.worlds.impl;

import java.io.File;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.manager.AbstractFileData;
import su.nightexpress.nightcore.util.FileUtil;
import su.nightexpress.nightcore.util.TimeUtil;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.worlds.WorldsModule;
import su.nightexpress.sunlight.module.worlds.config.WorldsConfig;
import su.nightexpress.sunlight.module.worlds.config.WorldsLang;
import su.nightexpress.sunlight.module.worlds.util.DeletionType;

public class WorldData
extends AbstractFileData<SunLightPlugin> {
    private final WorldsModule module;
    private boolean autoLoad;
    private String generator;
    private World.Environment environment;
    private boolean generateStructures;
    private boolean autoReset;
    private int resetInterval;
    private long lastResetDate;

    public WorldData(@NotNull SunLightPlugin plugin, @NotNull WorldsModule module, @NotNull File file) {
        super((NightCorePlugin)plugin, file);
        this.module = module;
    }

    protected boolean onLoad(@NotNull FileConfig config) {
        this.setAutoLoad(config.getBoolean("Auto_Load"));
        this.setGenerator(config.getString("Generator"));
        this.setEnvironment((World.Environment)config.getEnum("Environment", World.Environment.class));
        this.setGenerateStructures(config.getBoolean("GenerateStructures"));
        this.setAutoReset(config.getBoolean("Auto_Wipe.Enabled"));
        this.setResetInterval(config.getInt("Auto_Wipe.Interval"));
        this.setLastResetDate(config.getLong("Auto_Wipe.Last_Wipe"));
        return true;
    }

    protected void onSave(@NotNull FileConfig config) {
        config.set("Auto_Load", (Object)this.isAutoLoad());
        config.set("Generator", (Object)this.getGenerator());
        config.set("Environment", (Object)this.getEnvironment().name());
        config.set("GenerateStructures", (Object)this.isGenerateStructures());
        config.set("Auto_Wipe.Enabled", (Object)this.isAutoReset());
        config.set("Auto_Wipe.Interval", (Object)this.getResetInterval());
        config.set("Auto_Wipe.Last_Wipe", (Object)this.getLastResetDate());
    }

    @Nullable
    public World loadWorld() {
        if (this.isLoaded()) {
            return this.getWorld();
        }
        WorldCreator creator = new WorldCreator(this.getId());
        creator.environment(this.getEnvironment());
        creator.generator(this.module.getPluginGenerator(this.getId(), this.getGenerator()));
        return creator.createWorld();
    }

    public boolean hasWorldFiles() {
        return this.getDirectory() != null;
    }

    @Nullable
    public File getDirectory() {
        File dir = new File(String.valueOf(((SunLightPlugin)this.plugin).getServer().getWorldContainer()) + "/" + this.getId());
        return dir.exists() && dir.listFiles() != null ? dir : null;
    }

    private boolean deleteWorldFiles() {
        File dir = this.getDirectory();
        if (dir == null) {
            return false;
        }
        return FileUtil.deleteRecursive((File)dir);
    }

    private boolean deleteRegionFiles() {
        File dir = this.getDirectory();
        if (dir == null) {
            return false;
        }
        for (File folder : FileUtil.getFolders((String)dir.getAbsolutePath())) {
            if (folder.getName().equalsIgnoreCase("datapacks")) continue;
            FileUtil.deleteRecursive((File)folder);
        }
        for (File file : FileUtil.getFiles((String)dir.getAbsolutePath(), (boolean)false)) {
            if (file.getName().equalsIgnoreCase("level.dat") || file.getName().equalsIgnoreCase("paper-world.yml")) continue;
            file.delete();
        }
        return true;
    }

    public boolean delete(@NotNull DeletionType type) {
        if (this.isLoaded() && !this.module.unloadWorld(this, true)) {
            return false;
        }
        if (type == DeletionType.DATA || type == DeletionType.FULL) {
            if (!this.getFile().delete()) {
                return false;
            }
            this.module.getDataMap().remove(this.getId());
        }
        if (type == DeletionType.REGION) {
            this.deleteRegionFiles();
        } else if (type == DeletionType.DIRECTORY || type == DeletionType.FULL) {
            this.deleteWorldFiles();
        }
        return true;
    }

    public boolean autoReset() {
        if (!this.isAutoReset()) {
            return false;
        }
        if (!this.isResetTime()) {
            return false;
        }
        this.module.info("Start Auto-Reset for world '" + this.getId() + "'...");
        if (!this.module.unloadWorld(this, true)) {
            this.module.warn("Auto-Reset for world '" + this.getId() + "' failed: Unable to unload the world.");
            return false;
        }
        this.deleteRegionFiles();
        this.loadWorld();
        this.setLatestWipeDate();
        this.module.info("Auto-Reset for world '" + this.getId() + "' completed.");
        this.save();
        return true;
    }

    public boolean autoResetNotify() {
        long threshold;
        if (!this.isAutoReset()) {
            return false;
        }
        if (this.isResetTime()) {
            return false;
        }
        long wipeDate = this.getNextWipe();
        if (wipeDate <= 0L) {
            return false;
        }
        long current = TimeUtil.toEpochMillis((LocalDateTime)TimeUtil.getCurrentDateTime().truncatedTo(ChronoUnit.SECONDS));
        long diff = wipeDate - current;
        if (diff > (threshold = (Long)WorldsConfig.AUTO_RESET_NOTIFICATION_THRESHOLD.get() * 1000L)) {
            return false;
        }
        if (TimeUnit.MILLISECONDS.toSeconds(diff) % (Long)WorldsConfig.AUTO_RESET_NOTIFICATION_INTERVAL.get() == 0L) {
            World world = this.getWorld();
            if (world == null) {
                return false;
            }
            world.getPlayers().forEach(player -> WorldsLang.AUTO_RESET_NOTIFY.message().send((CommandSender)player, replacer -> replacer.replace("%time%", (Object)TimeUtil.formatDuration((long)(this.getNextWipe() + 1000L)))));
            return true;
        }
        return false;
    }

    @Nullable
    public World getWorld() {
        return ((SunLightPlugin)this.plugin).getServer().getWorld(this.getId());
    }

    public boolean isLoaded() {
        return this.getWorld() != null;
    }

    public long getNextWipe() {
        if (!this.isAutoReset()) {
            return -1L;
        }
        if (this.getLastResetDate() <= 0L || (long)this.getResetInterval() <= 0L) {
            return -1L;
        }
        return this.getLastResetDate() + (long)this.getResetInterval() * 1000L;
    }

    public boolean isResetTime() {
        if (!this.isAutoReset()) {
            return false;
        }
        long next = this.getNextWipe();
        if (next <= 0L) {
            return false;
        }
        long now = TimeUtil.toEpochMillis((LocalDateTime)TimeUtil.getCurrentDateTime().truncatedTo(ChronoUnit.SECONDS));
        return now >= next;
    }

    public boolean isAutoLoad() {
        return this.autoLoad;
    }

    public void setAutoLoad(boolean autoLoad) {
        this.autoLoad = autoLoad;
    }

    @Nullable
    public String getGenerator() {
        return this.generator;
    }

    public void setGenerator(@Nullable String generator) {
        this.generator = generator;
    }

    @NotNull
    public World.Environment getEnvironment() {
        return this.environment == null ? World.Environment.NORMAL : this.environment;
    }

    public void setEnvironment(@Nullable World.Environment environment) {
        this.environment = environment == null ? World.Environment.NORMAL : environment;
    }

    public boolean isGenerateStructures() {
        return this.generateStructures;
    }

    public void setGenerateStructures(boolean generateStructures) {
        this.generateStructures = generateStructures;
    }

    public boolean isAutoReset() {
        return this.autoReset;
    }

    public void setAutoReset(boolean autoReset) {
        this.autoReset = autoReset;
    }

    public int getResetInterval() {
        return this.resetInterval;
    }

    public void setResetInterval(int resetInterval) {
        this.resetInterval = resetInterval;
    }

    public long getLastResetDate() {
        return this.lastResetDate;
    }

    public void setLatestWipeDate() {
        LocalDateTime now = TimeUtil.getCurrentDateTime().truncatedTo(ChronoUnit.SECONDS);
        this.setLastResetDate(TimeUtil.toEpochMillis((LocalDateTime)now));
    }

    public void setLastResetDate(long lastResetDate) {
        this.lastResetDate = lastResetDate;
    }
}

