/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.worlds.editor;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.bukkit.GameRule;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.menu.MenuOptions;
import su.nightexpress.nightcore.menu.MenuSize;
import su.nightexpress.nightcore.menu.MenuViewer;
import su.nightexpress.nightcore.menu.api.AutoFill;
import su.nightexpress.nightcore.menu.api.AutoFilled;
import su.nightexpress.nightcore.menu.impl.EditorMenu;
import su.nightexpress.nightcore.util.ItemReplacer;
import su.nightexpress.nightcore.util.StringUtil;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.config.Lang;
import su.nightexpress.sunlight.module.worlds.WorldsModule;
import su.nightexpress.sunlight.module.worlds.config.WorldsLang;
import su.nightexpress.sunlight.module.worlds.impl.WrappedWorld;

public class WorldRulesEditor
extends EditorMenu<SunLightPlugin, WrappedWorld>
implements AutoFilled<GameRule<?>> {
    public WorldRulesEditor(@NotNull SunLightPlugin plugin, @NotNull WorldsModule module) {
        super((NightCorePlugin)plugin, WorldsLang.EDITOR_TITLE_GAME_RULES.text(), MenuSize.CHEST_45);
        this.addNextPage(new int[]{44});
        this.addPreviousPage(new int[]{36});
        this.addReturn(40, (viewer, event, wrappedWorld) -> this.runNextTick(() -> module.openWorldSettings(viewer.getPlayer(), (WrappedWorld)wrappedWorld)));
    }

    public void onPrepare(@NotNull MenuViewer viewer, @NotNull MenuOptions options) {
        this.autoFill(viewer);
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }

    public void onAutoFill(@NotNull MenuViewer viewer, @NotNull AutoFill<GameRule<?>> autoFill) {
        World world = ((WrappedWorld)this.getLink(viewer)).getWorld();
        autoFill.setSlots(IntStream.range(0, 36).toArray());
        autoFill.setItems((List)Stream.of(world.getGameRules()).map(GameRule::getByName).filter(Objects::nonNull).sorted(Comparator.comparing(GameRule::getName)).collect(Collectors.toCollection(ArrayList::new)));
        autoFill.setItemCreator(gameRule -> {
            Material material = Material.MAP;
            if (gameRule.getType() == Boolean.class) {
                material = world.getGameRuleValue(gameRule) == Boolean.TRUE ? Material.LIME_DYE : Material.GRAY_DYE;
            }
            ItemStack item = new ItemStack(material);
            ItemReplacer.create((ItemStack)item).hideFlags().trimmed().readLocale(WorldsLang.EDITOR_WORLD_RULE_OBJECT).replace("%name%", this.getRuleName(gameRule.getName())).replace("%value%", String.valueOf(world.getGameRuleValue(gameRule))).writeMeta();
            return item;
        });
        autoFill.setClickAction(gameRule -> (viewer1, event) -> {
            if (gameRule.getType() == Boolean.class) {
                GameRule rule;
                Boolean value = (Boolean)world.getGameRuleValue(rule = gameRule);
                world.setGameRule(rule, (Object)(value != null && value == false ? 1 : 0));
                this.runNextTick(() -> this.open(viewer.getPlayer(), viewer.getPage()));
            } else if (gameRule.getType() == Integer.class) {
                GameRule rule = gameRule;
                this.handleInput(viewer.getPlayer(), Lang.EDITOR_INPUT_GENERIC_VALUE.text(), (dialog, input) -> {
                    world.setGameRule(rule, (Object)input.asInt());
                    return true;
                });
            }
        });
    }

    @NotNull
    private String getRuleName(@NotNull String name) {
        StringBuilder builder = new StringBuilder();
        for (char letter : name.toCharArray()) {
            if (Character.isUpperCase(letter) && !builder.isEmpty()) {
                builder.append(" ");
            }
            builder.append(letter);
        }
        return StringUtil.capitalizeFully((String)builder.toString());
    }
}

