/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.warps.util;

import java.time.LocalTime;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.core.CoreLang;
import su.nightexpress.nightcore.language.LangAssets;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.TimeUtil;
import su.nightexpress.nightcore.util.placeholder.PlaceholderMap;
import su.nightexpress.sunlight.SLPlaceholders;
import su.nightexpress.sunlight.SLUtils;
import su.nightexpress.sunlight.module.warps.config.WarpsLang;
import su.nightexpress.sunlight.module.warps.impl.Warp;

public class Placeholders
extends SLPlaceholders {
    public static final String WARP_ID = "%warp_id%";
    public static final String WARP_NAME = "%warp_name%";
    public static final String WARP_DESCRIPTION = "%warp_description%";
    public static final String WARP_TYPE = "%warp_type%";
    public static final String WARP_PERMISSION_REQUIRED = "%warp_permission_required%";
    public static final String WARP_PERMISSION_NODE = "%warp_permission_node%";
    public static final String WARP_VISIT_COST = "%warp_visit_cost%";
    public static final String WARP_VISIT_COOLDOWN = "%warp_visit_cooldown%";
    public static final String WARP_VISIT_TIMES = "%warp_visit_times%";
    public static final String WARP_LOCATION_WORLD = "%warp_location_world%";
    public static final String WARP_LOCATION_X = "%warp_location_x%";
    public static final String WARP_LOCATION_Y = "%warp_location_y%";
    public static final String WARP_LOCATION_Z = "%warp_location_z%";
    public static final String WARP_OWNER_NAME = "%warp_owner_name%";
    public static final String WARP_COMMAND_SHORTCUT = "%warp_command_shortcut%";

    @NotNull
    public static PlaceholderMap forWarp(@NotNull Warp warp) {
        return new PlaceholderMap().add(WARP_ID, warp.getId()).add(WARP_NAME, warp::getName).add(WARP_DESCRIPTION, () -> String.join((CharSequence)TAG_LINE_BREAK, warp.getDescriptionFormatted())).add(WARP_VISIT_COST, () -> warp.hasVisitCost() ? NumberUtil.format((double)warp.getVisitCostMoney()) : CoreLang.OTHER_DISABLED.getString()).add(WARP_VISIT_COOLDOWN, () -> warp.hasVisitCooldown() ? TimeUtil.formatTime((long)((long)warp.getVisitCooldown() * 1000L)) : CoreLang.OTHER_DISABLED.getString()).add(WARP_VISIT_TIMES, () -> String.join((CharSequence)"\n", warp.getVisitTimes().stream().map(pair -> SLUtils.formatTime((LocalTime)pair.getFirst()) + " - " + SLUtils.formatTime((LocalTime)pair.getSecond())).toList())).add(WARP_LOCATION_X, () -> NumberUtil.format((double)warp.getBlockPos().getX())).add(WARP_LOCATION_Y, () -> NumberUtil.format((double)warp.getBlockPos().getY())).add(WARP_LOCATION_Z, () -> NumberUtil.format((double)warp.getBlockPos().getZ())).add(WARP_LOCATION_WORLD, () -> warp.isValid() ? LangAssets.get((World)warp.getWorld()) : warp.getWorldName()).add(WARP_OWNER_NAME, () -> warp.getOwner().name()).add(WARP_TYPE, () -> WarpsLang.WARP_TYPE.getLocalized((Enum)warp.getType())).add(WARP_PERMISSION_REQUIRED, () -> CoreLang.getYesOrNo((boolean)warp.isPermissionRequired())).add(WARP_PERMISSION_NODE, warp.getPermission()).add(WARP_COMMAND_SHORTCUT, () -> warp.getCommandShortcut() == null ? "-" : warp.getCommandShortcut());
    }
}

