/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.warps.menu;

import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.core.CoreLang;
import su.nightexpress.nightcore.dialog.Dialog;
import su.nightexpress.nightcore.dialog.DialogHandler;
import su.nightexpress.nightcore.language.entry.LangString;
import su.nightexpress.nightcore.menu.MenuOptions;
import su.nightexpress.nightcore.menu.MenuSize;
import su.nightexpress.nightcore.menu.MenuViewer;
import su.nightexpress.nightcore.menu.api.Menu;
import su.nightexpress.nightcore.menu.click.ClickResult;
import su.nightexpress.nightcore.menu.impl.ConfigMenu;
import su.nightexpress.nightcore.menu.item.ItemHandler;
import su.nightexpress.nightcore.menu.item.MenuItem;
import su.nightexpress.nightcore.menu.link.Linked;
import su.nightexpress.nightcore.menu.link.ViewLink;
import su.nightexpress.nightcore.util.ItemReplacer;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.Pair;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.text.tag.Tags;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.warps.WarpsModule;
import su.nightexpress.sunlight.module.warps.config.WarpsConfig;
import su.nightexpress.sunlight.module.warps.config.WarpsLang;
import su.nightexpress.sunlight.module.warps.config.WarpsPerms;
import su.nightexpress.sunlight.module.warps.impl.Warp;
import su.nightexpress.sunlight.module.warps.type.WarpType;

public class WarpSettingsMenu
extends ConfigMenu<SunLightPlugin>
implements Linked<Warp> {
    public static final String FILE = "warp_settings.yml";
    private final ViewLink<Warp> link = new ViewLink();
    private final ItemHandler returnHandler = ItemHandler.forReturn((Menu)this, (viewer, event) -> this.runNextTick(() -> module.openServerWarps(viewer.getPlayer())));
    private final ItemHandler typeHandler;
    private final ItemHandler commandHandler;
    private final ItemHandler descriptionHandler;
    private final ItemHandler iconHandler;
    private final ItemHandler nameHandler;
    private final ItemHandler permissionHandler;
    private final ItemHandler visitCostHandler;
    private final ItemHandler visitCooldownHandler;
    private final ItemHandler visitTimesHandler;

    public WarpSettingsMenu(@NotNull SunLightPlugin plugin, @NotNull WarpsModule module) {
        super((NightCorePlugin)plugin, FileConfig.load((String)module.getLocalUIPath(), (String)FILE));
        this.addHandler(this.returnHandler);
        this.typeHandler = new ItemHandler("warp_change_type", (viewer, event) -> {
            Warp warp = (Warp)((Object)((Object)this.getLink(viewer)));
            warp.setType((WarpType)Lists.next((Enum)warp.getType()));
            this.save(viewer);
        });
        this.addHandler(this.typeHandler);
        this.commandHandler = new ItemHandler("warp_change_command_shortcut", (viewer, event) -> {
            Warp warp = (Warp)((Object)((Object)this.getLink(viewer)));
            this.handleInput(viewer.getPlayer(), WarpsLang.EDITOR_ENTER_COMMAND.text(), (dialog, input) -> {
                warp.setCommandShortcut(input.getTextRaw());
                warp.save();
                return true;
            });
        });
        this.addHandler(this.commandHandler);
        this.descriptionHandler = new ItemHandler("warp_change_description", (viewer, event) -> {
            Warp warp = (Warp)((Object)((Object)this.getLink(viewer)));
            this.handleInput(viewer.getPlayer(), WarpsLang.EDITOR_ENTER_DESCRIPTION.text(), (dialog, input) -> {
                String desc = input.getText();
                if (!viewer.getPlayer().hasPermission(WarpsPerms.BYPASS_DESCRIPTION_SIZE)) {
                    int maxSize = (Integer)WarpsConfig.WARP_DESCRIPTION_MAX_SIZE.get();
                    if (desc.length() > maxSize) {
                        desc = desc.substring(0, maxSize);
                    }
                }
                warp.setDescription(desc);
                warp.save();
                return true;
            });
        });
        this.addHandler(this.descriptionHandler);
        this.iconHandler = new ItemHandler("warp_change_icon", (viewer, event) -> {
            Warp warp = (Warp)((Object)((Object)this.getLink(viewer)));
            ItemStack icon = event.getCursor();
            if (icon == null || icon.getType().isAir()) {
                return;
            }
            warp.setIcon(icon);
            Players.addItem((Player)viewer.getPlayer(), (ItemStack[])new ItemStack[]{icon});
            event.getWhoClicked().setItemOnCursor(null);
            this.save(viewer);
        });
        this.addHandler(this.iconHandler);
        this.nameHandler = new ItemHandler("warp_change_name", (viewer, event) -> {
            Warp warp = (Warp)((Object)((Object)this.getLink(viewer)));
            this.handleInput(viewer.getPlayer(), WarpsLang.EDITOR_ENTER_NAME.text(), (dialog, input) -> {
                warp.setName(input.getText());
                warp.save();
                return true;
            });
        });
        this.addHandler(this.nameHandler);
        this.permissionHandler = new ItemHandler("warp_change_permission", (viewer, event) -> {
            Warp warp;
            warp.setPermissionRequired(!(warp = (Warp)((Object)((Object)this.getLink(viewer)))).isPermissionRequired());
            this.save(viewer);
        });
        this.addHandler(this.permissionHandler);
        this.visitCostHandler = new ItemHandler("warp_change_visit_cost", (viewer, event) -> {
            Warp warp = (Warp)((Object)((Object)this.getLink(viewer)));
            if (event.isRightClick()) {
                warp.setVisitCostMoney(0.0);
                this.save(viewer);
                return;
            }
            this.handleInput(viewer.getPlayer(), WarpsLang.EDITOR_ENTER_COST.text(), (dialog, input) -> {
                warp.setVisitCostMoney(input.asDouble());
                warp.save();
                return true;
            });
        });
        this.addHandler(this.visitCostHandler);
        this.visitCooldownHandler = new ItemHandler("warp_change_visit_cooldown", (viewer, event) -> {
            Warp warp = (Warp)((Object)((Object)this.getLink(viewer)));
            if (event.isRightClick()) {
                warp.setVisitCooldown(0);
                this.save(viewer);
                return;
            }
            this.handleInput(viewer.getPlayer(), WarpsLang.EDITOR_ENTER_COOLDOWN.text(), (dialog, input) -> {
                warp.setVisitCooldown(input.asInt());
                warp.save();
                return true;
            });
        });
        this.addHandler(this.visitCooldownHandler);
        this.visitTimesHandler = new ItemHandler("warp_change_visit_times", (viewer, event) -> {
            Warp warp = (Warp)((Object)((Object)this.getLink(viewer)));
            if (event.isRightClick()) {
                warp.getVisitTimes().clear();
                this.save(viewer);
                return;
            }
            this.handleInput(viewer.getPlayer(), WarpsLang.EDITOR_ENTER_TIMES.text(), (dialog, wrapper) -> {
                String[] split = wrapper.getTextRaw().split(" ");
                if (split.length < 2) {
                    return true;
                }
                try {
                    LocalTime from = LocalTime.parse(split[0], Warp.TIME_FORMATTER);
                    LocalTime to = LocalTime.parse(split[1], Warp.TIME_FORMATTER);
                    warp.getVisitTimes().add((Pair<LocalTime, LocalTime>)Pair.of((Object)from, (Object)to));
                    warp.save();
                }
                catch (DateTimeParseException dateTimeParseException) {
                    // empty catch block
                }
                return true;
            });
        });
        this.addHandler(this.visitTimesHandler);
        this.load();
        this.getItems().forEach(menuItem -> {
            Predicate<MenuViewer> policy = null;
            ItemHandler handler = menuItem.getHandler();
            if (handler == this.visitTimesHandler) {
                policy = player -> player.getPlayer().hasPermission(WarpsPerms.EDITOR_VISIT_TIMES);
            } else if (handler == this.visitCostHandler) {
                policy = player -> player.getPlayer().hasPermission(WarpsPerms.EDITOR_VISIT_COST);
            } else if (handler == this.visitCooldownHandler) {
                policy = player -> player.getPlayer().hasPermission(WarpsPerms.EDITOR_VISIT_COOLDOWN);
            } else if (handler == this.permissionHandler) {
                policy = player -> player.getPlayer().hasPermission(WarpsPerms.EDITOR_PERMISSION);
            } else if (handler == this.typeHandler) {
                policy = player -> player.getPlayer().hasPermission(WarpsPerms.EDITOR_TYPE);
            } else if (handler == this.commandHandler) {
                policy = player -> player.getPlayer().hasPermission(WarpsPerms.EDITOR_COMMAND_SHORTCUT);
            }
            if (policy != null) {
                menuItem.getOptions().setVisibilityPolicy(policy);
            }
            if (handler == this.iconHandler) {
                menuItem.getOptions().addDisplayModifier((viewer, item) -> {
                    Warp warp = (Warp)((Object)((Object)((Object)this.getLink((MenuViewer)viewer))));
                    String nameHas = ItemUtil.getItemName((ItemStack)item);
                    List loreHas = ItemUtil.getLore((ItemStack)item);
                    item.setType(warp.getIcon().getType());
                    item.setItemMeta(warp.getIcon().getItemMeta());
                    ItemUtil.editMeta((ItemStack)item, meta -> {
                        meta.setDisplayName(nameHas);
                        meta.setLore(loreHas);
                    });
                });
            }
            menuItem.getOptions().addDisplayModifier((viewer, item) -> ItemReplacer.replace((ItemStack)item, (UnaryOperator)((Warp)((Object)((Object)((Object)this.getLink((MenuViewer)viewer))))).replacePlaceholders()));
        });
    }

    @NotNull
    public ViewLink<Warp> getLink() {
        return this.link;
    }

    private void save(@NotNull MenuViewer viewer) {
        ((Warp)((Object)this.getLink(viewer))).save();
        this.runNextTick(() -> this.flush(viewer));
    }

    protected void handleInput(@NotNull MenuViewer viewer, @NotNull LangString prompt, @NotNull DialogHandler handler) {
        this.handleInput(viewer.getPlayer(), prompt.getString(), handler);
    }

    protected void handleInput(@NotNull Player player, @NotNull String prompt, @NotNull DialogHandler handler) {
        Dialog dialog = Dialog.create((Player)player, (DialogHandler)handler);
        dialog.prompt(prompt);
        this.runNextTick(() -> ((Player)player).closeInventory());
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull MenuOptions options) {
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }

    public void onClick(@NotNull MenuViewer viewer, @NotNull ClickResult result, @NotNull InventoryClickEvent event) {
        super.onClick(viewer, result, event);
        if (result.isInventory() && !event.isShiftClick()) {
            event.setCancelled(false);
        }
    }

    @NotNull
    protected MenuOptions createDefaultOptions() {
        return new MenuOptions(Tags.BLACK.enclose("Warp Settings"), MenuSize.CHEST_27);
    }

    @NotNull
    protected List<MenuItem> createDefaultItems() {
        ArrayList<MenuItem> list = new ArrayList<MenuItem>();
        ItemStack back = ItemUtil.getSkinHead((String)"be9ae7a4be65fcbaee65181389a2f7d47e2e326db59ea3eb789a92c85ea46");
        ItemUtil.editMeta((ItemStack)back, meta -> meta.setDisplayName(CoreLang.EDITOR_ITEM_RETURN.getDefaultName()));
        list.add(new MenuItem(back).setPriority(10).setSlots(new int[]{22}).setHandler(this.returnHandler));
        ItemStack nameItem = ItemUtil.getSkinHead((String)"f5a19af0e61ca42532c0599fa0a391753df6b71f9fa4a177f1aa9b1d81fe6ee2");
        ItemUtil.editMeta((ItemStack)nameItem, meta -> {
            meta.setDisplayName(Tags.LIGHT_YELLOW.enclose(Tags.BOLD.enclose("Display Name")));
            meta.setLore(Lists.newList((Object[])new String[]{Tags.LIGHT_YELLOW.enclose("\u25aa " + Tags.LIGHT_GRAY.enclose("Current: ") + "%warp_name%"), " ", Tags.LIGHT_GRAY.enclose(Tags.LIGHT_YELLOW.enclose("[\u25b6]") + " Click to " + Tags.LIGHT_YELLOW.enclose("change") + ".")}));
        });
        list.add(new MenuItem(nameItem).setPriority(10).setSlots(new int[]{3}).setHandler(this.nameHandler));
        ItemStack descriptionItem = new ItemStack(Material.WRITABLE_BOOK);
        ItemUtil.editMeta((ItemStack)descriptionItem, meta -> {
            meta.setDisplayName(Tags.LIGHT_YELLOW.enclose(Tags.BOLD.enclose("Descrpition")));
            meta.setLore(Lists.newList((Object[])new String[]{"%warp_description%", "", Tags.LIGHT_GRAY.enclose(Tags.LIGHT_YELLOW.enclose("[\u25b6]") + " Click to " + Tags.LIGHT_YELLOW.enclose("change") + ".")}));
        });
        list.add(new MenuItem(descriptionItem).setPriority(10).setSlots(new int[]{4}).setHandler(this.descriptionHandler));
        ItemStack iconItem = new ItemStack(Material.ITEM_FRAME);
        ItemUtil.editMeta((ItemStack)iconItem, meta -> {
            meta.setDisplayName(Tags.LIGHT_YELLOW.enclose(Tags.BOLD.enclose("Icon")));
            meta.setLore(Lists.newList((Object[])new String[]{Tags.LIGHT_GRAY.enclose(Tags.LIGHT_YELLOW.enclose("[\u25b6]") + " Drag & Drop to " + Tags.LIGHT_YELLOW.enclose("change") + ".")}));
        });
        list.add(new MenuItem(iconItem).setPriority(10).setSlots(new int[]{5}).setHandler(this.iconHandler));
        ItemStack permissionItem = new ItemStack(Material.REDSTONE_TORCH);
        ItemUtil.editMeta((ItemStack)permissionItem, meta -> {
            meta.setDisplayName(Tags.LIGHT_YELLOW.enclose(Tags.BOLD.enclose("Permission Requirement")));
            meta.setLore(Lists.newList((Object[])new String[]{Tags.LIGHT_YELLOW.enclose("\u25aa " + Tags.LIGHT_GRAY.enclose("Enabled: ") + "%warp_permission_required%"), Tags.LIGHT_YELLOW.enclose("\u25aa " + Tags.LIGHT_GRAY.enclose("Node: ") + "%warp_permission_node%"), "", Tags.LIGHT_GRAY.enclose("Sets whether or not permission is"), Tags.LIGHT_GRAY.enclose("required to visit this warp."), "", Tags.LIGHT_GRAY.enclose(Tags.LIGHT_YELLOW.enclose("[\u25b6]") + " Click to " + Tags.LIGHT_YELLOW.enclose("toggle") + ".")}));
        });
        list.add(new MenuItem(permissionItem).setPriority(10).setSlots(new int[]{11}).setHandler(this.permissionHandler));
        ItemStack visitCostItem = new ItemStack(Material.GOLD_NUGGET);
        ItemUtil.editMeta((ItemStack)visitCostItem, meta -> {
            meta.setDisplayName(Tags.LIGHT_YELLOW.enclose(Tags.BOLD.enclose("Visit Cost")));
            meta.setLore(Lists.newList((Object[])new String[]{Tags.LIGHT_YELLOW.enclose("\u25aa " + Tags.LIGHT_GRAY.enclose("Current:") + " %warp_visit_cost%"), "", Tags.LIGHT_GRAY.enclose("Sets how much money player will have to pay"), Tags.LIGHT_GRAY.enclose("in order to use this warp."), "", Tags.LIGHT_GRAY.enclose(Tags.LIGHT_YELLOW.enclose("[\u25b6]") + " Left-Click to " + Tags.LIGHT_YELLOW.enclose("change") + "."), Tags.LIGHT_GRAY.enclose(Tags.LIGHT_YELLOW.enclose("[\u25b6]") + " Right-Click to " + Tags.LIGHT_YELLOW.enclose("disable") + ".")}));
        });
        list.add(new MenuItem(visitCostItem).setPriority(10).setSlots(new int[]{12}).setHandler(this.visitCostHandler));
        ItemStack visitCooldownItem = new ItemStack(Material.CLOCK);
        ItemUtil.editMeta((ItemStack)visitCooldownItem, meta -> {
            meta.setDisplayName(Tags.LIGHT_YELLOW.enclose(Tags.BOLD.enclose("Visit Cooldown")));
            meta.setLore(Lists.newList((Object[])new String[]{Tags.LIGHT_YELLOW.enclose("\u25aa " + Tags.LIGHT_GRAY.enclose("Current: ") + "%warp_visit_cooldown%"), "", Tags.LIGHT_GRAY.enclose("Sets the cooldown for next warp visit per a player."), "", Tags.LIGHT_GRAY.enclose(Tags.LIGHT_YELLOW.enclose("[\u25b6]") + " Left-Click to " + Tags.LIGHT_YELLOW.enclose("change") + "."), Tags.LIGHT_GRAY.enclose(Tags.LIGHT_YELLOW.enclose("[\u25b6]") + " Right-Click to " + Tags.LIGHT_YELLOW.enclose("disable") + ".")}));
        });
        list.add(new MenuItem(visitCooldownItem).setPriority(10).setSlots(new int[]{13}).setHandler(this.visitCooldownHandler));
        ItemStack visitTimesItem = new ItemStack(Material.DAYLIGHT_DETECTOR);
        ItemUtil.editMeta((ItemStack)visitTimesItem, meta -> {
            meta.setDisplayName(Tags.LIGHT_YELLOW.enclose(Tags.BOLD.enclose("Visit Times")));
            meta.setLore(Lists.newList((Object[])new String[]{"%warp_visit_times%", "", Tags.LIGHT_GRAY.enclose("Sets the times when the warp is available for visits."), "", Tags.LIGHT_GRAY.enclose(Tags.LIGHT_YELLOW.enclose("[\u25b6]") + " Left-Click to " + Tags.LIGHT_YELLOW.enclose("add time") + "."), Tags.LIGHT_GRAY.enclose(Tags.LIGHT_YELLOW.enclose("[\u25b6]") + " Right-Click to " + Tags.LIGHT_YELLOW.enclose("remove all") + ".")}));
        });
        list.add(new MenuItem(visitTimesItem).setPriority(10).setSlots(new int[]{14}).setHandler(this.visitTimesHandler));
        ItemStack warpType = new ItemStack(Material.BEACON);
        ItemUtil.editMeta((ItemStack)warpType, meta -> {
            meta.setDisplayName(Tags.LIGHT_YELLOW.enclose(Tags.BOLD.enclose("Type")));
            meta.setLore(Lists.newList((Object[])new String[]{Tags.LIGHT_YELLOW.enclose("\u25aa " + Tags.LIGHT_GRAY.enclose("Current: ") + "%warp_type%"), " ", Tags.LIGHT_GRAY.enclose(Tags.LIGHT_YELLOW.enclose("[\u25b6]") + " Click to " + Tags.LIGHT_YELLOW.enclose("toggle") + ".")}));
        });
        list.add(new MenuItem(warpType).setPriority(10).setSlots(new int[]{15}).setHandler(this.typeHandler));
        ItemStack warpCommand = new ItemStack(Material.COMMAND_BLOCK);
        ItemUtil.editMeta((ItemStack)warpCommand, meta -> {
            meta.setDisplayName(Tags.LIGHT_YELLOW.enclose(Tags.BOLD.enclose("Dedicated Command")));
            meta.setLore(Lists.newList((Object[])new String[]{Tags.LIGHT_YELLOW.enclose("\u25aa " + Tags.LIGHT_GRAY.enclose("Current:") + " /%warp_command_shortcut%"), "", Tags.LIGHT_GRAY.enclose("Allows to access the warp"), Tags.LIGHT_GRAY.enclose("using dedicated command."), "", Tags.LIGHT_GRAY.enclose(Tags.LIGHT_YELLOW.enclose("[\u25b6]") + " Left-Click to " + Tags.LIGHT_YELLOW.enclose("change") + "."), Tags.LIGHT_GRAY.enclose(Tags.LIGHT_YELLOW.enclose("[\u25b6]") + " Right-Click to " + Tags.LIGHT_YELLOW.enclose("disable") + ".")}));
        });
        list.add(new MenuItem(warpCommand).setPriority(10).setSlots(new int[]{16}).setHandler(this.commandHandler));
        return list;
    }

    protected void loadAdditional() {
    }
}

