/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.warps.menu;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.core.CoreLang;
import su.nightexpress.nightcore.menu.MenuOptions;
import su.nightexpress.nightcore.menu.MenuSize;
import su.nightexpress.nightcore.menu.MenuViewer;
import su.nightexpress.nightcore.menu.api.AutoFill;
import su.nightexpress.nightcore.menu.api.AutoFilled;
import su.nightexpress.nightcore.menu.api.Menu;
import su.nightexpress.nightcore.menu.impl.ConfigMenu;
import su.nightexpress.nightcore.menu.item.ItemHandler;
import su.nightexpress.nightcore.menu.item.MenuItem;
import su.nightexpress.nightcore.menu.link.Linked;
import su.nightexpress.nightcore.menu.link.ViewLink;
import su.nightexpress.nightcore.util.ItemReplacer;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.placeholder.PlaceholderMap;
import su.nightexpress.nightcore.util.text.tag.Tags;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.warps.WarpsModule;
import su.nightexpress.sunlight.module.warps.config.WarpsLang;
import su.nightexpress.sunlight.module.warps.impl.Warp;
import su.nightexpress.sunlight.module.warps.menu.DisplayInfo;
import su.nightexpress.sunlight.module.warps.type.SortType;
import su.nightexpress.sunlight.module.warps.type.WarpType;
import su.nightexpress.sunlight.user.SunUser;

public class WarpListMenu
extends ConfigMenu<SunLightPlugin>
implements AutoFilled<Warp>,
Linked<DisplayInfo> {
    public static final String FILE = "warp_list.yml";
    private static final String TIMES = "%times%";
    private static final String NO_PERMISSION = "%no_permission%";
    private static final String NO_MONEY = "%no_money%";
    private static final String COOLDOWN = "%cooldown%";
    private static final String VISIT_COST = "%visit_cost%";
    private static final String VISIT_COOLDOWN = "%visit_cooldown%";
    private static final String SORT_TYPE = "%sorting_mode%";
    private static final String OWN_ONLY = "%own_only%";
    private static final String ACTION_TELEPORT = "%action_teleport%";
    private static final String ACTION_EDITOR = "%action_editor%";
    private final WarpsModule module;
    private final ItemHandler sortHandler;
    private final ItemHandler ownedHandler;
    private final ItemHandler serverTypeHandler;
    private final ItemHandler playerTypeHandler;
    private final ViewLink<DisplayInfo> link;
    private String serverWarpName;
    private List<String> serverWarpLore;
    private String playerWarpName;
    private List<String> playerWarpLore;
    private int[] warpSlots;
    private List<String> loreTimesOpen;
    private List<String> loreTimesClosed;
    private List<String> loreNoPermission;
    private List<String> loreNoMoney;
    private List<String> loreCooldown;
    private List<String> loreVisitCost;
    private List<String> loreVisitCooldown;
    private List<String> loreTeleport;
    private List<String> loreEditor;

    public WarpListMenu(@NotNull SunLightPlugin plugin, @NotNull WarpsModule module) {
        super((NightCorePlugin)plugin, FileConfig.load((String)module.getLocalUIPath(), (String)FILE));
        this.module = module;
        this.link = new ViewLink();
        this.sortHandler = new ItemHandler("sorting_mode", (viewer, event) -> {
            DisplayInfo info = (DisplayInfo)this.getLink(viewer);
            info.sortType = (SortType)Lists.next((Enum)info.sortType);
            this.runNextTick(() -> this.flush(viewer));
        });
        this.addHandler(this.sortHandler);
        this.ownedHandler = new ItemHandler("own_toggle", (viewer, event) -> {
            DisplayInfo info = (DisplayInfo)this.getLink(viewer);
            info.ownedOnly = !info.ownedOnly;
            this.runNextTick(() -> this.flush(viewer));
        });
        this.addHandler(this.ownedHandler);
        this.serverTypeHandler = new ItemHandler("server_warps", (viewer, event) -> {
            DisplayInfo info = (DisplayInfo)this.getLink(viewer);
            info.type = WarpType.SERVER;
            this.runNextTick(() -> this.flush(viewer));
        });
        this.addHandler(this.serverTypeHandler);
        this.playerTypeHandler = new ItemHandler("player_warps", (viewer, event) -> {
            DisplayInfo info = (DisplayInfo)this.getLink(viewer);
            info.type = WarpType.PLAYER;
            this.runNextTick(() -> this.flush(viewer));
        });
        this.addHandler(this.playerTypeHandler);
        this.load();
        this.getItems().forEach(menuItem -> {
            if (menuItem.getHandler() == this.playerTypeHandler) {
                menuItem.getOptions().addVisibilityPolicy(viewer -> ((DisplayInfo)this.getLink((MenuViewer)viewer)).type != WarpType.PLAYER);
            } else if (menuItem.getHandler() == this.serverTypeHandler) {
                menuItem.getOptions().addVisibilityPolicy(viewer -> ((DisplayInfo)this.getLink((MenuViewer)viewer)).type != WarpType.SERVER);
            } else if (menuItem.getHandler() == this.ownedHandler) {
                menuItem.getOptions().addDisplayModifier((viewer, itemStack) -> ItemReplacer.replace((ItemStack)itemStack, line -> line.replace(OWN_ONLY, CoreLang.getYesOrNo((boolean)((DisplayInfo)this.getLink((MenuViewer)viewer)).ownedOnly))));
            } else if (menuItem.getHandler() == this.sortHandler) {
                menuItem.getOptions().addDisplayModifier((viewer, item) -> ItemReplacer.replace((ItemStack)item, line -> line.replace(SORT_TYPE, WarpsLang.SORT_TYPE.getLocalized((Enum)((DisplayInfo)this.getLink((MenuViewer)viewer)).sortType))));
            }
        });
    }

    @NotNull
    public ViewLink<DisplayInfo> getLink() {
        return this.link;
    }

    public void onPrepare(@NotNull MenuViewer viewer, @NotNull MenuOptions options) {
        this.autoFill(viewer);
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }

    public void onAutoFill(@NotNull MenuViewer viewer, @NotNull AutoFill<Warp> autoFill) {
        Player player = viewer.getPlayer();
        DisplayInfo displayInfo = (DisplayInfo)this.getLink(player);
        autoFill.setSlots(this.warpSlots);
        autoFill.setItems(this.module.getWarps().stream().filter(warp -> warp.getType() == displayInfo.type).filter(warp -> !displayInfo.ownedOnly || warp.isOwner(player)).sorted(displayInfo.sortType.getComparator()).toList());
        autoFill.setItemCreator(warp -> {
            ItemStack item = warp.getIcon();
            ArrayList<Object> loreTimes = new ArrayList();
            ArrayList<Object> loreNoPerm = new ArrayList();
            ArrayList<Object> loreNoMoney = new ArrayList();
            ArrayList loreCooldown = new ArrayList();
            ArrayList<Object> loreVisitCost = new ArrayList();
            ArrayList<Object> loreVisitCooldown = new ArrayList();
            ArrayList<String> loreTeleport = new ArrayList<String>(this.loreTeleport);
            ArrayList<Object> loreEditor = new ArrayList();
            PlaceholderMap placeholders = new PlaceholderMap();
            if (!warp.hasPermission(player)) {
                loreNoPerm = new ArrayList<String>(this.loreNoPermission);
                loreTeleport.clear();
            } else {
                if (warp.canEdit(player)) {
                    loreEditor = new ArrayList<String>(this.loreEditor);
                }
                if (warp.hasVisitTimes()) {
                    LocalTime time;
                    if (!warp.isVisitTime(player)) {
                        loreTeleport.clear();
                        time = warp.getNearestVisitTime();
                        if (time != null) {
                            loreTimes = new ArrayList<String>(this.loreTimesClosed);
                        }
                    } else {
                        time = warp.getNearestCloseTime();
                        if (time != null) {
                            loreTimes = new ArrayList<String>(this.loreTimesOpen);
                        }
                    }
                    if (time != null) {
                        placeholders.add("%time%", time.format(Warp.TIME_FORMATTER));
                    }
                }
                if (warp.hasVisitCooldown()) {
                    SunUser user = (SunUser)((SunLightPlugin)this.plugin).getUserManager().getOrFetch(player);
                    loreVisitCooldown = new ArrayList<String>(this.loreVisitCooldown);
                }
                if (warp.hasVisitCost()) {
                    if (!warp.canAffordVisit(player)) {
                        loreTeleport.clear();
                        loreNoMoney = new ArrayList<String>(this.loreNoMoney);
                    } else {
                        loreVisitCost = new ArrayList<String>(this.loreVisitCost);
                    }
                }
            }
            ItemReplacer.create((ItemStack)item).hideFlags().trimmed().setDisplayName(warp.getType() == WarpType.SERVER ? this.serverWarpName : this.playerWarpName).setLore(warp.getType() == WarpType.SERVER ? this.serverWarpLore : this.playerWarpLore).injectLore(TIMES, loreTimes).injectLore(COOLDOWN, loreCooldown).injectLore(NO_MONEY, loreNoMoney).injectLore(NO_PERMISSION, loreNoPerm).injectLore(VISIT_COST, loreVisitCost).injectLore(VISIT_COOLDOWN, loreVisitCooldown).injectLore(ACTION_TELEPORT, loreTeleport).injectLore(ACTION_EDITOR, loreEditor).replace(new PlaceholderMap[]{placeholders}).replace(new PlaceholderMap[]{warp.getPlaceholders()}).writeMeta();
            return item;
        });
        autoFill.setClickAction(warp -> (viewer1, event) -> {
            if (event.isLeftClick()) {
                this.module.teleport((Warp)((Object)warp), player, false);
                return;
            }
            if (event.isRightClick() && warp.canEdit(player)) {
                this.runNextTick(() -> warp.getModule().openWarpSettings(player, (Warp)((Object)warp)));
            }
        });
    }

    @NotNull
    protected MenuOptions createDefaultOptions() {
        return new MenuOptions(Tags.BLACK.enclose("Warps"), MenuSize.CHEST_45);
    }

    @NotNull
    protected List<MenuItem> createDefaultItems() {
        ArrayList<MenuItem> list = new ArrayList<MenuItem>();
        ItemStack panes = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        list.add(new MenuItem(panes).setSlots(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 14, 15, 17, 18, 23, 24, 26, 27, 32, 33, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44}).setPriority(0));
        ItemStack nextPage = ItemUtil.getSkinHead((String)"f32ca66056b72863e98f7f32bd7d94c7a0d796af691c9ac3a9136331352288f9");
        ItemUtil.editMeta((ItemStack)nextPage, meta -> meta.setDisplayName(CoreLang.EDITOR_ITEM_NEXT_PAGE.getDefaultName()));
        list.add(new MenuItem(nextPage).setPriority(10).setSlots(new int[]{23}).setHandler(ItemHandler.forNextPage((Menu)this)));
        ItemStack backPage = ItemUtil.getSkinHead((String)"86971dd881dbaf4fd6bcaa93614493c612f869641ed59d1c9363a3666a5fa6");
        ItemUtil.editMeta((ItemStack)backPage, meta -> meta.setDisplayName(CoreLang.EDITOR_ITEM_PREVIOUS_PAGE.getDefaultName()));
        list.add(new MenuItem(backPage).setPriority(10).setSlots(new int[]{18}).setHandler(ItemHandler.forPreviousPage((Menu)this)));
        ItemStack sort = ItemUtil.getSkinHead((String)"5cce7359a25de6da56308e6a369c6372e2c30906c62647040da137a32addc9");
        ItemUtil.editMeta((ItemStack)sort, meta -> {
            meta.setDisplayName(Tags.LIGHT_YELLOW.enclose(Tags.BOLD.enclose("Display Order")));
            meta.setLore(Lists.newList((Object[])new String[]{Tags.LIGHT_YELLOW.enclose("\u25aa " + Tags.LIGHT_GRAY.enclose("Current: ") + SORT_TYPE), "", Tags.LIGHT_GRAY.enclose(Tags.LIGHT_YELLOW.enclose("[\u25b6]") + " Click to " + Tags.LIGHT_YELLOW.enclose("toggle") + ".")}));
        });
        list.add(new MenuItem(sort).setPriority(10).setSlots(new int[]{16}).setHandler(this.sortHandler));
        ItemStack ownToggle = new ItemStack(Material.OAK_SIGN);
        ItemUtil.editMeta((ItemStack)ownToggle, meta -> {
            meta.setDisplayName(Tags.LIGHT_YELLOW.enclose(Tags.BOLD.enclose("Own Only")));
            meta.setLore(Lists.newList((Object[])new String[]{Tags.LIGHT_YELLOW.enclose("\u25aa " + Tags.LIGHT_GRAY.enclose("Enabled: ") + OWN_ONLY), "", Tags.LIGHT_GRAY.enclose(Tags.LIGHT_YELLOW.enclose("[\u25b6]") + " Click to " + Tags.LIGHT_YELLOW.enclose("toggle") + ".")}));
        });
        list.add(new MenuItem(ownToggle).setPriority(10).setSlots(new int[]{25}).setHandler(this.ownedHandler));
        ItemStack playerWarps = ItemUtil.getSkinHead((String)"100191e52d207a0ef4972ff8393e4ed1277b1b872e72e7830aff09e938f337ec");
        ItemUtil.editMeta((ItemStack)playerWarps, meta -> {
            meta.setDisplayName(Tags.LIGHT_YELLOW.enclose(Tags.BOLD.enclose("Player Warps")));
            meta.setLore(Lists.newList((Object[])new String[]{Tags.LIGHT_GRAY.enclose("Browse warps created by our players!"), "", Tags.LIGHT_GRAY.enclose(Tags.LIGHT_YELLOW.enclose("[\u25b6]") + " Click to " + Tags.LIGHT_YELLOW.enclose("navigate") + ".")}));
        });
        list.add(new MenuItem(playerWarps).setPriority(10).setSlots(new int[]{34}).setHandler(this.playerTypeHandler));
        ItemStack serverWarps = ItemUtil.getSkinHead((String)"efbf8fdcac5b1419ea1954f2b6fcff65bfdb6511b601bf4408d9bbb311de7648");
        ItemUtil.editMeta((ItemStack)serverWarps, meta -> {
            meta.setDisplayName(Tags.LIGHT_YELLOW.enclose(Tags.BOLD.enclose("Server Warps")));
            meta.setLore(Lists.newList((Object[])new String[]{Tags.LIGHT_GRAY.enclose("Browse our official, server warps!"), "", Tags.LIGHT_GRAY.enclose(Tags.LIGHT_YELLOW.enclose("[\u25b6]") + " Click to " + Tags.LIGHT_YELLOW.enclose("navigate") + ".")}));
        });
        list.add(new MenuItem(serverWarps).setPriority(10).setSlots(new int[]{34}).setHandler(this.serverTypeHandler));
        return list;
    }

    protected void loadAdditional() {
        this.serverWarpName = (String)ConfigValue.create((String)"Warp.Server.Name", (String)(Tags.LIGHT_YELLOW.enclose(Tags.BOLD.enclose("%warp_name%")) + " " + Tags.GRAY.enclose("(ID: " + Tags.WHITE.enclose("%warp_id%") + ")")), (String[])new String[0]).read(this.cfg);
        this.serverWarpLore = (List)ConfigValue.create((String)"Warp.Server.Lore", (List)Lists.newList((Object[])new String[]{Tags.DARK_GRAY.enclose("Official Warp"), "", "%warp_description%", "", TIMES, NO_PERMISSION, NO_MONEY, VISIT_COST, VISIT_COOLDOWN, COOLDOWN, "", ACTION_TELEPORT, ACTION_EDITOR}), (String[])new String[0]).read(this.cfg);
        this.playerWarpName = (String)ConfigValue.create((String)"Warp.Player.Name", (String)(Tags.LIGHT_YELLOW.enclose(Tags.BOLD.enclose("%warp_name%")) + " " + Tags.GRAY.enclose("(ID: " + Tags.WHITE.enclose("%warp_id%") + ")")), (String[])new String[0]).read(this.cfg);
        this.playerWarpLore = (List)ConfigValue.create((String)"Warp.Player.Lore", (List)Lists.newList((Object[])new String[]{Tags.DARK_GRAY.enclose("Created by %warp_owner_name%"), "", "%warp_description%", "", TIMES, NO_PERMISSION, NO_MONEY, VISIT_COST, VISIT_COOLDOWN, COOLDOWN, "", ACTION_TELEPORT, ACTION_EDITOR}), (String[])new String[0]).read(this.cfg);
        this.loreTeleport = (List)ConfigValue.create((String)"Warp.Lore.Teleport", (List)Lists.newList((Object[])new String[]{Tags.LIGHT_GRAY.enclose(Tags.LIGHT_YELLOW.enclose("[\u25b6]") + " Left-Click to " + Tags.LIGHT_YELLOW.enclose("teleport") + ".")}), (String[])new String[0]).read(this.cfg);
        this.loreEditor = (List)ConfigValue.create((String)"Warp.Lore.Editor", (List)Lists.newList((Object[])new String[]{Tags.LIGHT_GRAY.enclose(Tags.LIGHT_YELLOW.enclose("[\u25b6]") + " Right-Click to " + Tags.LIGHT_YELLOW.enclose("edit") + ".")}), (String[])new String[0]).read(this.cfg);
        this.loreTimesOpen = (List)ConfigValue.create((String)"Warp.Lore.Times_Open", (List)Lists.newList((Object[])new String[]{Tags.LIGHT_GRAY.enclose(Tags.LIGHT_GREEN.enclose("\u2714") + " Open until " + Tags.LIGHT_GREEN.enclose("%time%") + ".")}), (String[])new String[0]).read(this.cfg);
        this.loreTimesClosed = (List)ConfigValue.create((String)"Warp.Lore.Times_Closed", (List)Lists.newList((Object[])new String[]{Tags.LIGHT_GRAY.enclose(Tags.LIGHT_RED.enclose("[\u2757]") + " Closed until " + Tags.LIGHT_RED.enclose("%time%") + ".")}), (String[])new String[0]).read(this.cfg);
        this.loreNoPermission = (List)ConfigValue.create((String)"Warp.Lore.No_Permission", (List)Lists.newList((Object[])new String[]{Tags.LIGHT_GRAY.enclose(Tags.LIGHT_RED.enclose("[\u2757]") + " You don't have " + Tags.LIGHT_RED.enclose("permission") + " to visit this warp.")}), (String[])new String[0]).read(this.cfg);
        this.loreNoMoney = (List)ConfigValue.create((String)"Warp.Lore.No_Money", (List)Lists.newList((Object[])new String[]{Tags.LIGHT_GRAY.enclose(Tags.LIGHT_RED.enclose("[\u2757]") + " You don't have " + Tags.LIGHT_RED.enclose("%warp_visit_cost%") + " to visit this warp.")}), (String[])new String[0]).read(this.cfg);
        this.loreVisitCost = (List)ConfigValue.create((String)"Warp.Lore.VisitCost", (List)Lists.newList((Object[])new String[]{Tags.LIGHT_GRAY.enclose(Tags.LIGHT_RED.enclose("[\u2757]") + " Visit Cost: " + Tags.LIGHT_RED.enclose("$%warp_visit_cost%"))}), (String[])new String[0]).read(this.cfg);
        this.loreVisitCooldown = (List)ConfigValue.create((String)"Warp.Lore.VisitCooldown", (List)Lists.newList((Object[])new String[]{Tags.LIGHT_GRAY.enclose(Tags.LIGHT_RED.enclose("[\u2757]") + " Visit Cooldown: " + Tags.LIGHT_RED.enclose("%warp_visit_cooldown%"))}), (String[])new String[0]).read(this.cfg);
        this.loreCooldown = (List)ConfigValue.create((String)"Warp.Lore.Cooldown", (List)Lists.newList((Object[])new String[]{Tags.LIGHT_GRAY.enclose(Tags.LIGHT_RED.enclose("[\u2757]") + " You can visit this warp again in " + Tags.LIGHT_RED.enclose(COOLDOWN) + ".")}), (String[])new String[0]).read(this.cfg);
        this.warpSlots = (int[])ConfigValue.create((String)"Warp.Slots", (int[])new int[]{10, 11, 12, 13, 19, 20, 21, 22, 28, 29, 30, 31}, (String[])new String[0]).read(this.cfg);
    }
}

