/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.warps.impl;

import java.io.File;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.command.NightCommand;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.integration.VaultHook;
import su.nightexpress.nightcore.manager.AbstractFileData;
import su.nightexpress.nightcore.user.UserInfo;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.Pair;
import su.nightexpress.nightcore.util.Plugins;
import su.nightexpress.nightcore.util.TimeUtil;
import su.nightexpress.nightcore.util.geodata.pos.ExactPos;
import su.nightexpress.nightcore.util.placeholder.Placeholder;
import su.nightexpress.nightcore.util.placeholder.PlaceholderMap;
import su.nightexpress.nightcore.util.text.tag.Tags;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.warps.WarpsModule;
import su.nightexpress.sunlight.module.warps.config.WarpsConfig;
import su.nightexpress.sunlight.module.warps.config.WarpsLang;
import su.nightexpress.sunlight.module.warps.config.WarpsPerms;
import su.nightexpress.sunlight.module.warps.type.WarpType;
import su.nightexpress.sunlight.module.warps.util.Placeholders;

public class Warp
extends AbstractFileData<SunLightPlugin>
implements Placeholder {
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ISO_LOCAL_TIME;
    private final WarpsModule module;
    private final PlaceholderMap placeholderMap;
    private final Set<Pair<LocalTime, LocalTime>> visitTimes;
    private UserInfo owner;
    private WarpType type;
    private String name;
    private String description;
    private String worldName;
    private ExactPos blockPos;
    private ItemStack icon;
    private boolean permissionRequired;
    private String commandShortcut;
    private int visitCooldown;
    private double visitCostMoney;
    private NightCommand command;

    public Warp(@NotNull SunLightPlugin plugin, @NotNull WarpsModule module, @NotNull File file) {
        super((NightCorePlugin)plugin, file);
        this.module = module;
        this.visitTimes = new HashSet<Pair<LocalTime, LocalTime>>();
        this.placeholderMap = Placeholders.forWarp(this);
    }

    protected boolean onLoad(@NotNull FileConfig config) {
        UUID ownerId;
        String locationStr = config.getString("Location");
        if (locationStr != null) {
            String[] split = locationStr.split(",");
            if (split.length != 6) {
                return false;
            }
            String world = split[5];
            ExactPos pos = ExactPos.deserialize((String)locationStr);
            config.remove("Location");
            config.set("World", (Object)world);
            pos.write(config, "BlockPos");
        }
        try {
            ownerId = UUID.fromString(String.valueOf(config.getString("Owner.Id")));
        }
        catch (IllegalArgumentException exception) {
            exception.printStackTrace();
            return false;
        }
        String ownerName = String.valueOf(config.getString("Owner.Name"));
        this.setOwner(new UserInfo(ownerId, ownerName));
        this.blockPos = ExactPos.read((FileConfig)config, (String)"BlockPos");
        this.worldName = config.getString("World");
        this.setIcon(config.getItem("Icon"));
        this.setType((WarpType)config.getEnum("Type", WarpType.class, (Enum)WarpType.SERVER));
        this.setName(config.getString("Name", this.getId()));
        this.setDescription(config.getString("Description"));
        this.setPermissionRequired(config.getBoolean("Permission_Required"));
        this.setVisitCooldown(config.getInt("Visit.Cooldown"));
        this.getVisitTimes().addAll(config.getStringList("Visit.Times").stream().map(raw -> {
            String[] split = raw.split("-");
            if (split.length < 2) {
                return null;
            }
            try {
                LocalTime start = LocalTime.parse(split[0], TIME_FORMATTER);
                LocalTime end = LocalTime.parse(split[1], TIME_FORMATTER);
                return Pair.of((Object)start, (Object)end);
            }
            catch (DateTimeParseException e) {
                return null;
            }
        }).filter(Objects::nonNull).toList());
        this.setVisitCostMoney(config.getDouble("Visit.Cost.Money"));
        this.setCommandShortcut(config.getString("Command_Shortcut"));
        return true;
    }

    protected void onSave(@NotNull FileConfig config) {
        config.set("Owner.Id", (Object)this.getOwner().id().toString());
        config.set("Owner.Name", (Object)this.getOwner().name());
        config.set("World", (Object)this.worldName);
        this.blockPos.write(config, "BlockPos");
        config.set("Type", (Object)this.getType().name());
        config.set("Name", (Object)this.getName());
        config.set("Description", (Object)this.getDescription());
        config.set("Permission_Required", (Object)this.isPermissionRequired());
        config.set("Visit.Cooldown", (Object)this.getVisitCooldown());
        config.set("Visit.Times", this.getVisitTimes().stream().map(pair -> ((LocalTime)pair.getFirst()).format(TIME_FORMATTER) + "-" + ((LocalTime)pair.getSecond()).format(TIME_FORMATTER)).toList());
        config.set("Visit.Cost.Money", (Object)this.getVisitCostMoney());
        config.setItem("Icon", this.getIcon());
        config.set("Command_Shortcut", (Object)this.getCommandShortcut());
    }

    @NotNull
    public PlaceholderMap getPlaceholders() {
        return this.placeholderMap;
    }

    public boolean isValid() {
        return this.getWorld() != null;
    }

    public World getWorld() {
        return this.worldName == null ? null : ((SunLightPlugin)this.plugin).getServer().getWorld(this.worldName);
    }

    public Location getLocation() {
        World world = this.getWorld();
        if (world == null) {
            return null;
        }
        return this.blockPos.toLocation(world);
    }

    public void setLocation(@NotNull Location location) {
        World locWorld = location.getWorld();
        if (locWorld == null) {
            return;
        }
        this.worldName = locWorld.getName();
        this.blockPos = ExactPos.from((Location)location);
    }

    public boolean isOwner(@NotNull Player player) {
        return this.getOwner().isUser(player);
    }

    public boolean canEdit(@NotNull Player player) {
        return this.isOwner(player) || player.hasPermission(WarpsPerms.EDITOR_OTHERS);
    }

    public boolean isOnCooldown(@NotNull Player player) {
        return false;
    }

    public boolean isAvailable(@NotNull Player player) {
        if (!this.hasPermission(player)) {
            return false;
        }
        if (!this.isVisitTime(player)) {
            return false;
        }
        if (this.isOnCooldown(player)) {
            return false;
        }
        return this.canAffordVisit(player);
    }

    public boolean isVisitTime() {
        if (!this.hasVisitTimes()) {
            return true;
        }
        LocalTime now = TimeUtil.getCurrentTime();
        return this.getVisitTimes().stream().anyMatch(pair -> now.isAfter((LocalTime)pair.getFirst()) && now.isBefore((LocalTime)pair.getSecond()));
    }

    public boolean isVisitTime(@NotNull Player player) {
        if (this.isOwner(player)) {
            return true;
        }
        if (player.hasPermission(WarpsPerms.BYPASS_VISIT_TIME)) {
            return true;
        }
        return this.isVisitTime();
    }

    public boolean hasVisitTimes() {
        return !this.getVisitTimes().isEmpty();
    }

    @Nullable
    public LocalTime getNearestVisitTime() {
        LocalTime now = TimeUtil.getCurrentTime();
        return this.getVisitTimes().stream().filter(pair -> now.isBefore((LocalTime)pair.getFirst()) || now.isAfter((LocalTime)pair.getSecond())).map(Pair::getFirst).min(LocalTime::compareTo).orElse(null);
    }

    @Nullable
    public LocalTime getNearestCloseTime() {
        LocalTime now = TimeUtil.getCurrentTime();
        return this.getVisitTimes().stream().filter(pair -> now.isAfter((LocalTime)pair.getFirst()) && now.isBefore((LocalTime)pair.getSecond())).map(Pair::getSecond).findFirst().orElse(null);
    }

    @NotNull
    public String getPermission() {
        return WarpsPerms.WARP.childrenNode(this.getId());
    }

    public boolean hasPermission(@NotNull Player player) {
        return !this.isPermissionRequired() || this.isOwner(player) || player.hasPermission(this.getPermission());
    }

    public boolean hasVisitCooldown() {
        return (long)this.getVisitCooldown() > 0L;
    }

    public boolean isVisitOneTimed() {
        return (long)this.getVisitCooldown() < 0L;
    }

    public boolean hasVisitCost() {
        return this.visitCostMoney > 0.0 && Plugins.hasVault() && VaultHook.hasEconomy();
    }

    public boolean canAffordVisit(@NotNull Player player) {
        if (!this.hasVisitCost()) {
            return true;
        }
        if (this.isOwner(player)) {
            return true;
        }
        if (player.hasPermission(WarpsPerms.BYPASS_VISIT_COST)) {
            return true;
        }
        return VaultHook.getBalance((Player)player) >= this.getVisitCostMoney();
    }

    @NotNull
    public WarpsModule getModule() {
        return this.module;
    }

    @NotNull
    public UserInfo getOwner() {
        return this.owner;
    }

    public void setOwner(@NotNull UserInfo owner) {
        this.owner = owner;
    }

    @NotNull
    public WarpType getType() {
        return this.type;
    }

    public void setType(@NotNull WarpType type) {
        this.type = type;
    }

    @NotNull
    public String getWorldName() {
        return this.worldName;
    }

    @NotNull
    public ExactPos getBlockPos() {
        return this.blockPos;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public List<String> getDescriptionFormatted() {
        if (this.description == null) {
            return Collections.emptyList();
        }
        ArrayList<String> description = new ArrayList<String>();
        for (String line : (List)WarpsConfig.WARP_DESCRIPTION_FORMAT.get()) {
            if (line.contains("%entry%")) {
                for (String desc : Tags.LINE_BREAK.split(this.description)) {
                    description.add(line.replace("%entry%", desc));
                }
                continue;
            }
            description.add(line);
        }
        return description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public boolean isPermissionRequired() {
        return this.permissionRequired;
    }

    public void setPermissionRequired(boolean isPermission) {
        this.permissionRequired = isPermission;
    }

    @NotNull
    public Set<Pair<LocalTime, LocalTime>> getVisitTimes() {
        return this.visitTimes;
    }

    public int getVisitCooldown() {
        return this.visitCooldown;
    }

    public void setVisitCooldown(int visitCooldown) {
        this.visitCooldown = visitCooldown;
    }

    public double getVisitCostMoney() {
        return this.visitCostMoney;
    }

    public void setVisitCostMoney(double visitCostMoney) {
        this.visitCostMoney = visitCostMoney;
    }

    @NotNull
    public ItemStack getIcon() {
        return new ItemStack(this.icon);
    }

    public void setIcon(@NotNull ItemStack icon) {
        this.icon = new ItemStack(icon);
        ItemUtil.editMeta((ItemStack)this.icon, meta -> {
            meta.setDisplayName(null);
            meta.setLore(null);
            meta.addItemFlags(ItemFlag.values());
        });
    }

    @Nullable
    public String getCommandShortcut() {
        return this.commandShortcut;
    }

    public void setCommandShortcut(@Nullable String commandShortcut) {
        this.unloadCommand();
        this.commandShortcut = commandShortcut;
        this.loadCommand();
    }

    public void unloadCommand() {
        if (this.command != null && this.command.unregister()) {
            this.command = null;
        }
    }

    private void loadCommand() {
        if (this.command != null) {
            return;
        }
        this.command = NightCommand.literal((NightPlugin)((NightPlugin)this.plugin), (String)this.commandShortcut, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description((String)this.replacePlaceholders().apply(WarpsLang.COMMAND_DIRECT_WARP_DESC.text()))).permission(this.getPermission())).executes((context, arguments) -> this.module.teleport(this, context.getPlayerOrThrow(), false)));
    }
}

