/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.warps.command;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.Commands;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.commands.exceptions.CommandSyntaxException;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.manager.AbstractFileData;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.warps.WarpsModule;
import su.nightexpress.sunlight.module.warps.config.WarpsLang;
import su.nightexpress.sunlight.module.warps.config.WarpsPerms;
import su.nightexpress.sunlight.module.warps.impl.Warp;
import su.nightexpress.sunlight.module.warps.util.Placeholders;

public class WarpCommands
extends AbstractCommandProvider {
    private static final String NODE_CREATE = "warp_create";
    private static final String NODE_DELETE = "warp_delete";
    private static final String NODE_LIST = "warp_list";
    private static final String NODE_RESET_COOLDOWN = "warp_reset_cooldown";
    private static final String NODE_SET_COOLDOWN = "warp_set_cooldown";
    private static final String NODE_TELEPORT = "warp_teleport";
    private final WarpsModule module;

    public WarpCommands(@NotNull SunLightPlugin plugin, @NotNull WarpsModule module) {
        super(plugin);
        this.module = module;
    }

    @Override
    protected void loadSettings(@NotNull FileConfig config, @NotNull String path) {
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(NODE_CREATE, true, new String[]{"setwarp"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(WarpsLang.COMMAND_CREATE_WARP_DESC)).permission(WarpsPerms.COMMAND_WARPS_CREATE)).withArguments(new ArgumentNodeBuilder[]{Arguments.string((String)"name").localized(CoreLang.COMMAND_ARGUMENT_NAME_NAME)}).executes(this::createWarp));
        this.registerLiteral(NODE_DELETE, true, new String[]{"delwarp"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(WarpsLang.COMMAND_DELETE_WARP_DESC)).permission(WarpsPerms.COMMAND_WARPS_DELETE)).withArguments(new ArgumentNodeBuilder[]{WarpCommands.warpArgument(this.module).suggestions((reader, context) -> {
            if (context.getPlayer() == null || context.getSender().hasPermission(WarpsPerms.COMMAND_WARPS_DELETE_OTHERS)) {
                return this.module.getWarps().stream().map(AbstractFileData::getId).toList();
            }
            return this.module.getOwnedWarps(context.getPlayer()).stream().map(AbstractFileData::getId).toList();
        })}).executes(this::deleteWarp));
        this.registerLiteral(NODE_LIST, true, new String[]{"warplist"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(WarpsLang.COMMAND_WARP_LIST_DESC)).permission(WarpsPerms.COMMAND_WARPS_LIST)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(WarpsPerms.COMMAND_WARPS_LIST_OTHERS)).optional()}).executes(this::listWarps));
        this.registerLiteral(NODE_TELEPORT, true, new String[]{"warp"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(WarpsLang.COMMAND_WARP_DESC)).permission(WarpsPerms.COMMAND_WARPS_TELEPORT)).withArguments(new ArgumentNodeBuilder[]{WarpCommands.activeWarpArgument(this.module).suggestions((reader, context) -> new ArrayList<String>(this.module.getWarpsMap().keySet())), ((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(WarpsPerms.COMMAND_WARPS_TELEPORT_OTHERS)).optional()}).executes(this::teleport));
        this.registerRoot("warps", true, new String[]{"warps"}, (Map<String, String> map) -> {
            map.put(NODE_CREATE, "create");
            map.put(NODE_DELETE, "delete");
            map.put(NODE_LIST, "list");
            map.put(NODE_TELEPORT, "teleport");
        }, (HubNodeBuilder builder) -> ((HubNodeBuilder)builder.description(WarpsLang.COMMAND_WARPS_ROOT_DESC)).permission(WarpsPerms.COMMAND_WARPS_ROOT));
    }

    @NotNull
    private static ArgumentNodeBuilder<Warp> warpArgument(@NotNull WarpsModule module) {
        return WarpCommands.warpArgument(module, module::getWarp);
    }

    @NotNull
    private static ArgumentNodeBuilder<Warp> activeWarpArgument(@NotNull WarpsModule module) {
        return WarpCommands.warpArgument(module, module::getActiveWarp);
    }

    @NotNull
    private static ArgumentNodeBuilder<Warp> warpArgument(@NotNull WarpsModule module, @NotNull Function<String, Warp> function) {
        return Commands.argument((String)"name", (context, str) -> Optional.ofNullable((Warp)((Object)((Object)function.apply(str)))).orElseThrow(() -> CommandSyntaxException.custom((MessageLocale)WarpsLang.ERROR_COMMAND_INVALID_WARP_ARGUMENT))).localized(CoreLang.COMMAND_ARGUMENT_NAME_NAME);
    }

    private boolean createWarp(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        return this.module.create(player, arguments.getString("name"), false);
    }

    private boolean deleteWarp(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Warp warp = (Warp)((Object)arguments.get("name", Warp.class));
        Player player = context.getPlayer();
        if (player != null && !warp.isOwner(player) && !player.hasPermission(WarpsPerms.COMMAND_WARPS_DELETE_OTHERS)) {
            context.errorPermission();
            return false;
        }
        this.module.delete(warp);
        context.send(WarpsLang.WARP_DELETE_DONE, replacer -> replacer.replace(warp.replacePlaceholders()));
        return true;
    }

    private boolean listWarps(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player target = this.getTargetOrSender(context, arguments, "player", true);
        if (target == null) {
            return false;
        }
        this.module.openServerWarps(target);
        if (context.getSender() != target) {
            context.send(WarpsLang.COMMAND_LIST_OTHERS, replacer -> replacer.replace(Placeholders.forPlayer((Player)target)));
        }
        return true;
    }

    private boolean resetCooldown(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Warp warp = (Warp)((Object)arguments.get("name", Warp.class));
        return true;
    }

    private boolean setCooldown(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Warp warp = (Warp)((Object)arguments.get("name", Warp.class));
        int amount = arguments.getInt("time");
        if (amount == 0) {
            return false;
        }
        long expireDate = amount < 0 ? -1L : System.currentTimeMillis() + (long)amount * 1000L;
        return true;
    }

    private boolean teleport(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        boolean isForced;
        Warp warp = (Warp)((Object)arguments.get("name", Warp.class));
        Player target = this.getTargetOrSender(context, arguments, "player", true);
        if (target == null) {
            return false;
        }
        boolean bl = isForced = context.getSender() != target;
        if (isForced) {
            WarpsLang.COMMAND_TELEPORT_OTHERS.message().send(context.getSender(), replacer -> replacer.replace(Placeholders.forPlayer((Player)target)).replace(warp.replacePlaceholders()));
        }
        return this.module.teleport(warp, target, isForced);
    }
}

