/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.warps;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.integration.VaultHook;
import su.nightexpress.nightcore.user.UserInfo;
import su.nightexpress.nightcore.util.FileUtil;
import su.nightexpress.nightcore.util.RankMap;
import su.nightexpress.nightcore.util.StringUtil;
import su.nightexpress.nightcore.util.TimeUtil;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.config.PermissionTree;
import su.nightexpress.sunlight.hook.placeholder.PlaceholderRegistry;
import su.nightexpress.sunlight.module.Module;
import su.nightexpress.sunlight.module.ModuleContext;
import su.nightexpress.sunlight.module.warps.command.WarpCommands;
import su.nightexpress.sunlight.module.warps.config.WarpsConfig;
import su.nightexpress.sunlight.module.warps.config.WarpsLang;
import su.nightexpress.sunlight.module.warps.config.WarpsPerms;
import su.nightexpress.sunlight.module.warps.event.PlayerWarpTeleportEvent;
import su.nightexpress.sunlight.module.warps.impl.Warp;
import su.nightexpress.sunlight.module.warps.menu.DisplayInfo;
import su.nightexpress.sunlight.module.warps.menu.WarpListMenu;
import su.nightexpress.sunlight.module.warps.menu.WarpSettingsMenu;
import su.nightexpress.sunlight.module.warps.type.WarpType;
import su.nightexpress.sunlight.module.warps.util.WarpUtils;
import su.nightexpress.sunlight.teleport.TeleportFlag;
import su.nightexpress.sunlight.teleport.TeleportFlags;
import su.nightexpress.sunlight.teleport.TeleportManager;
import su.nightexpress.sunlight.teleport.TeleportType;
import su.nightexpress.sunlight.user.SunUser;

public class WarpsModule
extends Module {
    public static final String DIR_WARPS = "/warps/";
    private final TeleportManager teleportManager;
    private final Map<String, Warp> warpMap;
    private WarpListMenu warpListMenu;
    private WarpSettingsMenu settingsMenu;

    public WarpsModule(@NotNull ModuleContext context, @NotNull TeleportManager teleportManager) {
        super(context);
        this.teleportManager = teleportManager;
        this.warpMap = new HashMap<String, Warp>();
    }

    @Override
    protected void loadModule(@NotNull FileConfig config) {
        config.initializeOptions(WarpsConfig.class);
        ((SunLightPlugin)this.plugin).injectLang(WarpsLang.class);
        this.loadUI();
        this.loadWarps();
    }

    @Override
    protected void unloadModule() {
        if (this.warpListMenu != null) {
            this.warpListMenu.clear();
        }
        if (this.settingsMenu != null) {
            this.settingsMenu.clear();
        }
        this.warpMap.values().forEach(Warp::unloadCommand);
        this.warpMap.clear();
    }

    @Override
    protected void registerPermissions(@NotNull PermissionTree root) {
        root.merge(WarpsPerms.MODULE);
    }

    @Override
    protected void registerCommands() {
        this.commandRegistry.addProvider("warps", new WarpCommands((SunLightPlugin)this.plugin, this));
    }

    @Override
    public void registerPlaceholders(@NotNull PlaceholderRegistry registry) {
    }

    private void loadUI() {
        this.warpListMenu = new WarpListMenu((SunLightPlugin)this.plugin, this);
        this.settingsMenu = new WarpSettingsMenu((SunLightPlugin)this.plugin, this);
    }

    private void loadWarps() {
        for (File file : FileUtil.getConfigFiles((String)(this.getSystemPath() + DIR_WARPS), (boolean)true)) {
            Warp warp = new Warp((SunLightPlugin)this.plugin, this, file);
            this.loadWarp(warp);
        }
        this.info("Loaded " + this.warpMap.size() + " warps.");
    }

    private boolean loadWarp(@NotNull Warp warp) {
        if (warp.load()) {
            this.warpMap.put(warp.getId(), warp);
            return true;
        }
        this.error("Warp not loaded: '" + warp.getFile().getName() + "' !");
        return false;
    }

    public void delete(@NotNull Warp warp) {
        if (warp.getFile().delete()) {
            warp.unloadCommand();
            this.warpMap.remove(warp.getId());
        }
    }

    public boolean create(@NotNull Player player, @NotNull String id, boolean isForced) {
        Warp warp;
        Location location = player.getLocation();
        if (!isForced) {
            int maxAllowed = this.getAllowedWarpsAmount(player);
            if (maxAllowed >= 0 && this.getOwnedWarpsAmount(player) >= maxAllowed) {
                WarpsLang.WARP_CREATE_ERROR_LIMIT.message().send((CommandSender)player);
                return false;
            }
            if (!player.hasPermission(WarpsPerms.BYPASS_CREATION_WORLD) && ((Set)WarpsConfig.WARP_SET_WORLD_BLACKLIST.get()).contains(player.getWorld().getName())) {
                WarpsLang.WARP_CREATE_ERROR_WORLD.message().send((CommandSender)player);
                return false;
            }
        }
        if ((warp = this.getWarp(id)) != null) {
            if (!warp.canEdit(player)) {
                Warp finalWarp = warp;
                WarpsLang.WARP_CREATE_ERROR_EXISTS.message().send((CommandSender)player, replacer -> replacer.replace(finalWarp.replacePlaceholders()));
                return false;
            }
            warp.setLocation(location);
            warp.save();
            Warp finalWarp1 = warp;
            WarpsLang.WARP_CREATE_DONE_RELOCATE.message().send((CommandSender)player, replacer -> replacer.replace(finalWarp1.replacePlaceholders()));
        } else {
            File file = new File(this.getAbsolutePath() + DIR_WARPS, id + ".yml");
            WarpType type = player.hasPermission(WarpsPerms.MODULE.getRoot()) ? WarpType.SERVER : WarpType.PLAYER;
            warp = new Warp((SunLightPlugin)this.plugin, this, file);
            warp.setOwner(UserInfo.of((Player)player));
            warp.setName(StringUtil.capitalizeUnderscored((String)id));
            warp.setIcon(WarpUtils.getDefaultIcon(player, type));
            warp.setLocation(location);
            warp.setType(type);
            warp.save();
            this.loadWarp(warp);
            Warp finalWarp2 = warp;
            WarpsLang.WARP_CREATE_DONE_FRESH.message().send((CommandSender)player, replacer -> replacer.replace(finalWarp2.replacePlaceholders()));
        }
        return true;
    }

    public boolean teleport(@NotNull Warp warp, @NotNull Player player, boolean forced) {
        if (!warp.isValid()) {
            WarpsLang.WARP_TELEPORT_ERROR_DISABLED.message().send((CommandSender)player, replacer -> replacer.replace(warp.replacePlaceholders()));
            return false;
        }
        if (!forced && !warp.hasPermission(player)) {
            WarpsLang.WARP_TELEPORT_ERROR_NO_PERMISSION.message().send((CommandSender)player, replacer -> replacer.replace(warp.replacePlaceholders()));
            return false;
        }
        if (!forced && !warp.isVisitTime(player)) {
            WarpsLang.WARP_TELEPORT_ERROR_TIME.message().send((CommandSender)player, replacer -> replacer.replace(warp.replacePlaceholders()));
            return false;
        }
        SunUser user = (SunUser)((SunLightPlugin)this.plugin).getUserManager().getOrFetch(player);
        long expireDate = 0L;
        if (!forced && !TimeUtil.isPassed((long)expireDate)) {
            WarpsLang.WARP_TELEPORT_ERROR_COOLDOWN.message().send((CommandSender)player, replacer -> replacer.replace("%cooldown%", (Object)TimeUtil.formatDuration((long)expireDate)).replace(warp.replacePlaceholders()));
            return false;
        }
        if (warp.hasVisitCost()) {
            if (!warp.canAffordVisit(player)) {
                WarpsLang.WARP_TELEPORT_ERROR_NOT_ENOUGH_FUNDS.message().send((CommandSender)player, replacer -> replacer.replace(warp.replacePlaceholders()));
                return false;
            }
            if (!player.hasPermission(WarpsPerms.BYPASS_VISIT_COST) && !warp.isOwner(player)) {
                double visitCost = warp.getVisitCostMoney();
                VaultHook.takeMoney((Player)player, (double)visitCost);
            }
        }
        PlayerWarpTeleportEvent event = new PlayerWarpTeleportEvent(player, warp);
        ((SunLightPlugin)this.plugin).getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        TeleportFlags.Builder builder = TeleportFlags.builder().withFlag(TeleportFlag.LOOK_FOR_SURFACE).withFlag(TeleportFlag.AVOID_LAVA).withFlag(TeleportFlag.CENTERED);
        if (forced) {
            builder.withFlag(TeleportFlag.BYPASS_WARMUP);
        }
        this.teleportManager.teleport(player, warp.getLocation(), TeleportType.WARP, builder.build(), () -> {
            WarpsLang.WARP_TELEPORT_DONE.message().send((CommandSender)player, replacer -> replacer.replace(warp.replacePlaceholders()));
            if (forced || !warp.hasVisitCooldown() || !warp.isOwner(player)) {
                // empty if block
            }
        });
        return true;
    }

    @NotNull
    public Map<String, Warp> getWarpsMap() {
        return this.warpMap;
    }

    @NotNull
    public Collection<Warp> getWarps() {
        return this.warpMap.values();
    }

    public void openServerWarps(@NotNull Player player) {
        this.warpListMenu.open(player, new DisplayInfo(WarpType.SERVER));
    }

    public void openPlayerWarps(@NotNull Player player) {
        this.warpListMenu.open(player, new DisplayInfo(WarpType.PLAYER));
    }

    public void openWarpSettings(@NotNull Player player, @NotNull Warp warp) {
        this.settingsMenu.open(player, (Object)warp);
    }

    public int getAllowedWarpsAmount(@NotNull Player player) {
        return (Integer)((RankMap)WarpsConfig.WARP_SET_AMOUNT_PER_GROUP.get()).getGreatestOrNegative(player);
    }

    public int getOwnedWarpsAmount(@NotNull Player player) {
        return this.getOwnedWarps(player).size();
    }

    @NotNull
    public Collection<Warp> getAvailableWarps(@NotNull Player player) {
        return this.getWarps().stream().filter(warp -> warp.isAvailable(player)).collect(Collectors.toSet());
    }

    @NotNull
    public Collection<Warp> getOwnedWarps(@NotNull Player player) {
        return this.getWarps().stream().filter(warp -> warp.isOwner(player)).collect(Collectors.toSet());
    }

    @NotNull
    public List<Warp> getWarps(@NotNull WarpType warpType) {
        return this.getWarps().stream().filter(warp -> warp.getType() == warpType).toList();
    }

    @Nullable
    public Warp getWarp(@NotNull String id) {
        return this.warpMap.get(id.toLowerCase());
    }

    @Nullable
    public Warp getActiveWarp(@NotNull String id) {
        Warp warp = this.getWarp(id);
        return warp == null || !warp.isValid() ? null : warp;
    }
}

