/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.warmups.listener;

import org.bukkit.block.Block;
import org.bukkit.damage.DamageSource;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.AbstractListener;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.warmups.WarmupsModule;
import su.nightexpress.sunlight.module.warmups.config.WarmupsConfig;

public class WarmupsListener
extends AbstractListener<SunLightPlugin> {
    private final WarmupsModule module;

    public WarmupsListener(@NotNull SunLightPlugin plugin, @NotNull WarmupsModule module) {
        super((NightCorePlugin)plugin);
        this.module = module;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWarmupQuit(PlayerQuitEvent event) {
        this.module.cancelWarmup(event.getPlayer(), true);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWarmupDeath(PlayerDeathEvent event) {
        this.module.cancelWarmup(event.getEntity(), true);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWarmupTeleport(PlayerTeleportEvent event) {
        this.module.cancelWarmup(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWarmupInteract(PlayerInteractEvent event) {
        if (!((Boolean)WarmupsConfig.WARMUP_CANCEL_ON_INTERACT.get()).booleanValue()) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.module.hasWarmup(player)) {
            return;
        }
        if (event.useItemInHand() == Event.Result.DENY && event.useInteractedBlock() == Event.Result.DENY) {
            return;
        }
        Action action = event.getAction();
        if (action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK) {
            this.module.cancelWarmup(player);
            return;
        }
        Block block = event.getClickedBlock();
        if (block != null && block.getType().isInteractable()) {
            this.module.cancelWarmup(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWarmupDamage(EntityDamageEvent event) {
        Player damager;
        DamageSource source;
        Entity entity;
        Player victim;
        if (!((Boolean)WarmupsConfig.WARMUP_CANCEL_ON_DAMAGE.get()).booleanValue()) {
            return;
        }
        Entity entity2 = event.getEntity();
        if (entity2 instanceof Player && this.module.hasWarmup(victim = (Player)entity2)) {
            this.module.cancelWarmup(victim);
        }
        if ((entity = (source = event.getDamageSource()).getCausingEntity()) instanceof Player && this.module.hasWarmup(damager = (Player)entity)) {
            this.module.cancelWarmup(damager);
        }
    }
}

