/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.warmups;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.util.rankmap.IntRankMap;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.config.PermissionTree;
import su.nightexpress.sunlight.hook.placeholder.PlaceholderRegistry;
import su.nightexpress.sunlight.module.Module;
import su.nightexpress.sunlight.module.ModuleContext;
import su.nightexpress.sunlight.module.warmups.config.WarmupsConfig;
import su.nightexpress.sunlight.module.warmups.config.WarmupsPerms;
import su.nightexpress.sunlight.module.warmups.impl.TeleportWarmup;
import su.nightexpress.sunlight.module.warmups.impl.Warmup;
import su.nightexpress.sunlight.module.warmups.listener.WarmupsListener;
import su.nightexpress.sunlight.module.warps.config.WarpsLang;
import su.nightexpress.sunlight.teleport.TeleportType;

public class WarmupsModule
extends Module {
    private final Map<UUID, Warmup> warmupByIdMap = new ConcurrentHashMap<UUID, Warmup>();

    public WarmupsModule(@NotNull ModuleContext context) {
        super(context);
    }

    @Override
    protected void loadModule(@NotNull FileConfig config) {
        config.initializeOptions(WarmupsConfig.class);
        ((SunLightPlugin)this.plugin).injectLang(WarpsLang.class);
        this.addListener((SimpeListener)new WarmupsListener((SunLightPlugin)this.plugin, this));
        this.addAsyncTask(this::tickWarmups, (Long)WarmupsConfig.WARMUP_TICK_INTERVAL.get());
    }

    @Override
    protected void unloadModule() {
        this.getWarmups().forEach(warmup -> warmup.cancel(true));
        this.warmupByIdMap.clear();
    }

    @Override
    protected void registerPermissions(@NotNull PermissionTree root) {
        root.merge(WarmupsPerms.MODULE);
    }

    @Override
    protected void registerCommands() {
    }

    @Override
    public void registerPlaceholders(@NotNull PlaceholderRegistry registry) {
    }

    private void tickWarmups() {
        this.getWarmups().removeIf(warmup -> {
            this.tickWarmup((Warmup)warmup);
            return warmup.isCompleted();
        });
    }

    private void tickWarmup(@NotNull Warmup warmup) {
        if (((Boolean)WarmupsConfig.WARMUP_CANCEL_ON_MOVE.get()).booleanValue() && warmup.isMoved()) {
            this.cancelWarmup(warmup.getPlayer());
            return;
        }
        warmup.onTick();
        if (warmup.isCompleted()) {
            ((SunLightPlugin)this.plugin).runTask(task -> warmup.complete());
            this.warmupByIdMap.remove(warmup.getPlayer().getUniqueId());
        }
    }

    @Nullable
    public Warmup getWarmup(@NotNull Player player) {
        return this.warmupByIdMap.get(player.getUniqueId());
    }

    public boolean hasWarmup(@NotNull Player player) {
        return this.getWarmup(player) != null;
    }

    @NotNull
    public Set<Warmup> getWarmups() {
        return new HashSet<Warmup>(this.warmupByIdMap.values());
    }

    public boolean canHandleTeleport(@NotNull TeleportType type) {
        return ((Set)WarmupsConfig.TELEPORT_HANDLED_TYPES.get()).contains((Object)type);
    }

    public boolean canHandleTeleport(@NotNull Player player, @NotNull TeleportType type) {
        return !player.hasPermission(WarmupsPerms.BYPASS_TELEPORT) && this.canHandleTeleport(type);
    }

    public void cancelWarmup(@NotNull Player player) {
        this.cancelWarmup(player, false);
    }

    public void cancelWarmup(@NotNull Player player, boolean silent) {
        Warmup warmup = this.warmupByIdMap.remove(player.getUniqueId());
        if (warmup == null) {
            return;
        }
        warmup.cancel(silent);
    }

    public void addWarmup(@NotNull Player player, @NotNull Warmup warmup) {
        if (warmup.getValue() <= 0) {
            warmup.complete();
            return;
        }
        this.cancelWarmup(player, true);
        warmup.init();
        this.warmupByIdMap.put(player.getUniqueId(), warmup);
    }

    public void handleTeleport(@NotNull Player player, @NotNull Location destination, @NotNull TeleportType type, @Nullable Runnable callback) {
        int value = (Integer)((IntRankMap)WarmupsConfig.TELEPORT_WARMUPS_BY_RANK.get()).getSmallest(player);
        TeleportWarmup warmup = new TeleportWarmup(this, player, value, destination, callback);
        this.addWarmup(player, warmup);
    }
}

