/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.vanish.command;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.core.CoreLang;
import su.nightexpress.sunlight.SLPlaceholders;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.mode.ToggleMode;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.vanish.VanishModule;
import su.nightexpress.sunlight.module.vanish.config.VanishLang;
import su.nightexpress.sunlight.module.vanish.config.VanishPerms;
import su.nightexpress.sunlight.user.UserManager;
import su.nightexpress.sunlight.user.property.UserProperty;

public class VanishCommand
extends AbstractCommandProvider {
    private static final String COMMAND_OFF = "off";
    private static final String COMMAND_ON = "on";
    private static final String COMMAND_TOGGLE = "toggle";
    private final VanishModule module;
    private final UserManager userManager;

    public VanishCommand(@NotNull SunLightPlugin plugin, @NotNull VanishModule module, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
    }

    @Override
    protected void loadSettings(@NotNull FileConfig config, @NotNull String path) {
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_TOGGLE, true, new String[]{"vanish"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(VanishLang.COMMAND_VANISH_DESC)).permission(VanishPerms.COMMAND_VANISH)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(VanishPerms.COMMAND_VANISH_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes((context, arguments) -> this.toggleVanish(context, arguments, ToggleMode.TOGGLE)));
    }

    private boolean toggleVanish(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull ToggleMode mode) {
        this.loadUserWithPlayerDataAsync(context, arguments, this.userManager, (user, target) -> {
            UserProperty<Boolean> setting = VanishModule.VANISH;
            boolean state = mode.apply(user.getProperty(setting));
            user.setProperty(setting, state);
            user.markDirty();
            this.module.vanish((Player)target, state);
            if (context.getSender() != target) {
                VanishLang.COMMAND_VANISH_TARGET.message().send(context.getSender(), replacer -> replacer.replace("%state%", (Object)CoreLang.getEnabledOrDisabled((boolean)state)).replace(SLPlaceholders.forPlayer((Player)target)));
            }
            if (!context.hasFlag("s")) {
                VanishLang.COMMAND_VANISH_NOTIFY.message().send((CommandSender)target, replacer -> replacer.replace("%state%", (Object)CoreLang.getEnabledOrDisabled((boolean)state)));
            }
        });
        return true;
    }
}

