/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.tab;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;
import su.nightexpress.sunlight.SLPlaceholders;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.config.PermissionTree;
import su.nightexpress.sunlight.hook.placeholder.PlaceholderRegistry;
import su.nightexpress.sunlight.module.Module;
import su.nightexpress.sunlight.module.ModuleContext;
import su.nightexpress.sunlight.module.tab.TabDefaults;
import su.nightexpress.sunlight.module.tab.TabPlayer;
import su.nightexpress.sunlight.module.tab.TabSettings;
import su.nightexpress.sunlight.module.tab.format.TabLayoutFormat;
import su.nightexpress.sunlight.module.tab.format.TabNameFormat;
import su.nightexpress.sunlight.module.tab.listener.TabListener;
import su.nightexpress.sunlight.utils.DynamicText;

public class TabModule
extends Module {
    private final TabSettings settings = new TabSettings();
    private final Map<String, DynamicText> animationMap = new HashMap<String, DynamicText>();
    private final Map<UUID, TabPlayer> playerMap = new ConcurrentHashMap<UUID, TabPlayer>();

    public TabModule(@NotNull ModuleContext context) {
        super(context);
    }

    @Override
    protected void loadModule(@NotNull FileConfig config) {
        this.settings.load(config);
        this.loadAnimations();
        this.addListener((SimpeListener)new TabListener((SunLightPlugin)this.plugin, this));
        this.addAsyncTask(this::updatePlayerList, this.settings.getPlayerListUpdateInterval());
        this.addAsyncTask(this::sortPlayerList, this.settings.getPlayerListSortInterval());
        Players.getOnline().forEach(this::loadPlayer);
    }

    @Override
    protected void unloadModule() {
        this.animationMap.clear();
        this.playerMap.clear();
    }

    private void loadAnimations() {
        FileConfig config = FileConfig.load((String)this.getSystemPath(), (String)"animations.yml");
        if (config.getSection("").isEmpty()) {
            TabDefaults.getDefaultAnimations().forEach(animator -> animator.write(config, animator.getId()));
        }
        for (String sId : config.getSection("")) {
            DynamicText animator2 = DynamicText.read(config, sId, sId);
            this.animationMap.put(animator2.getId(), animator2);
        }
        config.saveChanges();
    }

    @Override
    protected void registerPermissions(@NotNull PermissionTree root) {
    }

    @Override
    protected void registerCommands() {
    }

    @Override
    public void registerPlaceholders(@NotNull PlaceholderRegistry registry) {
    }

    @NotNull
    public Set<DynamicText> getAnimations() {
        return Set.copyOf(this.animationMap.values());
    }

    @NotNull
    public Set<TabPlayer> getPlayers() {
        return Set.copyOf(this.playerMap.values());
    }

    @Nullable
    public TabPlayer getPlayer(@NotNull UUID playerId) {
        return this.playerMap.get(playerId);
    }

    public synchronized void loadPlayer(@NotNull Player player) {
        PlaceholderContext context = this.createPlaceholderContext(player);
        TabPlayer tabPlayer = new TabPlayer(player, context);
        this.playerMap.put(player.getUniqueId(), tabPlayer);
    }

    public synchronized void unloadPlayer(@NotNull UUID playerId) {
        this.playerMap.remove(playerId);
    }

    @Nullable
    public TabLayoutFormat getPlayerListLayoutFormat(@NotNull Player player) {
        return this.settings.getPlayerListLayoutFormatsMap().values().stream().filter(format -> format.isAvailable(player)).max(Comparator.comparingInt(TabLayoutFormat::getPriority)).orElse(null);
    }

    @Nullable
    public TabNameFormat getPlayerListNameFormat(@NotNull Player player) {
        return this.settings.getPlayerListNameFormatsMap().values().stream().filter(format -> format.isAvailable(player)).max(Comparator.comparingInt(TabNameFormat::getPriority)).orElse(null);
    }

    public void handleJoin(@NotNull PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.loadPlayer(player);
        this.updatePlayerList(player);
        this.sortPlayerList();
    }

    public void handleQuit(@NotNull PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.unloadPlayer(player.getUniqueId());
    }

    public void updatePlayerList(@NotNull TabPlayer tabPlayer) {
        Player player = tabPlayer.getPlayer();
        TabNameFormat nameFormat = this.getPlayerListNameFormat(player);
        TabLayoutFormat layoutFormat = this.getPlayerListLayoutFormat(player);
        tabPlayer.setNameFormat(nameFormat);
        tabPlayer.setLayoutFormat(layoutFormat);
        tabPlayer.updatePlayerList();
    }

    public void updatePlayerList(@NotNull Player player) {
        TabPlayer tabPlayer = this.getPlayer(player.getUniqueId());
        if (tabPlayer == null) {
            return;
        }
        this.updatePlayerList(tabPlayer);
    }

    public void updatePlayerList() {
        this.getPlayers().forEach(this::updatePlayerList);
    }

    public void sortPlayerList() {
        List<Player> sorted = ((SunLightPlugin)this.plugin).getServer().getOnlinePlayers().stream().sorted(Comparator.comparingInt(this::getRankOrder).reversed().thenComparing(Player::getName)).toList();
        if (sorted.isEmpty()) {
            return;
        }
        int size = sorted.size();
        for (int index = 0; index < sorted.size(); ++index) {
            int order = size - index;
            Player player = sorted.get(index);
            player.setPlayerListOrder(order);
        }
    }

    private int getRankOrder(@NotNull Player player) {
        Map<String, Integer> rankOrderMap = this.settings.getPlayerListRankOrderMap();
        int defValue = rankOrderMap.getOrDefault("default", 0);
        Set ranks = Players.getInheritanceGroups((Player)player);
        return ranks.stream().mapToInt(rank -> rankOrderMap.getOrDefault(rank, defValue)).max().orElse(defValue);
    }

    @NotNull
    private PlaceholderContext createPlaceholderContext(@NotNull Player player) {
        PlaceholderContext.Builder builder = PlaceholderContext.builder().with(CommonPlaceholders.PLAYER.resolver((Object)player)).andThen(CommonPlaceholders.forPlaceholderAPI((Player)player));
        for (DynamicText animator : this.getAnimations()) {
            builder.with(SLPlaceholders.ANIMATION.apply(animator.getId()), animator::getMessage);
        }
        return builder.build();
    }
}

