/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.spawns.editor;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.ui.inventory.item.ItemState;
import su.nightexpress.nightcore.ui.inventory.item.MenuItem;
import su.nightexpress.nightcore.ui.inventory.menu.AbstractObjectMenu;
import su.nightexpress.nightcore.ui.inventory.viewer.ViewerContext;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.dialog.DialogRegistry;
import su.nightexpress.sunlight.module.spawns.Spawn;
import su.nightexpress.sunlight.module.spawns.SpawnsModule;
import su.nightexpress.sunlight.module.spawns.config.SpawnsLang;
import su.nightexpress.sunlight.module.spawns.dialog.SpawnsDialogKeys;

public class SpawnSettingsEditor
extends AbstractObjectMenu<Spawn>
implements LangContainer {
    private static final IconLocale ICON_RETURN = LangEntry.iconBuilder((String)"Spawns.Editor.Spawn.Return").accentColor((TagWrapper)TagWrappers.GREEN).name("To Spawns").build();
    private static final IconLocale ICON_RESPAWN_RULES = LangEntry.iconBuilder((String)"Spawns.Editor.Spawn.RespawnRules").name("Respawn Rules").appendCurrent("Status", "%state%").br().appendInfo(new String[]{"Rules controlling which players", "should be moved to this spawn", "on respawn."}).br().appendClick("Click to edit").build();
    private static final IconLocale ICON_LOGIN_RULES = LangEntry.iconBuilder((String)"Spawns.Editor.Spawn.LoginRules").name("Login Rules").appendCurrent("Status", "%state%").br().appendInfo(new String[]{"Rules controlling which players", "should be moved to this spawn", "on join."}).br().appendClick("Click to edit").build();
    private static final IconLocale ICON_PRIORITY = LangEntry.iconBuilder((String)"Spawns.Editor.Spawn.Priority").name("Priority").appendCurrent("Current", "%value%").br().appendInfo(new String[]{"Spawns with greater priority", "will comes first."}).br().appendClick("Click to change").build();
    private static final IconLocale ICON_PERMISSION = LangEntry.iconBuilder((String)"Spawns.Editor.Spawn.PermissionRequirement").name("Permission Requirement").appendCurrent("Status", "%state%").br().appendInfo(new String[]{"Whether permission is required", "to access this spawn."}).br().appendClick("Click to toggle").build();
    private static final IconLocale ICON_LOCATION = LangEntry.iconBuilder((String)"Spawns.Editor.Spawn.Location").name("Location").appendCurrent("Current", TagWrappers.RED.wrap("%spawn_location_x%") + ", " + TagWrappers.GREEN.wrap("%spawn_location_y%") + ", " + TagWrappers.BLUE.wrap("%spawn_location_z%") + " @ " + TagWrappers.WHITE.wrap("%spawn_location_world%")).br().appendClick("Click to override").build();
    private static final IconLocale ICON_NAME = LangEntry.iconBuilder((String)"Spawns.Editor.Spawn.Name").name("Name").appendCurrent("Current", "%name%").br().appendClick("Click to change").build();
    private final SpawnsModule module;
    private final DialogRegistry dialogRegistry;

    public SpawnSettingsEditor(@NotNull SunLightPlugin plugin, @NotNull SpawnsModule module, @NotNull DialogRegistry dialogRegistry) {
        super((MenuType)MenuType.GENERIC_9X4, SpawnsLang.EDITOR_TITLE_SETTINGS.text(), Spawn.class);
        this.module = module;
        this.dialogRegistry = dialogRegistry;
        plugin.injectLang(this);
        this.load(plugin);
    }

    public void registerActions() {
    }

    public void registerConditions() {
    }

    public void defineDefaultLayout() {
        this.addDefaultButton("return", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.ENDER_EYE).localized(ICON_RETURN)).action(context -> this.module.openEditor(context.getPlayer())).build()).slots(new int[]{31}).build());
        this.addDefaultButton("name", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.NAME_TAG).localized(ICON_NAME)).displayModifier((context, item) -> item.replace(builder -> builder.with("%name%", () -> ((Spawn)this.getObject(context)).getName()))).action(context -> this.dialogRegistry.show(context.getPlayer(), SpawnsDialogKeys.SPAWN_NAME, (Spawn)this.getObject((ViewerContext)context), () -> context.getViewer().refresh())).build()).slots(new int[]{10}).build());
        this.addDefaultButton("permission", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.REDSTONE).localized(ICON_PERMISSION)).displayModifier((context, item) -> item.replace(builder -> builder.with("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(((Spawn)this.getObject(context)).isPermissionRequired())))).action(context -> {
            Spawn spawn;
            spawn.setPermissionRequired(!(spawn = (Spawn)this.getObject((ViewerContext)context)).isPermissionRequired());
            spawn.markDirty();
            context.getViewer().refresh();
        }).build()).slots(new int[]{11}).build());
        this.addDefaultButton("priority", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.COMPARATOR).localized(ICON_PRIORITY)).displayModifier((context, item) -> item.replace(builder -> builder.with("%value%", () -> String.valueOf(((Spawn)this.getObject(context)).getPriority())))).action(context -> this.dialogRegistry.show(context.getPlayer(), SpawnsDialogKeys.SPAWN_PRIORITY, (Spawn)this.getObject((ViewerContext)context), () -> context.getViewer().refresh())).build()).slots(new int[]{12}).build());
        this.addDefaultButton("location", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.COMPASS).localized(ICON_LOCATION)).displayModifier((context, item) -> item.replace(builder -> builder.with(((Spawn)this.getObject(context)).placeholders()))).action(context -> {
            Spawn spawn = (Spawn)this.getObject((ViewerContext)context);
            spawn.setLocation(context.getPlayer().getLocation());
            spawn.markDirty();
            context.getViewer().refresh();
        }).build()).slots(new int[]{13}).build());
        this.addDefaultButton("login_rules", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.IRON_DOOR).localized(ICON_LOGIN_RULES)).displayModifier((context, item) -> item.replace(builder -> builder.with("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(((Spawn)this.getObject(context)).getLoginRule().isEnabled())))).action(context -> this.dialogRegistry.show(context.getPlayer(), SpawnsDialogKeys.SPAWN_LOGIN_RULES, (Spawn)this.getObject((ViewerContext)context), () -> context.getViewer().refresh())).build()).slots(new int[]{14}).build());
        this.addDefaultButton("respawn_rules", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.RED_BED).localized(ICON_RESPAWN_RULES)).displayModifier((context, item) -> item.replace(builder -> builder.with("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(((Spawn)this.getObject(context)).getRespawnRule().isEnabled())))).action(context -> this.dialogRegistry.show(context.getPlayer(), SpawnsDialogKeys.SPAWN_RESPAWN_RULES, (Spawn)this.getObject((ViewerContext)context), () -> context.getViewer().refresh())).build()).slots(new int[]{15}).build());
    }

    protected void onLoad(@NotNull FileConfig config) {
    }

    protected void onClick(@NotNull ViewerContext context, @NotNull InventoryClickEvent event) {
    }

    protected void onDrag(@NotNull ViewerContext context, @NotNull InventoryDragEvent event) {
    }

    protected void onClose(@NotNull ViewerContext context, @NotNull InventoryCloseEvent event) {
    }

    public void onPrepare(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory, @NotNull List<MenuItem> items) {
    }

    public void onReady(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }

    public void onRender(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }
}

