/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.spawns.dialog.impl;

import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.sunlight.dialog.Dialog;
import su.nightexpress.sunlight.module.spawns.Spawn;

public class SpawnPriorityDialog
extends Dialog<Spawn> {
    private static final TextLocale TITLE = LangEntry.builder((String)"Spawns.Dialog.SpawnPriority.Title").text(SpawnPriorityDialog.title("Spawn", "Priority"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Spawns.Dialog.SpawnPriority.Body").dialogElement(400, new String[]{"Enter spawn priority."});
    private static final TextLocale INPUT_PRIORITY = LangEntry.builder((String)"Spawns.Dialog.SpawnPriority.Input.Priority").text("Priority");
    private static final String JSON_PRIORITY = "priority";

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Spawn spawn) {
        return Dialogs.builder().base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.text((String)JSON_PRIORITY, (TextLocale)INPUT_PRIORITY).initial(String.valueOf(spawn.getPriority())).maxLength(6).build()}).build()).type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build()).handleResponse("ok", (viewer, identifier, nbtHolder) -> {
            if (nbtHolder == null) {
                return;
            }
            int priority = nbtHolder.getInt(JSON_PRIORITY, spawn.getPriority());
            spawn.setPriority(priority);
            spawn.markDirty();
            viewer.callback();
        }).build();
    }
}

