/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.spawns.command;

import java.util.Optional;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.Commands;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.commands.exceptions.CommandSyntaxException;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.spawns.Spawn;
import su.nightexpress.sunlight.module.spawns.SpawnsModule;
import su.nightexpress.sunlight.module.spawns.config.SpawnsLang;
import su.nightexpress.sunlight.module.spawns.config.SpawnsPerms;
import su.nightexpress.sunlight.user.UserManager;

public class SpawnCommands
extends AbstractCommandProvider {
    private static final String COMMAND_CREATE = "spawn_create";
    private static final String COMMAND_DELETE = "spawn_delete";
    private static final String COMMAND_EDITOR = "spawn_editor";
    private static final String COMMAND_TELEPORT = "spawn_teleport";
    public static final String DEF_EDITOR_ALIAS = "editspawn";
    private final SpawnsModule module;
    private final UserManager userManager;

    public SpawnCommands(@NotNull SunLightPlugin plugin, @NotNull SpawnsModule module, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_CREATE, true, new String[]{"setspawn"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(SpawnsLang.COMMAND_SPAWN_SET_DESC)).permission(SpawnsPerms.COMMAND_SPAWNS_CREATE)).withArguments(new ArgumentNodeBuilder[]{Arguments.string((String)"name").localized(CoreLang.COMMAND_ARGUMENT_NAME_NAME).suggestions((reader, context) -> this.module.getSpawnIds())}).executes(this::setSpawn));
        this.registerLiteral(COMMAND_DELETE, true, new String[]{"delspawn"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(SpawnsLang.COMMAND_SPAWN_DELETE_DESC)).permission(SpawnsPerms.COMMAND_SPAWNS_DELETE)).withArguments(new ArgumentNodeBuilder[]{this.spawnArgument()}).executes(this::deleteSpawn));
        this.registerLiteral(COMMAND_EDITOR, true, new String[]{DEF_EDITOR_ALIAS}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)builder.playerOnly()).description(SpawnsLang.COMMAND_SPAWN_EDITOR_DESC)).permission(SpawnsPerms.COMMAND_SPAWNS_EDITOR)).executes(this::openEditor));
        this.registerLiteral(COMMAND_TELEPORT, true, new String[]{"spawn"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(SpawnsLang.COMMAND_SPAWN_TELEPORT_DESC)).permission(SpawnsPerms.COMMAND_SPAWNS_TELEPORT)).withArguments(new ArgumentNodeBuilder[]{this.spawnArgument().optional(), ((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(SpawnsPerms.COMMAND_SPAWNS_TELEPORT_OTHERS)).optional()}).withFlags(new String[]{"s", "f"}).executes(this::teleport));
    }

    @NotNull
    private ArgumentNodeBuilder<Spawn> spawnArgument() {
        return Commands.argument((String)"name", (context, str) -> Optional.ofNullable(this.module.getSpawn(str)).orElseThrow(() -> CommandSyntaxException.custom((MessageLocale)SpawnsLang.COMMAND_SYNTAX_INVALID_SPAWN))).localized(CoreLang.COMMAND_ARGUMENT_NAME_NAME).suggestions((reader, context) -> this.module.getSpawnIds());
    }

    private boolean setSpawn(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        String spawnId = arguments.getString("name", "default");
        return this.module.createSpawn(player, spawnId);
    }

    private boolean deleteSpawn(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Spawn spawn = (Spawn)arguments.get("name", Spawn.class);
        this.module.sendPrefixed(SpawnsLang.SPAWN_DELETE_FEEDBACK, context.getSender(), replacer -> replacer.with(spawn.placeholders()));
        return this.module.deleteSpawn(spawn);
    }

    private boolean openEditor(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        this.module.openEditor(player);
        return true;
    }

    private boolean teleport(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Spawn spawn;
        Spawn spawn2 = spawn = arguments.contains("name") ? (Spawn)arguments.get("name", Spawn.class) : this.module.getDefaultSpawn();
        if (spawn == null) {
            this.module.sendPrefixed(SpawnsLang.ERROR_NO_DEFAULT_SPAWN, context.getSender());
            return false;
        }
        return this.performForTargetOrSenderSync(context, arguments, this.userManager, target -> {
            boolean silent;
            boolean force = arguments.contains("f");
            if (!this.module.teleport(spawn, (Player)target, force, silent = arguments.contains("s"))) {
                return;
            }
            if (force) {
                this.module.sendPrefixed(SpawnsLang.SPAWN_TELEPORT_FEEDBACK, context.getSender(), replacer -> replacer.with(spawn.placeholders()).with(CommonPlaceholders.PLAYER.resolver(target)));
            }
        });
    }
}

