/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.scoreboard.board.impl;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.score.ScoreFormat;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDisplayScoreboard;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerResetScore;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerScoreboardObjective;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateScore;
import io.github.retrooper.packetevents.adventure.serializer.gson.GsonComponentSerializer;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.bridge.paper.PaperBridge;
import su.nightexpress.nightcore.util.Version;
import su.nightexpress.nightcore.util.bridge.Software;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;
import su.nightexpress.nightcore.util.text.night.NightMessage;
import su.nightexpress.sunlight.module.scoreboard.board.BoardDefinition;
import su.nightexpress.sunlight.module.scoreboard.board.impl.AbstractBoard;

public class PacketBoard
extends AbstractBoard<PacketWrapper<?>> {
    public PacketBoard(@NotNull Player player, @NotNull PlaceholderContext placeholderContext, @NotNull BoardDefinition boardDefinition) {
        super(player, placeholderContext, boardDefinition);
    }

    @Override
    @NotNull
    protected WrapperPlayServerScoreboardObjective createObjectivePacket(AbstractBoard.ObjectiveMode mode, @NotNull String displayName) {
        WrapperPlayServerScoreboardObjective.ObjectiveMode objectiveMode = switch (mode) {
            default -> throw new MatchException(null, null);
            case AbstractBoard.ObjectiveMode.CREATE -> WrapperPlayServerScoreboardObjective.ObjectiveMode.CREATE;
            case AbstractBoard.ObjectiveMode.REMOVE -> WrapperPlayServerScoreboardObjective.ObjectiveMode.REMOVE;
            case AbstractBoard.ObjectiveMode.UPDATE -> WrapperPlayServerScoreboardObjective.ObjectiveMode.UPDATE;
        };
        return new WrapperPlayServerScoreboardObjective(this.identifier, objectiveMode, PacketBoard.adaptComponent(displayName), WrapperPlayServerScoreboardObjective.RenderType.INTEGER, (ScoreFormat)ScoreFormat.blankScore());
    }

    @Override
    @NotNull
    protected WrapperPlayServerResetScore createResetScorePacket(@NotNull String scoreId) {
        return new WrapperPlayServerResetScore(scoreId, this.identifier);
    }

    @Override
    @NotNull
    protected WrapperPlayServerUpdateScore createScorePacket(@NotNull String scoreId, int score, @NotNull String text) {
        WrapperPlayServerUpdateScore scorePacket = new WrapperPlayServerUpdateScore(scoreId, WrapperPlayServerUpdateScore.Action.CREATE_OR_UPDATE_ITEM, this.identifier, Optional.of(score));
        scorePacket.setEntityDisplayName(PacketBoard.adaptComponent(text));
        scorePacket.setScoreFormat((ScoreFormat)ScoreFormat.blankScore());
        return scorePacket;
    }

    @Override
    @NotNull
    protected WrapperPlayServerDisplayScoreboard createDisplayPacket() {
        return new WrapperPlayServerDisplayScoreboard(1, this.identifier);
    }

    @Override
    protected void sendPacket(@NotNull Player player, @NotNull PacketWrapper<?> wrapper) {
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, wrapper);
    }

    @NotNull
    private static Component adaptComponent(@NotNull String string) {
        if (Version.isPaper()) {
            return ((PaperBridge)Software.get()).getTextComponentAdapter().adaptComponent(NightMessage.parse((String)string));
        }
        return GsonComponentSerializer.gson().deserialize((Object)NightMessage.asJson((String)string));
    }
}

