/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.scheduler.announcer;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.random.Rnd;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.module.scheduler.announcer.AnnouncerSchema;

public class Announcer {
    private final int interval;
    private final boolean randomOrder;
    private final Set<String> ranks;
    private final Map<String, List<String>> texts;
    private final Set<String> usedTexts;

    public Announcer(int interval, boolean randomOrder, @NotNull Set<String> ranks, @NotNull Map<String, List<String>> texts) {
        this.interval = interval;
        this.randomOrder = randomOrder;
        this.ranks = ranks.stream().map(String::toLowerCase).collect(Collectors.toSet());
        this.texts = texts;
        this.usedTexts = new HashSet<String>();
    }

    @NotNull
    public static Announcer fromFile(@NotNull Path path) {
        FileConfig config = FileConfig.load((Path)path);
        int interval = (Integer)AnnouncerSchema.INTERVAL.resolveWithDefaults(config);
        boolean randomOrder = (Boolean)AnnouncerSchema.RANDOM_ORDER.resolveWithDefaults(config);
        Set ranks = (Set)AnnouncerSchema.RANKS.resolveWithDefaults(config);
        Map texts = (Map)AnnouncerSchema.TEXTS.resolveWithDefaults(config);
        config.saveChanges();
        return new Announcer(interval, randomOrder, ranks, texts);
    }

    public void writeToFile(@NotNull Path path) {
        FileConfig.load((Path)path).edit(config -> {
            AnnouncerSchema.INTERVAL.writeValue(config, (Object)this.interval);
            AnnouncerSchema.RANDOM_ORDER.writeValue(config, (Object)this.randomOrder);
            AnnouncerSchema.RANKS.writeValue(config, this.ranks);
            AnnouncerSchema.TEXTS.writeValue(config, this.texts);
        });
    }

    public boolean canSee(@NotNull Player player) {
        if (this.ranks.contains("*")) {
            return true;
        }
        Set groups = Players.getInheritanceGroups((Player)player);
        return this.ranks.stream().anyMatch(groups::contains);
    }

    @Nullable
    public String selectMessage() {
        if (this.texts.isEmpty()) {
            return null;
        }
        if (this.usedTexts.size() >= this.texts.size()) {
            this.usedTexts.clear();
        }
        ArrayList<String> freeTexts = new ArrayList<String>();
        for (String key : this.texts.keySet()) {
            if (this.usedTexts.contains(key)) continue;
            freeTexts.add(key);
            if (this.randomOrder) continue;
            break;
        }
        if (freeTexts.isEmpty()) {
            return null;
        }
        String index = this.randomOrder ? (String)Rnd.get(freeTexts) : (String)freeTexts.getFirst();
        this.usedTexts.add(index);
        return String.join((CharSequence)TagWrappers.BR, (Iterable<? extends CharSequence>)this.texts.get(index));
    }

    public int getInterval() {
        return this.interval;
    }

    public boolean isRandomOrder() {
        return this.randomOrder;
    }

    @NotNull
    public Set<String> getRanks() {
        return Set.copyOf(this.ranks);
    }

    @NotNull
    public Map<String, List<String>> getTexts() {
        return Map.copyOf(this.texts);
    }
}

