/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.ptp.request;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.sunlight.module.ptp.request.TeleportMode;

public class TeleportRequest {
    private final UUID targetId;
    private final UUID senderId;
    private final TeleportMode mode;
    private long expireDate;

    public TeleportRequest(@NotNull Player sender, @NotNull Player target, @NotNull TeleportMode mode, int timeOut) {
        this(sender.getUniqueId(), target.getUniqueId(), mode, timeOut);
    }

    public TeleportRequest(@NotNull UUID senderId, @NotNull UUID targetId, @NotNull TeleportMode mode, int timeOut) {
        this.senderId = senderId;
        this.targetId = targetId;
        this.mode = mode;
        this.expireDate = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(timeOut, TimeUnit.SECONDS);
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.expireDate;
    }

    public void setExpired() {
        this.expireDate = System.currentTimeMillis();
    }

    public boolean isSender(@NotNull String name) {
        return Players.getPlayer((String)name) == this.getSender();
    }

    public boolean isTarget(@NotNull String name) {
        return Players.getPlayer((String)name) == this.getTarget();
    }

    @Nullable
    public Player getSender() {
        return Bukkit.getPlayer((UUID)this.senderId);
    }

    @Nullable
    public Player getTarget() {
        return Bukkit.getPlayer((UUID)this.targetId);
    }

    @NotNull
    public UUID getSenderId() {
        return this.senderId;
    }

    @NotNull
    public UUID getTargetId() {
        return this.targetId;
    }

    @NotNull
    public TeleportMode getMode() {
        return this.mode;
    }

    public long getExpireDate() {
        return this.expireDate;
    }
}

