/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.ptp.command;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.mode.ToggleMode;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.ptp.PTPModule;
import su.nightexpress.sunlight.module.ptp.PTPProperties;
import su.nightexpress.sunlight.module.ptp.config.PTPLang;
import su.nightexpress.sunlight.module.ptp.config.PTPPerms;
import su.nightexpress.sunlight.module.ptp.request.TeleportMode;
import su.nightexpress.sunlight.module.ptp.request.TeleportRequest;
import su.nightexpress.sunlight.user.SunUser;
import su.nightexpress.sunlight.user.UserManager;

public class PTPCommands
extends AbstractCommandProvider {
    private static final String COMMAND_OFF = "off";
    private static final String COMMAND_ON = "on";
    private static final String COMMAND_TOGGLE = "toggle";
    private static final String COMMAND_ACCEPT = "ptp_accept";
    private static final String COMMAND_DECLINE = "ptp_decline";
    private static final String COMMAND_REQUEST = "request";
    private static final String COMMAND_INVITE = "invite";
    public static final String ACCEPT_NAME = "tpyes";
    public static final String DECLINE_NAME = "tpno";
    private final PTPModule module;
    private final UserManager userManager;

    public PTPCommands(@NotNull SunLightPlugin plugin, PTPModule module, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_ACCEPT, true, new String[]{ACCEPT_NAME}, builder -> {
            builder.description(PTPLang.COMMAND_ACCEPT_DESC);
            builder.permission(PTPPerms.COMMAND_ACCEPT);
            this.builderAccept((LiteralNodeBuilder)builder, true);
        });
        this.registerLiteral(COMMAND_DECLINE, true, new String[]{DECLINE_NAME}, builder -> {
            builder.description(PTPLang.COMMAND_DECLINE_DESC);
            builder.permission(PTPPerms.COMMAND_DECLINE);
            this.builderAccept((LiteralNodeBuilder)builder, false);
        });
        this.registerLiteral(COMMAND_REQUEST, true, new String[]{"tpa", "call"}, builder -> {
            builder.description(PTPLang.COMMAND_REQUEST_DESC);
            builder.permission(PTPPerms.COMMAND_REQUEST);
            this.buildRequest((LiteralNodeBuilder)builder, TeleportMode.REQUEST);
        });
        this.registerLiteral(COMMAND_INVITE, true, new String[]{"tpahere", "tpi"}, builder -> {
            builder.description(PTPLang.COMMAND_INVITE_DESC);
            builder.permission(PTPPerms.COMMAND_INVITE);
            this.buildRequest((LiteralNodeBuilder)builder, TeleportMode.INVITE);
        });
        this.registerLiteral(COMMAND_TOGGLE, true, new String[]{"tptoggle"}, builder -> this.buildRequests((LiteralNodeBuilder)builder, ToggleMode.TOGGLE));
        this.registerLiteral(COMMAND_ON, true, new String[]{"tptoggle-on"}, builder -> this.buildRequests((LiteralNodeBuilder)builder, ToggleMode.ON));
        this.registerLiteral(COMMAND_OFF, true, new String[]{"tptoggle-off"}, builder -> this.buildRequests((LiteralNodeBuilder)builder, ToggleMode.OFF));
        this.registerRoot("ptp", true, new String[]{"ptp"}, (Map<String, String> map) -> {
            map.put(COMMAND_REQUEST, COMMAND_REQUEST);
            map.put(COMMAND_INVITE, COMMAND_INVITE);
            map.put(COMMAND_ACCEPT, "accept");
            map.put(COMMAND_DECLINE, "decline");
            map.put(COMMAND_TOGGLE, COMMAND_TOGGLE);
        }, (HubNodeBuilder builder) -> ((HubNodeBuilder)builder.description(PTPLang.COMMAND_PTP_DESC)).permission(PTPPerms.COMMAND_ROOT));
    }

    private void builderAccept(@NotNull LiteralNodeBuilder builder, boolean accept) {
        ((LiteralNodeBuilder)builder.playerOnly()).withArguments(new ArgumentNodeBuilder[]{Arguments.playerName((String)"player").suggestions((reader, context) -> {
            CommandSender patt0$temp = context.getSender();
            if (!(patt0$temp instanceof Player)) {
                return Collections.emptyList();
            }
            Player player = (Player)patt0$temp;
            return this.module.getRequests(player).stream().map(TeleportRequest::getSender).filter(Objects::nonNull).map(Player::getName).toList();
        })}).executes((context, arguments) -> this.acceptOrDecline(context, arguments, accept));
    }

    private void buildRequest(@NotNull LiteralNodeBuilder builder, @NotNull TeleportMode mode) {
        ((LiteralNodeBuilder)builder.playerOnly()).withArguments(new ArgumentNodeBuilder[]{Arguments.player((String)"player")}).executes((context, arguments) -> this.sendRequest(context, arguments, mode));
    }

    private void buildRequests(@NotNull LiteralNodeBuilder builder, @NotNull ToggleMode mode) {
        TextLocale description = switch (mode) {
            default -> throw new MatchException(null, null);
            case ToggleMode.TOGGLE -> PTPLang.COMMAND_REQUESTS_TOGGLE_DESC;
            case ToggleMode.ON -> PTPLang.COMMAND_REQUESTS_ON_DESC;
            case ToggleMode.OFF -> PTPLang.COMMAND_REQUESTS_OFF_DESC;
        };
        ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(description)).permission(PTPPerms.COMMAND_REQUESTS)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.playerName((String)"player").permission(PTPPerms.COMMAND_REQUESTS_OTHERS)).optional()}).withFlags(new String[]{"s"}).executes((context, arguments) -> this.toggleRequests(context, arguments, mode));
    }

    private boolean acceptOrDecline(@NotNull CommandContext context, @NotNull ParsedArguments arguments, boolean accept) {
        Player player = context.getPlayerOrThrow();
        String from = arguments.contains("player") ? arguments.getString("player") : null;
        return accept ? this.module.accept(player, from) : this.module.decline(player, from);
    }

    private boolean sendRequest(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull TeleportMode mode) {
        Player target;
        Player player = context.getPlayerOrThrow();
        if (player == (target = arguments.getPlayer("player"))) {
            this.module.sendPrefixed(CoreLang.COMMAND_EXECUTION_NOT_YOURSELF, context.getSender());
            return false;
        }
        return this.module.sendRequest(player, target, mode);
    }

    private boolean toggleRequests(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull ToggleMode mode) {
        String playerName = arguments.getString("player", context.getSender().getName());
        this.userManager.loadByNameAsync(playerName).thenCompose(userOptional -> {
            SunUser user = userOptional.orElse(null);
            if (user == null) {
                context.errorBadPlayer();
                return CompletableFuture.completedFuture(null);
            }
            return this.userManager.loadTargetPlayer(user).thenAcceptAsync(target -> {
                boolean state = mode.apply(user.getProperty(PTPProperties.TELEPORT_REQUESTS));
                user.setProperty(PTPProperties.TELEPORT_REQUESTS, state);
                user.markDirty();
                if (context.getSender() != target) {
                    this.module.sendPrefixed(PTPLang.COMMAND_TOGGLE_DONE, context.getSender(), replacer -> replacer.with(CommonPlaceholders.PLAYER.resolver(target)).with("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(state)));
                }
                if (!context.hasFlag("s")) {
                    this.module.sendPrefixed(PTPLang.COMMAND_TOGGLE_NOTIFY, (CommandSender)target, replacer -> replacer.with("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(state)));
                }
            }, arg_0 -> ((SunLightPlugin)this.plugin).runTask(arg_0));
        });
        return true;
    }
}

