/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.ptp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;
import su.nightexpress.nightcore.util.time.TimeFormatType;
import su.nightexpress.nightcore.util.time.TimeFormats;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.api.event.PlayerTeleportRequestEvent;
import su.nightexpress.sunlight.config.PermissionTree;
import su.nightexpress.sunlight.hook.placeholder.PlaceholderRegistry;
import su.nightexpress.sunlight.module.Module;
import su.nightexpress.sunlight.module.ModuleContext;
import su.nightexpress.sunlight.module.ptp.PTPProperties;
import su.nightexpress.sunlight.module.ptp.command.PTPCommands;
import su.nightexpress.sunlight.module.ptp.config.PTPLang;
import su.nightexpress.sunlight.module.ptp.config.PTPPerms;
import su.nightexpress.sunlight.module.ptp.config.PTPSettings;
import su.nightexpress.sunlight.module.ptp.listener.PTPListener;
import su.nightexpress.sunlight.module.ptp.request.TeleportMode;
import su.nightexpress.sunlight.module.ptp.request.TeleportRequest;
import su.nightexpress.sunlight.teleport.TeleportFlag;
import su.nightexpress.sunlight.teleport.TeleportFlags;
import su.nightexpress.sunlight.teleport.TeleportManager;
import su.nightexpress.sunlight.teleport.TeleportType;
import su.nightexpress.sunlight.user.SunUser;
import su.nightexpress.sunlight.user.property.UserPropertyRegistry;

public class PTPModule
extends Module {
    private final TeleportManager teleportManager;
    private final PTPSettings settings;
    private final Map<UUID, List<TeleportRequest>> requestsMap;

    public PTPModule(@NotNull ModuleContext context, @NotNull TeleportManager teleportManager) {
        super(context);
        this.teleportManager = teleportManager;
        this.settings = new PTPSettings();
        this.requestsMap = new HashMap<UUID, List<TeleportRequest>>();
    }

    @Override
    protected void loadModule(@NotNull FileConfig config) {
        this.settings.load(config);
        ((SunLightPlugin)this.plugin).injectLang(PTPLang.class);
        UserPropertyRegistry.register(PTPProperties.TELEPORT_REQUESTS);
        this.addListener((SimpeListener)new PTPListener((SunLightPlugin)this.plugin, this));
    }

    @Override
    protected void unloadModule() {
        this.requestsMap.clear();
    }

    @Override
    protected void registerPermissions(@NotNull PermissionTree root) {
        root.merge(PTPPerms.MODULE);
    }

    @Override
    protected void registerCommands() {
        this.commandRegistry.addProvider("ptp", new PTPCommands((SunLightPlugin)this.plugin, this, this.userManager));
    }

    @Override
    public void registerPlaceholders(@NotNull PlaceholderRegistry registry) {
        registry.register("ptp_requests_enabled", (player, payload) -> CoreLang.STATE_YES_NO.get(this.isRequestsEnabled(player)));
    }

    @NotNull
    public Map<UUID, List<TeleportRequest>> getRequestsMap() {
        return this.requestsMap;
    }

    @NotNull
    public List<TeleportRequest> getRequests(@NotNull Player player) {
        return this.getRequests(player.getUniqueId());
    }

    @NotNull
    public List<TeleportRequest> getRequests(@NotNull UUID playerId) {
        List requests = this.requestsMap.computeIfAbsent(playerId, k -> new ArrayList());
        requests.removeIf(TeleportRequest::isExpired);
        return requests;
    }

    @Nullable
    public TeleportRequest getPlayerRequest(@NotNull Player player, @NotNull String name) {
        return this.getPlayerRequest(player.getUniqueId(), name);
    }

    @Nullable
    public TeleportRequest getPlayerRequest(@NotNull UUID playerId, @NotNull String name) {
        return this.getRequests(playerId).stream().filter(request -> request.isSender(name)).findFirst().orElse(null);
    }

    @Nullable
    public TeleportRequest getLatest(@NotNull Player player) {
        return this.getLatest(player.getUniqueId());
    }

    @Nullable
    public TeleportRequest getLatest(@NotNull UUID playerId) {
        List<TeleportRequest> requests = this.getRequests(playerId);
        return requests.isEmpty() ? null : requests.getLast();
    }

    public void clearRequests(@NotNull Player player) {
        this.clearRequests(player.getUniqueId());
    }

    public void clearRequests(@NotNull UUID playerId) {
        this.requestsMap.remove(playerId);
    }

    public boolean isRequestsEnabled(@NotNull Player player) {
        return ((SunUser)this.userManager.getOrFetch(player)).getProperty(PTPProperties.TELEPORT_REQUESTS);
    }

    public boolean sendRequest(@NotNull Player player, @NotNull Player target, @NotNull TeleportMode mode) {
        if (!this.isRequestsEnabled(target) && !player.hasPermission(PTPPerms.BYPASS_REQUESTS_DISABLED)) {
            this.sendPrefixed(PTPLang.REQUEST_SEND_ERROR_DISABLED, (CommandSender)player, (PlaceholderContext.Builder builder) -> builder.with(CommonPlaceholders.PLAYER.resolver((Object)target)));
            return false;
        }
        TeleportRequest requestHas = this.getPlayerRequest(target, player.getName());
        if (requestHas != null && !requestHas.isExpired()) {
            this.sendPrefixed(PTPLang.REQUEST_SEND_ERROR_COOLDOWN, (CommandSender)player, (PlaceholderContext.Builder builder) -> builder.with("%time%", () -> TimeFormats.formatDuration((long)requestHas.getExpireDate(), (TimeFormatType)TimeFormatType.LITERAL)));
            return false;
        }
        TeleportRequest request = new TeleportRequest(player, target, mode, this.settings.getRequestTimeout());
        PlayerTeleportRequestEvent eventTeleport = new PlayerTeleportRequestEvent(request);
        ((SunLightPlugin)this.plugin).getPluginManager().callEvent((Event)eventTeleport);
        if (eventTeleport.isCancelled()) {
            return false;
        }
        this.getRequests(target).add(request);
        this.sendPrefixed(mode == TeleportMode.REQUEST ? PTPLang.REQUEST_NOTIFY : PTPLang.INVITE_NOTIFY, (CommandSender)target, (PlaceholderContext.Builder builder) -> builder.with(CommonPlaceholders.PLAYER.resolver((Object)player)));
        this.sendPrefixed(mode == TeleportMode.REQUEST ? PTPLang.REQUEST_SENT : PTPLang.INVITE_SENT, (CommandSender)player, (PlaceholderContext.Builder builder) -> builder.with(CommonPlaceholders.PLAYER.resolver((Object)target)));
        return true;
    }

    public boolean accept(@NotNull Player player, @Nullable String name) {
        TeleportRequest request;
        TeleportRequest teleportRequest = request = name == null ? this.getLatest(player) : this.getPlayerRequest(player, name);
        if (request == null) {
            this.sendPrefixed(PTPLang.REQUEST_ACCEPT_NOTHING, (CommandSender)player);
            return false;
        }
        Player sender = request.getSender();
        if (sender == null) {
            this.sendPrefixed(CoreLang.ERROR_INVALID_PLAYER, (CommandSender)player);
            return false;
        }
        Player teleporter = request.getMode() == TeleportMode.INVITE ? player : sender;
        Location destination = request.getMode() == TeleportMode.INVITE ? sender.getLocation() : player.getLocation();
        request.setExpired();
        TeleportFlags flags = TeleportFlags.of(TeleportFlag.LOOK_FOR_SURFACE, TeleportFlag.AVOID_LAVA);
        this.teleportManager.teleport(teleporter, destination, TeleportType.PTP, flags, () -> {
            this.sendPrefixed(PTPLang.REQUEST_ACCEPT_DONE, (CommandSender)player, (PlaceholderContext.Builder builder) -> builder.with(CommonPlaceholders.PLAYER.resolver((Object)sender)));
            this.sendPrefixed(PTPLang.REQUEST_ACCEPT_NOTIFY, (CommandSender)sender, (PlaceholderContext.Builder builder) -> builder.with(CommonPlaceholders.PLAYER.resolver((Object)player)));
        });
        return true;
    }

    public boolean decline(@NotNull Player player, @Nullable String name) {
        TeleportRequest request;
        TeleportRequest teleportRequest = request = name == null ? this.getLatest(player) : this.getPlayerRequest(player, name);
        if (request == null) {
            this.sendPrefixed(PTPLang.REQUEST_ACCEPT_NOTHING, (CommandSender)player);
            return false;
        }
        Player sender = request.getSender();
        if (sender == null) {
            this.sendPrefixed(CoreLang.ERROR_INVALID_PLAYER, (CommandSender)player);
            return false;
        }
        request.setExpired();
        this.sendPrefixed(PTPLang.REQUEST_DECLINE_DONE, (CommandSender)player, (PlaceholderContext.Builder builder) -> builder.with(CommonPlaceholders.PLAYER.resolver((Object)sender)));
        this.sendPrefixed(PTPLang.REQUEST_DECLINE_NOTIFY, (CommandSender)sender, (PlaceholderContext.Builder builder) -> builder.with(CommonPlaceholders.PLAYER.resolver((Object)player)));
        return true;
    }
}

