/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.nerfphantoms.command;

import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.mode.ToggleMode;
import su.nightexpress.sunlight.command.provider.type.AbstractCommandProvider;
import su.nightexpress.sunlight.module.nerfphantoms.PhantomsModule;
import su.nightexpress.sunlight.module.nerfphantoms.PhantomsProperties;
import su.nightexpress.sunlight.module.nerfphantoms.config.PhantomsLang;
import su.nightexpress.sunlight.module.nerfphantoms.config.PhantomsPerms;
import su.nightexpress.sunlight.user.SunUser;
import su.nightexpress.sunlight.user.UserManager;

public class PhantomsCommandProvider
extends AbstractCommandProvider {
    private static final String COMMAND_TOGGLE = "toggle";
    private final PhantomsModule module;
    private final UserManager userManager;

    public PhantomsCommandProvider(@NotNull SunLightPlugin plugin, @NotNull PhantomsModule module, @NotNull UserManager userManager) {
        super(plugin);
        this.module = module;
        this.userManager = userManager;
    }

    @Override
    protected void loadSettings(@NotNull FileConfig config, @NotNull String path) {
    }

    @Override
    public void registerDefaults() {
        this.registerLiteral(COMMAND_TOGGLE, true, new String[]{"phantoms"}, builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(PhantomsLang.COMMAND_PHANTOMS_TOGGLE_DESC)).permission(PhantomsPerms.COMMAND_PHANTOMS_TOGGLE)).withArguments(new ArgumentNodeBuilder[]{(ArgumentNodeBuilder)Arguments.playerName((String)"player").optional().permission(PhantomsPerms.COMMAND_PHANTOMS_TOGGLE_OTHERS)}).withFlags(new String[]{"s"}).executes((context, arguments) -> this.togglePhantoms(context, arguments, ToggleMode.TOGGLE)));
    }

    private boolean togglePhantoms(@NotNull CommandContext context, @NotNull ParsedArguments arguments, @NotNull ToggleMode mode) {
        String playerName = arguments.getString("player", context.getSender().getName());
        this.userManager.loadByNameAsync(playerName).thenCompose(userOptional -> {
            SunUser user = userOptional.orElse(null);
            if (user == null) {
                context.errorBadPlayer();
                return CompletableFuture.completedFuture(null);
            }
            return this.userManager.loadTargetPlayer(user).thenAcceptAsync(target -> {
                boolean state = mode.apply(user.getProperty(PhantomsProperties.ANTI_PHANTOM));
                user.setProperty(PhantomsProperties.ANTI_PHANTOM, state);
                user.markDirty();
                if (context.getSender() != target) {
                    this.module.sendPrefixed(PhantomsLang.COMMAND_NO_PHANTOM_TOGGLE_OTHERS, context.getSender(), builder -> builder.with("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(state)).with(CommonPlaceholders.PLAYER.resolver(target)));
                }
                if (!context.hasFlag("s")) {
                    this.module.sendPrefixed(PhantomsLang.COMMAND_NO_PHANTOM_TOGGLE_NOTIFY, (CommandSender)target, replacer -> replacer.with("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(state)));
                }
            }, arg_0 -> ((SunLightPlugin)this.plugin).runTask(arg_0));
        });
        return true;
    }
}

