/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.nerfphantoms;

import org.bukkit.Statistic;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.config.PermissionTree;
import su.nightexpress.sunlight.hook.placeholder.PlaceholderRegistry;
import su.nightexpress.sunlight.module.Module;
import su.nightexpress.sunlight.module.ModuleContext;
import su.nightexpress.sunlight.module.nerfphantoms.PhantomsProperties;
import su.nightexpress.sunlight.module.nerfphantoms.command.PhantomsCommandProvider;
import su.nightexpress.sunlight.module.nerfphantoms.config.PhantomsConfig;
import su.nightexpress.sunlight.module.nerfphantoms.config.PhantomsLang;
import su.nightexpress.sunlight.module.nerfphantoms.config.PhantomsPerms;
import su.nightexpress.sunlight.module.nerfphantoms.listener.PhantomsListener;
import su.nightexpress.sunlight.user.SunUser;
import su.nightexpress.sunlight.user.property.UserPropertyRegistry;

public class PhantomsModule
extends Module {
    public PhantomsModule(@NotNull ModuleContext context) {
        super(context);
    }

    @Override
    protected void loadModule(@NotNull FileConfig config) {
        config.initializeOptions(PhantomsConfig.class);
        ((SunLightPlugin)this.plugin).injectLang(PhantomsLang.class);
        UserPropertyRegistry.register(PhantomsProperties.ANTI_PHANTOM);
        this.addListener((SimpeListener)new PhantomsListener((SunLightPlugin)this.plugin, this));
        this.addAsyncTask(this::resetRestTime, 600);
    }

    @Override
    protected void unloadModule() {
    }

    @Override
    protected void registerPermissions(@NotNull PermissionTree root) {
        root.merge(PhantomsPerms.ROOT);
    }

    @Override
    protected void registerCommands() {
        this.commandRegistry.addProvider("nophantom", new PhantomsCommandProvider((SunLightPlugin)this.plugin, this, this.userManager));
    }

    @Override
    public void registerPlaceholders(@NotNull PlaceholderRegistry registry) {
        registry.register("nophantom_state", (player, payload) -> CoreLang.STATE_YES_NO.get(((SunUser)this.userManager.getOrFetch(player)).getProperty(PhantomsProperties.ANTI_PHANTOM).booleanValue()));
    }

    private void resetRestTime() {
        for (Player player : ((SunLightPlugin)this.plugin).getServer().getOnlinePlayers()) {
            SunUser user = (SunUser)((SunLightPlugin)this.plugin).getUserManager().getOrFetch(player);
            if (!user.getProperty(PhantomsProperties.ANTI_PHANTOM).booleanValue()) continue;
            player.setStatistic(Statistic.TIME_SINCE_REST, 0);
        }
    }
}

