/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.nametags.handler;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerTeams;
import io.github.retrooper.packetevents.adventure.serializer.gson.GsonComponentSerializer;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.bridge.paper.PaperBridge;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.Version;
import su.nightexpress.nightcore.util.bridge.Software;
import su.nightexpress.nightcore.util.text.night.NightMessage;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.nametags.handler.NametagHandler;

public class PacketsTagHandler
extends NametagHandler {
    public PacketsTagHandler(@NotNull SunLightPlugin plugin) {
        super(plugin);
    }

    protected void onLoad() {
    }

    protected void onShutdown() {
    }

    @Override
    protected void sendPacket(@NotNull NametagHandler.TeamMode mode, @NotNull String teamId, @NotNull String teamPrefix, @NotNull String teamSuffix, @NotNull String teamColorRaw, @NotNull Player playerOfTeam, @NotNull Collection<? extends Player> receivers) {
        WrapperPlayServerTeams.CollisionRule collisionRule;
        Team.OptionStatus status;
        Scoreboard scoreboard = playerOfTeam.getScoreboard();
        Team team = scoreboard.getEntryTeam(playerOfTeam.getName());
        Team.OptionStatus optionStatus = status = team == null ? null : team.getOption(Team.Option.COLLISION_RULE);
        if (status == null) {
            collisionRule = WrapperPlayServerTeams.CollisionRule.ALWAYS;
        } else {
            switch (status) {
                default: {
                    throw new MatchException(null, null);
                }
                case NEVER: {
                    collisionRule = WrapperPlayServerTeams.CollisionRule.NEVER;
                    break;
                }
                case ALWAYS: {
                    collisionRule = WrapperPlayServerTeams.CollisionRule.ALWAYS;
                    break;
                }
                case FOR_OWN_TEAM: {
                    collisionRule = WrapperPlayServerTeams.CollisionRule.PUSH_OWN_TEAM;
                    break;
                }
                case FOR_OTHER_TEAMS: {
                    collisionRule = WrapperPlayServerTeams.CollisionRule.PUSH_OTHER_TEAMS;
                }
            }
        }
        WrapperPlayServerTeams.CollisionRule collisionRule2 = collisionRule;
        WrapperPlayServerTeams.ScoreBoardTeamInfo info = null;
        if (mode == NametagHandler.TeamMode.CREATE) {
            info = new WrapperPlayServerTeams.ScoreBoardTeamInfo((Component)Component.text((String)teamId), PacketsTagHandler.adaptComponent(teamPrefix), PacketsTagHandler.adaptComponent(teamSuffix), WrapperPlayServerTeams.NameTagVisibility.ALWAYS, collisionRule2, (NamedTextColor)NamedTextColor.NAMES.valueOr((Object)teamColorRaw.toLowerCase(), (Object)NamedTextColor.GRAY), WrapperPlayServerTeams.OptionData.NONE);
        }
        WrapperPlayServerTeams.TeamMode teamMode = switch (mode) {
            default -> throw new MatchException(null, null);
            case NametagHandler.TeamMode.REMOVE -> WrapperPlayServerTeams.TeamMode.REMOVE;
            case NametagHandler.TeamMode.CREATE -> WrapperPlayServerTeams.TeamMode.CREATE;
        };
        List entities = Lists.newList((Object[])new String[]{playerOfTeam.getName()});
        WrapperPlayServerTeams teams = new WrapperPlayServerTeams(teamId, teamMode, info, (Collection)entities);
        for (Player player : receivers) {
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)teams);
        }
    }

    @NotNull
    private static Component adaptComponent(@NotNull String string) {
        if (Version.isPaper()) {
            return ((PaperBridge)Software.get()).getTextComponentAdapter().adaptComponent(NightMessage.parse((String)string));
        }
        return GsonComponentSerializer.gson().deserialize((Object)NightMessage.asJson((String)string));
    }
}

