/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.nametags;

import java.util.Comparator;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerJoinEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.Plugins;
import su.nightexpress.nightcore.util.placeholder.CommonPlaceholders;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.config.PermissionTree;
import su.nightexpress.sunlight.exception.ModuleLoadException;
import su.nightexpress.sunlight.hook.placeholder.PlaceholderRegistry;
import su.nightexpress.sunlight.module.Module;
import su.nightexpress.sunlight.module.ModuleContext;
import su.nightexpress.sunlight.module.nametags.NameTagFormat;
import su.nightexpress.sunlight.module.nametags.NametagsSettings;
import su.nightexpress.sunlight.module.nametags.handler.NametagHandler;
import su.nightexpress.sunlight.module.nametags.handler.PacketsTagHandler;
import su.nightexpress.sunlight.module.nametags.handler.ProtocolTagHandler;
import su.nightexpress.sunlight.module.nametags.listener.NametagsListener;

public class NametagsModule
extends Module {
    private final NametagsSettings settings = new NametagsSettings();
    private NametagHandler tagHandler;

    public NametagsModule(@NotNull ModuleContext context) {
        super(context);
    }

    @Override
    protected void loadModule(@NotNull FileConfig config) throws ModuleLoadException {
        this.settings.load(config);
        this.loadTagHandler();
        this.addListener((SimpeListener)new NametagsListener((SunLightPlugin)this.plugin, this));
    }

    private void loadTagHandler() {
        if (Plugins.isInstalled((String)"packetevents")) {
            this.tagHandler = new PacketsTagHandler((SunLightPlugin)this.plugin);
        } else if (Plugins.isInstalled((String)"ProtocolLib")) {
            this.tagHandler = new ProtocolTagHandler((SunLightPlugin)this.plugin);
        }
        if (this.tagHandler != null) {
            this.tagHandler.setup();
            this.addAsyncTask(this::updatePlayerNameTags, this.settings.getNameTagUpdateInterval());
        }
    }

    @Override
    protected void unloadModule() {
    }

    @Override
    protected void registerPermissions(@NotNull PermissionTree root) {
    }

    @Override
    protected void registerCommands() {
    }

    @Override
    public void registerPlaceholders(@NotNull PlaceholderRegistry registry) {
    }

    @Nullable
    public NameTagFormat getPlayerNameTagFormat(@NotNull Player player) {
        return this.settings.getNameTagFormatsMap().values().stream().filter(entry -> entry.isRankAvailable(player)).max(Comparator.comparingInt(NameTagFormat::getPriority)).orElse(null);
    }

    public void handleJoin(@NotNull PlayerJoinEvent event) {
        this.updatePlayerNameTag(event.getPlayer());
    }

    public void updatePlayerNameTag(@NotNull Player player) {
        if (this.tagHandler == null) {
            return;
        }
        NameTagFormat tag = this.getPlayerNameTagFormat(player);
        if (tag == null) {
            return;
        }
        PlaceholderContext placeholderContext = PlaceholderContext.builder().with(CommonPlaceholders.PLAYER.resolver((Object)player)).andThen(CommonPlaceholders.forPlaceholderAPI((Player)player)).build();
        this.tagHandler.sendTeamPacket(player, tag, placeholderContext);
    }

    public void updatePlayerNameTags() {
        Players.getOnline().forEach(this::updatePlayerNameTag);
    }
}

