/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.kits.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.ConfigProperty;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.configuration.ConfigTypes;
import su.nightexpress.nightcore.ui.inventory.item.MenuItem;
import su.nightexpress.nightcore.ui.inventory.menu.AbstractObjectMenu;
import su.nightexpress.nightcore.ui.inventory.viewer.ViewerContext;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.kits.KitsModule;
import su.nightexpress.sunlight.module.kits.model.Kit;
import su.nightexpress.sunlight.module.kits.model.KitContent;

public class KitPreviewMenu
extends AbstractObjectMenu<Kit> {
    private final KitsModule module;
    private List<Integer> fusedSlots;

    public KitPreviewMenu(@NotNull SunLightPlugin plugin, @NotNull KitsModule module) {
        super((MenuType)MenuType.GENERIC_9X6, "Kit Preview", Kit.class);
        this.module = module;
        this.load(plugin, FileConfig.load((String)module.getLocalUIPath(), (String)"kit_preview.yml"));
    }

    public void registerActions() {
    }

    public void registerConditions() {
    }

    public void defineDefaultLayout() {
        this.addBackgroundItem(Material.GRAY_STAINED_GLASS_PANE, IntStream.range(5, 9).toArray());
        this.addBackgroundItem(Material.BLACK_STAINED_GLASS_PANE, IntStream.range(9, 18).toArray());
        this.addDefaultButton("return", MenuItem.builder().defaultState(NightItem.fromType((Material)Material.ARROW).setDisplayName(TagWrappers.WHITE.wrap("Back to Kits")), context -> this.module.openKitsMenu(context.getPlayer())).slots(new int[]{8}).build());
    }

    protected void onLoad(@NotNull FileConfig config) {
        int[] hotbarSlots = (int[])ConfigProperty.of((ConfigType)ConfigTypes.INT_ARRAY, (String)"Content.Hotbar-Slots", (Object)IntStream.range(45, 54).toArray(), (String[])new String[0]).resolveWithDefaults(config);
        int[] itemSlots = (int[])ConfigProperty.of((ConfigType)ConfigTypes.INT_ARRAY, (String)"Content.Inventory-Slots", (Object)IntStream.range(18, 45).toArray(), (String[])new String[0]).resolveWithDefaults(config);
        int[] armorSlots = (int[])ConfigProperty.of((ConfigType)ConfigTypes.INT_ARRAY, (String)"Content.Armor-Slots", (Object)IntStream.range(0, 4).toArray(), (String[])new String[0]).resolveWithDefaults(config);
        int[] extraSlots = (int[])ConfigProperty.of((ConfigType)ConfigTypes.INT_ARRAY, (String)"Content.Extra-Slots", (Object)new int[]{4}, (String[])new String[0]).resolveWithDefaults(config);
        this.fusedSlots = new ArrayList<Integer>();
        this.fusedSlots.addAll(IntStream.of(hotbarSlots).boxed().toList());
        this.fusedSlots.addAll(IntStream.of(itemSlots).boxed().toList());
        this.fusedSlots.addAll(IntStream.of(armorSlots).boxed().toList());
        this.fusedSlots.addAll(IntStream.of(extraSlots).boxed().toList());
    }

    protected void onClick(@NotNull ViewerContext context, @NotNull InventoryClickEvent event) {
    }

    protected void onDrag(@NotNull ViewerContext context, @NotNull InventoryDragEvent event) {
    }

    protected void onClose(@NotNull ViewerContext context, @NotNull InventoryCloseEvent event) {
    }

    public void onPrepare(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory, @NotNull List<MenuItem> items) {
        Kit kit = (Kit)this.getObject(context);
        KitContent content = kit.definition().getContent();
        content.getItemBySlotMap().forEach((slotIndex, item) -> {
            if (slotIndex >= this.fusedSlots.size()) {
                return;
            }
            int slot = this.fusedSlots.get((int)slotIndex);
            item.itemStack().ifPresent(itemStack -> inventory.setItem(slot, itemStack));
        });
    }

    public void onReady(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }

    public void onRender(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }
}

