/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.kits.editor;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.ui.inventory.item.ItemState;
import su.nightexpress.nightcore.ui.inventory.item.MenuItem;
import su.nightexpress.nightcore.ui.inventory.menu.AbstractObjectMenu;
import su.nightexpress.nightcore.ui.inventory.viewer.ViewerContext;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.nightcore.util.time.TimeFormatType;
import su.nightexpress.nightcore.util.time.TimeFormats;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.dialog.DialogRegistry;
import su.nightexpress.sunlight.module.kits.KitsModule;
import su.nightexpress.sunlight.module.kits.config.KitsLang;
import su.nightexpress.sunlight.module.kits.dialog.KitDialogKeys;
import su.nightexpress.sunlight.module.kits.model.Kit;

public class KitSettingsEditorMenu
extends AbstractObjectMenu<Kit>
implements LangContainer {
    public static final IconLocale ICON_NAME = LangEntry.iconBuilder((String)"Kits.UI.Editor.KitSettings.Name").name("Display Name").appendCurrent("Current", "%kit_name%").br().appendClick("Click to change").build();
    public static final IconLocale ICON_DESCRIPTION = LangEntry.iconBuilder((String)"Kits.UI.Editor.KitSettings.Description").name("Description").rawLore(new String[]{"%kit_description%"}).br().appendClick("Click to change").build();
    public static final IconLocale ICON_ICON = LangEntry.iconBuilder((String)"Kits.UI.Editor.KitSettings.Icon").name("Icon").appendCurrent("Icon Mode", "%state%").br().appendInfo(new String[]{"Enable the icon mode", "and click item in inventory", "to replace kit icon."}).br().appendClick("Click to toggle").build();
    public static final IconLocale ICON_PERMISSION = LangEntry.iconBuilder((String)"Kits.UI.Editor.KitSettings.Permission").name("Permission Requirement").appendCurrent("Required", "%state%").appendCurrent("Node", "%value%").br().appendInfo(new String[]{"Whether permission is requried", "to use this kit."}).br().appendClick("Click to toggle").build();
    public static final IconLocale ICON_COOLDOWN = LangEntry.iconBuilder((String)"Kits.UI.Editor.KitSettings.Cooldown").name("Cooldown").appendCurrent("Current", "%time%").br().appendInfo(new String[]{"Sets the kit cooldown."}).br().appendClick("Click to change").build();
    public static final IconLocale ICON_COST = LangEntry.iconBuilder((String)"Kits.UI.Editor.KitSettings.Cost").name("Cost").appendCurrent("Current", "%value%").br().appendInfo(new String[]{"Sets how much player must pay", "to use this kit."}).br().appendClick("Click to change").build();
    public static final IconLocale ICON_PRIORITY = LangEntry.iconBuilder((String)"Kits.UI.Editor.KitSettings.Priority").name("Priority").appendCurrent("Current", "%value%").br().appendInfo(new String[]{"Kits with higher priority", "appears first in the GUI."}).br().appendClick("Click to change").build();
    public static final IconLocale ICON_COMMANDS = LangEntry.iconBuilder((String)"Kits.UI.Editor.KitSettings.Commands").name("Commands").rawLore(new String[]{"%value%"}).br().appendInfo(new String[]{"Runs listed commands when", "player receives this kit."}).br().appendClick("Click to change").build();
    public static final IconLocale ICON_INVENTORY = LangEntry.iconBuilder((String)"Kits.UI.Editor.KitSettings.Inventory").name("Inventory Content").appendClick("Click to edit").build();
    public static final IconLocale ICON_RETURN = LangEntry.iconBuilder((String)"Kits.UI.Editor.KitSettings.Return").accentColor((TagWrapper)TagWrappers.SOFT_RED).name("Back to Kits").appendClick("Click to return").build();
    private final KitsModule module;
    private final DialogRegistry dialogRegistry;
    private boolean iconMode;

    public KitSettingsEditorMenu(@NotNull SunLightPlugin plugin, @NotNull KitsModule module, @NotNull DialogRegistry dialogRegistry) {
        super((MenuType)MenuType.GENERIC_9X5, KitsLang.EDITOR_TITLE_SETTINGS.text(), Kit.class);
        this.module = module;
        this.dialogRegistry = dialogRegistry;
        plugin.injectLang(this);
        this.load(plugin);
    }

    public void registerActions() {
    }

    public void registerConditions() {
    }

    public void defineDefaultLayout() {
        this.addDefaultButton("return", MenuItem.builder().defaultState(NightItem.fromType((Material)Material.ARROW).localized(ICON_RETURN), context -> this.module.openEditor(context.getPlayer())).slots(new int[]{40}).build());
        this.addDefaultButton("kit_name", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.NAME_TAG).localized(ICON_NAME)).displayModifier((context, item) -> item.replace(builder -> builder.with(((Kit)this.getObject(context)).placeholders()))).action(context -> this.dialogRegistry.show(context.getPlayer(), KitDialogKeys.KIT_NAME, (Kit)this.getObject((ViewerContext)context), () -> context.getViewer().refresh())).build()).slots(new int[]{11}).build());
        this.addDefaultButton("kit_description", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.WRITABLE_BOOK).localized(ICON_DESCRIPTION)).displayModifier((context, item) -> item.replace(builder -> builder.with(((Kit)this.getObject(context)).placeholders()))).action(context -> this.dialogRegistry.show(context.getPlayer(), KitDialogKeys.KIT_DESCRIPTION, (Kit)this.getObject((ViewerContext)context), () -> context.getViewer().refresh())).build()).slots(new int[]{12}).build());
        this.addDefaultButton("kit_priority", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.COMPARATOR).localized(ICON_PRIORITY)).displayModifier((context, item) -> item.replace(builder -> builder.with("%value%", () -> String.valueOf(((Kit)this.getObject(context)).definition().getPriority())))).action(context -> this.dialogRegistry.show(context.getPlayer(), KitDialogKeys.KIT_PRIORITY, (Kit)this.getObject((ViewerContext)context), () -> context.getViewer().refresh())).build()).slots(new int[]{14}).build());
        this.addDefaultButton("kit_permission", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.REDSTONE).localized(ICON_PERMISSION)).displayModifier((context, item) -> item.replace(builder -> builder.with("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(((Kit)this.getObject(context)).definition().isPermissionRequired())).with("%value%", () -> ((Kit)this.getObject(context)).getPermission()))).action(context -> {
            Kit kit = (Kit)this.getObject((ViewerContext)context);
            kit.definition().setPermissionRequired(!kit.definition().isPermissionRequired());
            kit.markDirty();
            context.getViewer().refresh();
        }).build()).slots(new int[]{15}).build());
        this.addDefaultButton("kit_cost", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.GOLD_NUGGET).localized(ICON_COST)).displayModifier((context, item) -> item.replace(builder -> builder.with("%value%", () -> NumberUtil.format((double)((Kit)this.getObject(context)).definition().getCost())))).action(context -> this.dialogRegistry.show(context.getPlayer(), KitDialogKeys.KIT_COST, (Kit)this.getObject((ViewerContext)context), () -> context.getViewer().refresh())).build()).slots(new int[]{20}).build());
        this.addDefaultButton("kit_cooldown", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.CLOCK).localized(ICON_COOLDOWN)).displayModifier((context, item) -> item.replace(builder -> builder.with("%time%", () -> TimeFormats.formatAmount((long)TimeUnit.SECONDS.toMillis(((Kit)this.getObject(context)).definition().getCooldown()), (TimeFormatType)TimeFormatType.LITERAL)))).action(context -> this.dialogRegistry.show(context.getPlayer(), KitDialogKeys.KIT_COOLDOWN, (Kit)this.getObject((ViewerContext)context), () -> context.getViewer().refresh())).build()).slots(new int[]{21}).build());
        this.addDefaultButton("commands", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.COMMAND_BLOCK).localized(ICON_COMMANDS)).displayModifier((context, item) -> item.replace(builder -> builder.with("%value%", () -> String.join((CharSequence)TagWrappers.BR, ((Kit)this.getObject(context)).definition().getCommands())))).action(context -> this.dialogRegistry.show(context.getPlayer(), KitDialogKeys.KIT_COMMANDS, (Kit)this.getObject((ViewerContext)context), () -> context.getViewer().refresh())).build()).slots(new int[]{22}).build());
        this.addDefaultButton("inventory_content", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.CHEST_MINECART).localized(ICON_INVENTORY)).displayModifier((context, item) -> item.replace(builder -> builder.with(((Kit)this.getObject(context)).placeholders()))).action(context -> this.module.openContentEditor(context.getPlayer(), (Kit)this.getObject((ViewerContext)context))).build()).slots(new int[]{24}).build());
    }

    protected void onLoad(@NotNull FileConfig config) {
    }

    protected void onClick(@NotNull ViewerContext context, @NotNull InventoryClickEvent event) {
        if (this.iconMode) {
            if (event.getRawSlot() <= event.getInventory().getSize()) {
                return;
            }
            ItemStack itemStack = event.getCurrentItem();
            if (itemStack == null || itemStack.getType().isAir()) {
                return;
            }
            Kit kit = (Kit)this.getObject(context);
            kit.definition().setIcon(NightItem.fromItemStack((ItemStack)itemStack));
            kit.markDirty();
            this.iconMode = false;
            context.getViewer().refresh();
        }
    }

    protected void onDrag(@NotNull ViewerContext context, @NotNull InventoryDragEvent event) {
    }

    protected void onClose(@NotNull ViewerContext context, @NotNull InventoryCloseEvent event) {
        this.iconMode = false;
    }

    public void onPrepare(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory, @NotNull List<MenuItem> items) {
        items.add(MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(((Kit)this.getObject(context)).definition().getIcon().localized(ICON_ICON)).displayModifier((viewerContext, item) -> item.replace(builder -> builder.with("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(this.iconMode)))).action(actionContext -> {
            this.iconMode = !this.iconMode;
            context.getViewer().refresh();
        }).build()).slots(new int[]{13}).build());
    }

    public void onReady(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }

    public void onRender(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }
}

