/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.kits.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.bridge.item.AdaptedItem;
import su.nightexpress.nightcore.bridge.item.ItemAdapter;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.integration.item.ItemBridge;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.ui.inventory.action.ActionContext;
import su.nightexpress.nightcore.ui.inventory.item.MenuItem;
import su.nightexpress.nightcore.ui.inventory.menu.AbstractObjectMenu;
import su.nightexpress.nightcore.ui.inventory.viewer.ViewerContext;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.kits.KitsModule;
import su.nightexpress.sunlight.module.kits.config.KitsLang;
import su.nightexpress.sunlight.module.kits.model.Kit;
import su.nightexpress.sunlight.module.kits.model.KitContent;

public class KitContentEditorMenu
extends AbstractObjectMenu<Data>
implements LangContainer {
    private static final IconLocale ICON_SAVE = LangEntry.iconBuilder((String)"Kits.UI.Editor.KitContent.Save").accentColor((TagWrapper)TagWrappers.GREEN).name("Save").br().appendInfo(new String[]{"Saves changes."}).br().appendClick("Click to save").build();
    private static final IconLocale ICON_CANCEL = LangEntry.iconBuilder((String)"Kits.UI.Editor.KitContent.Cancel").accentColor((TagWrapper)TagWrappers.RED).name("Cancel").br().appendInfo(new String[]{"Discard changes and return."}).br().appendClick("Click to cancel").build();
    private static final IconLocale ICON_COPY_INVENTORY = LangEntry.iconBuilder((String)"Kits.UI.Editor.KitContent.CopyInventory").accentColor((TagWrapper)TagWrappers.YELLOW).name("Copy Inventory").br().appendInfo(new String[]{"Copies your whole inventory."}).br().appendClick("Click to copy").build();
    private static final int[] HOTBAR_SLOTS = IntStream.range(45, 54).toArray();
    private static final int[] INVENTORY_SLOTS = IntStream.range(18, 45).toArray();
    private static final int[] ARMOR_SLOTS = IntStream.range(0, 4).toArray();
    private static final int[] EXTRA_SLOTS = new int[]{4};
    private static final List<Integer> FUSED_SLOTS = new ArrayList<Integer>();
    private final KitsModule module;

    public KitContentEditorMenu(@NotNull SunLightPlugin plugin, @NotNull KitsModule module) {
        super((MenuType)MenuType.GENERIC_9X6, KitsLang.EDITOR_TITLE_CONTENT.text(), Data.class);
        this.module = module;
        plugin.injectLang(this);
        this.load(plugin);
    }

    public boolean show(@NotNull NightPlugin plugin, @NotNull Player player, @NotNull Kit kit) {
        return this.show(plugin, player, new Data(kit, KitContent.copyOf(kit.definition().getContent())));
    }

    public void registerActions() {
    }

    public void registerConditions() {
    }

    public void defineDefaultLayout() {
        this.addBackgroundItem(Material.BLACK_STAINED_GLASS_PANE, IntStream.range(9, 18).toArray());
        this.addBackgroundItem(Material.GRAY_STAINED_GLASS_PANE, new int[]{5});
        this.addDefaultButton("copy", MenuItem.builder().defaultState(NightItem.fromType((Material)Material.NETHER_STAR).localized(ICON_COPY_INVENTORY), this::copyInventory).slots(new int[]{6}).build());
        this.addDefaultButton("save", MenuItem.builder().defaultState(NightItem.fromType((Material)Material.LIME_WOOL).localized(ICON_SAVE), this::save).slots(new int[]{7}).build());
        this.addDefaultButton("cancel", MenuItem.builder().defaultState(NightItem.fromType((Material)Material.RED_WOOL).localized(ICON_CANCEL), context -> this.module.openSettingsEditor(context.getPlayer(), ((Data)this.getObject((ViewerContext)context)).kit)).slots(new int[]{8}).build());
    }

    protected void onLoad(@NotNull FileConfig config) {
    }

    protected void onClick(@NotNull ViewerContext context, @NotNull InventoryClickEvent event) {
        if (event.getRawSlot() > event.getInventory().getSize() || FUSED_SLOTS.contains(event.getRawSlot())) {
            event.setCancelled(false);
            context.getViewer().setNextClickIn(0L);
        }
    }

    protected void onDrag(@NotNull ViewerContext context, @NotNull InventoryDragEvent event) {
    }

    protected void onClose(@NotNull ViewerContext context, @NotNull InventoryCloseEvent event) {
    }

    public void onPrepare(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory, @NotNull List<MenuItem> items) {
        Data data = (Data)this.getObject(context);
        KitContent content = data.contentCopy;
        content.getItemBySlotMap().forEach((slotIndex, adaptedItem) -> {
            int slot = FUSED_SLOTS.get((int)slotIndex);
            adaptedItem.itemStack().ifPresent(itemStack -> inventory.setItem(slot, itemStack));
        });
    }

    public void onReady(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }

    public void onRender(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }

    private void save(@NotNull ActionContext context) {
        Data data = (Data)this.getObject((ViewerContext)context);
        Kit kit = data.kit;
        KitContent content = data.contentCopy;
        Inventory inventory = context.getEvent().getInventory();
        this.transferItems(content, inventory, FUSED_SLOTS::get);
        kit.definition().setContent(content);
        kit.markDirty();
        this.module.openSettingsEditor(context.getPlayer(), kit);
    }

    private void copyInventory(@NotNull ActionContext context) {
        Data data = (Data)this.getObject((ViewerContext)context);
        KitContent content = data.contentCopy;
        PlayerInventory inventory = context.getPlayer().getInventory();
        this.transferItems(content, (Inventory)inventory, slot -> slot);
        context.getViewer().refresh();
    }

    private void transferItems(@NotNull KitContent content, @NotNull Inventory inventory, @NotNull Function<Integer, Integer> slotMapper) {
        int slot;
        Map<Integer, AdaptedItem> itemBySlotMap = content.getItemBySlotMap();
        itemBySlotMap.clear();
        for (int slotIndex = 0; slotIndex < FUSED_SLOTS.size() && (slot = slotMapper.apply(slotIndex).intValue()) < inventory.getSize(); ++slotIndex) {
            AdaptedItem adaptedItem;
            ItemAdapter adapter;
            ItemStack itemStack = inventory.getItem(slot);
            if (itemStack == null || itemStack.getType().isAir() || (adapter = (ItemAdapter)ItemBridge.adapter((ItemStack)itemStack).orElse(null)) == null || (adaptedItem = (AdaptedItem)adapter.adapt(itemStack).orElse(null)) == null) continue;
            itemBySlotMap.put(slotIndex, adaptedItem);
        }
    }

    static {
        FUSED_SLOTS.addAll(IntStream.of(HOTBAR_SLOTS).boxed().toList());
        FUSED_SLOTS.addAll(IntStream.of(INVENTORY_SLOTS).boxed().toList());
        FUSED_SLOTS.addAll(IntStream.of(ARMOR_SLOTS).boxed().toList());
        FUSED_SLOTS.addAll(IntStream.of(EXTRA_SLOTS).boxed().toList());
    }

    public record Data(@NotNull Kit kit, @NotNull KitContent contentCopy) {
    }
}

